#ifndef __SYS_POLL_H
#define __SYS_POLL_H

#include <SYS/TYPES.H>

__BEGIN_DECLS

struct pollfd {
	int fd;
	short events;
	short revents;
};

#define POLLIN		0x0001
#define POLLPRI		0x0002
#define POLLOUT		0x0004
#define POLLERR		0x0008
#define POLLHUP		0x0010
#define POLLNVAL	0x0020

#define POLLRDNORM	POLLIN
#define POLLRDBAND	POLLPRI
#define POLLWRNORM	POLLOUT
#define POLLWRBAND	POLLOUT

#define INFTIM		-1

int poll(struct pollfd *fds, unsigned nfds, int timeout);

__END_DECLS

#endif
