#ifndef __SYS_SOUNDCARD_H
#define __SYS_SOUNDCARD_H

#include <SYS/IOCTL.H>
#include <SYS/TYPES.H>
#include <ENDIAN.H>

/*
 * DSP
 */

#define _FMT_MU_LAW	0
#define _FMT_A_LAW	1
#define _FMT_S8		2
#define _FMT_U8		3
#define _FMT_S16_LE	4
#define _FMT_S16_BE	5
#define _FMT_U16_LE	6
#define _FMT_U16_BE	7
#define _FMT_S32_LE	8
#define _FMT_S32_BE	9
#define _FMT_U32_LE	10
#define _FMT_U32_BE	11
#define _FMT_IMA_ADPCM	12
#define _FMT_MPEG	13
#define _FMT_AC3	14
#define _FMT_FLOAT	15

#define _FMT_MAX	15

static __finline__ int _FMT_SIZE(int fmt)	/* must not be > 4 */
{
	switch (fmt) {
		case _FMT_S16_LE:
		case _FMT_S16_BE:
		case _FMT_U16_LE:
		case _FMT_U16_BE:
			return 2;
		case _FMT_S32_LE:
		case _FMT_S32_BE:
		case _FMT_U32_LE:
		case _FMT_U32_BE:
		case _FMT_FLOAT:
			return 4;
		default:
			return 1;
	}
}

static __finline__ unsigned long _FMT_DIV(unsigned long val, int fmt, int channels)
{
	switch (fmt) {
		case _FMT_S16_LE:
		case _FMT_S16_BE:
		case _FMT_U16_LE:
		case _FMT_U16_BE:
			val >>= 1;
			break;
		case _FMT_S32_LE:
		case _FMT_S32_BE:
		case _FMT_U32_LE:
		case _FMT_U32_BE:
		case _FMT_FLOAT:
			val >>= 2;
			break;
	}
	if (__likely(channels == 1)) val >>= 1;
	else if (__unlikely(channels > 1)) val /= __likely(channels + 1) ? channels + 1 : 1;
	return val;
}

		/* SNDCTL_DSP_GETFMTS */
#define AFMT_QUERY	0
#define AFMT_MU_LAW	(1 << _FMT_MU_LAW)
#define AFMT_A_LAW	(1 << _FMT_A_LAW)
#define AFMT_U8		(1 << _FMT_U8)
#define AFMT_S8		(1 << _FMT_S8)
#define AFMT_U16_LE	(1 << _FMT_U16_LE)
#define AFMT_U16_BE	(1 << _FMT_U16_BE)
#define AFMT_S16_LE	(1 << _FMT_S16_LE)
#define AFMT_S16_BE	(1 << _FMT_S16_BE)
#define AFMT_U32_LE	(1 << _FMT_U32_LE)
#define AFMT_U32_BE	(1 << _FMT_U32_BE)
#define AFMT_S32_LE	(1 << _FMT_S32_LE)
#define AFMT_S32_BE	(1 << _FMT_S32_BE)
#define AFMT_IMA_ADPCM	(1 << _FMT_IMA_ADPCM)
#define AFMT_MPEG	(1 << _FMT_MPEG)
#define AFMT_AC3	(1 << _FMT_AC3)
#define AFMT_FLOAT	(1 << _FMT_FLOAT)
#if defined(__LITTLE_ENDIAN)
#define AFMT_S16_NE	AFMT_S16_LE
#define AFMT_U16_NE	AFMT_U16_LE
#define AFMT_S32_NE	AFMT_S32_LE
#define AFMT_U32_NE	AFMT_U32_LE
#elif defined(__BIG_ENDIAN)
#define AFMT_S16_NE	AFMT_S16_BE
#define AFMT_U16_NE	AFMT_U16_BE
#define AFMT_S32_NE	AFMT_S32_BE
#define AFMT_U32_NE	AFMT_U32_BE
#else
	Unknown endian !!!
#endif

		/* SNDCTL_DSP_GETI/OSPACE */
typedef struct audio_buf_info {
	int fragments;
	int fragstotal;
	int fragsize;
	int bytes;
} audio_buf_info;

		/* SNDCTL_DSP_GETCAPS */
#define DSP_CAP_REVISION	0x00ff
#define DSP_CAP_DUPLEX		0x0100
#define DSP_CAP_REALTIME	0x0200
#define DSP_CAP_BATCH		0x0400
#define DSP_CAP_COPROC		0x0800
#define DSP_CAP_TRIGGER		0x1000
#define DSP_CAP_MMAP		0x2000
#define DSP_CAP_MULTI		0x4000
#define DSP_CAP_BIND		0x8000

		/* SNDCTL_DSP_GET/SETTRIGGER */
#define PCM_ENABLE_INPUT	1
#define PCM_ENABLE_OUTPUT	2

		/* SNDCTL_DSP_GETI/OPTR */
typedef struct count_info {
	int bytes;
	int blocks;
	int ptr;
} count_info;

		/* SNDCTL_DSP_GETERROR */
typedef struct audio_errinfo {
	int play_underruns;
	int rec_overruns;
	unsigned long play_ptradjust;
	unsigned long rec_ptradjust;
	int play_errorcount;
	int rec_errorcount;
	int play_lasterror;
	int rec_lasterror;
	long play_errorparm;
	long rec_errorparm;
} audio_errinfo;

/*
 * MIXER
 */

#define SOUND_MIXER_VOLUME		0
#define SOUND_MIXER_BASS		1
#define SOUND_MIXER_TREBLE		2
#define SOUND_MIXER_SYNTH		3
#define SOUND_MIXER_PCM			4
#define SOUND_MIXER_SPEAKER		5
#define SOUND_MIXER_LINE		6
#define SOUND_MIXER_LINE1		7
#define SOUND_MIXER_LINE2		8
#define SOUND_MIXER_LINE3		9
#define SOUND_MIXER_MIC			10
#define SOUND_MIXER_CD			11
#define SOUND_MIXER_IMIX		12
#define SOUND_MIXER_RECLEV		13
#define SOUND_MIXER_AUX_OUT		14
#define SOUND_MIXER_MONO_OUT		15
#define SOUND_MIXER_NRDEVICES		16

#define SOUND_DEVICE_LABELS		{ "Volume", "Bass", "Treble", "Synth",\
					"Pcm", "Speaker", "Line", "Line1",\
					"Line2", "Line3", "Mic", "CD",\
					"Monitor", "Rec", "Aux", "Mono" }

#define SOUND_DEVICE_NAMES		{ "vol", "bass", "treble", "synth",\
					"pcm", "speaker", "line", "line1",\
					"line2", "line3", "mic", "cd",\
					"monitor", "rec", "aux", "mono" }

#define SOUND_MIXER_CAPS		32
#define  SOUND_CAP_EXCL_INPUT		 1
#define SOUND_MIXER_DEVMASK		33
#define SOUND_MIXER_STEREODEVS		34
#define SOUND_MIXER_RECSRC		35
#define SOUND_MIXER_RECMASK		36
#define SOUND_MIXER_OUTSRC		37
#define SOUND_MIXER_OUTMASK		38

#define SOUND_MASK_VOLUME		(1 << SOUND_MIXER_VOLUME)
#define SOUND_MASK_BASS			(1 << SOUND_MIXER_BASS)
#define SOUND_MASK_TREBLE		(1 << SOUND_MIXER_TREBLE)
#define SOUND_MASK_SYNTH		(1 << SOUND_MIXER_SYNTH)
#define SOUND_MASK_PCM			(1 << SOUND_MIXER_PCM)
#define SOUND_MASK_SPEAKER		(1 << SOUND_MIXER_SPEAKER)
#define SOUND_MASK_LINE			(1 << SOUND_MIXER_LINE)
#define SOUND_MASK_LINE1		(1 << SOUND_MIXER_LINE1)
#define SOUND_MASK_LINE2		(1 << SOUND_MIXER_LINE2)
#define SOUND_MASK_LINE3		(1 << SOUND_MIXER_LINE3)
#define SOUND_MASK_MIC			(1 << SOUND_MIXER_MIC)
#define SOUND_MASK_CD			(1 << SOUND_MIXER_CD)
#define SOUND_MASK_IMIX			(1 << SOUND_MIXER_IMIX)
#define SOUND_MASK_RECLEV		(1 << SOUND_MIXER_RECLEV)
#define SOUND_MASK_AUX_OUT		(1 << SOUND_MIXER_AUX_OUT)
#define SOUND_MASK_MONO_OUT		(1 << SOUND_MIXER_MONO_OUT)

#define MIXER_READ(parm)		(_SOUND_MIXER_READ + (parm))
#define MIXER_WRITE(parm)		(_SOUND_MIXER_WRITE + (parm))

#define SOUND_MIXER_READ_VOLUME		MIXER_READ(SOUND_MIXER_VOLUME)
#define SOUND_MIXER_READ_BASS		MIXER_READ(SOUND_MIXER_BASS)
#define SOUND_MIXER_READ_TREBLE		MIXER_READ(SOUND_MIXER_TREBLE)
#define SOUND_MIXER_READ_SYNTH		MIXER_READ(SOUND_MIXER_SYNTH)
#define SOUND_MIXER_READ_PCM		MIXER_READ(SOUND_MIXER_PCM)
#define SOUND_MIXER_READ_SPEAKER	MIXER_READ(SOUND_MIXER_SPEAKER)
#define SOUND_MIXER_READ_LINE		MIXER_READ(SOUND_MIXER_LINE)
#define SOUND_MIXER_READ_LINE1		MIXER_READ(SOUND_MIXER_LINE1)
#define SOUND_MIXER_READ_LINE2		MIXER_READ(SOUND_MIXER_LINE2)
#define SOUND_MIXER_READ_LINE3		MIXER_READ(SOUND_MIXER_LINE3)
#define SOUND_MIXER_READ_MIC		MIXER_READ(SOUND_MIXER_MIC)
#define SOUND_MIXER_READ_CD		MIXER_READ(SOUND_MIXER_CD)
#define SOUND_MIXER_READ_IMIX		MIXER_READ(SOUND_MIXER_IMIX)
#define SOUND_MIXER_READ_RECLEV		MIXER_READ(SOUND_MIXER_RECLEV)
#define SOUND_MIXER_READ_RECSRC		MIXER_READ(SOUND_MIXER_RECSRC)
#define SOUND_MIXER_READ_DEVMASK	MIXER_READ(SOUND_MIXER_DEVMASK)
#define SOUND_MIXER_READ_RECMASK	MIXER_READ(SOUND_MIXER_RECMASK)
#define SOUND_MIXER_READ_CAPS		MIXER_READ(SOUND_MIXER_CAPS)
#define SOUND_MIXER_READ_STEREODEVS	MIXER_READ(SOUND_MIXER_STEREODEVS)
#define SOUND_MIXER_READ_OUTSRC		MIXER_READ(SOUND_MIXER_OUTSRC)
#define SOUND_MIXER_READ_OUTMASK	MIXER_READ(SOUND_MIXER_OUTMASK)

#define SOUND_MIXER_WRITE_VOLUME	MIXER_WRITE(SOUND_MIXER_VOLUME)
#define SOUND_MIXER_WRITE_BASS		MIXER_WRITE(SOUND_MIXER_BASS)
#define SOUND_MIXER_WRITE_TREBLE	MIXER_WRITE(SOUND_MIXER_TREBLE)
#define SOUND_MIXER_WRITE_SYNTH		MIXER_WRITE(SOUND_MIXER_SYNTH)
#define SOUND_MIXER_WRITE_PCM		MIXER_WRITE(SOUND_MIXER_PCM)
#define SOUND_MIXER_WRITE_SPEAKER	MIXER_WRITE(SOUND_MIXER_SPEAKER)
#define SOUND_MIXER_WRITE_LINE		MIXER_WRITE(SOUND_MIXER_LINE)
#define SOUND_MIXER_WRITE_LINE1		MIXER_WRITE(SOUND_MIXER_LINE1)
#define SOUND_MIXER_WRITE_LINE2		MIXER_WRITE(SOUND_MIXER_LINE2)
#define SOUND_MIXER_WRITE_LINE3		MIXER_WRITE(SOUND_MIXER_LINE3)
#define SOUND_MIXER_WRITE_MIC		MIXER_WRITE(SOUND_MIXER_MIC)
#define SOUND_MIXER_WRITE_CD		MIXER_WRITE(SOUND_MIXER_CD)
#define SOUND_MIXER_WRITE_IMIX		MIXER_WRITE(SOUND_MIXER_IMIX)
#define SOUND_MIXER_WRITE_RECLEV	MIXER_WRITE(SOUND_MIXER_RECLEV)
#define SOUND_MIXER_WRITE_RECSRC	MIXER_WRITE(SOUND_MIXER_RECSRC)
#define SOUND_MIXER_WRITE_OUTSRC	MIXER_WRITE(SOUND_MIXER_OUTSRC)

#endif
