#ifndef __SYS_STATFS_H
#define __SYS_STATFS_H

#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>

__BEGIN_DECLS

#define MFSNAMELEN	16

#define MNT_RDONLY	0x0001
#define MNT_NOATIME	0x0002
#define MNT_ACLS	0x0004
#define MNT_QUOTA	0x0008
#define MNT_UNION	0x0010
#define MNT_SYNCHRONOUS	0x0100
#define MNT_ASYNC	0x0200
#define MNT_SOFTDEP	0x0400

typedef struct {
	unsigned long val[2];
} fsid_t;

struct statfs {
	long f_bsize;
	long f_iosize;
	fsblkcnt_t f_blocks;
	fsblkcnt_t f_bfree;
	fsblkcnt_t f_bavail;
	fsfilcnt_t f_files;
	fsfilcnt_t f_ffree;
	fsfilcnt_t f_favail;
	__u64 f_type;
	fsid_t f_fsid;
	int f_namelen;
	unsigned f_flags;
	char f_fstypename[MFSNAMELEN];
	char f_fsmntonname[__MAX_STR_LEN];
	char f_fsmntfromname[__MAX_STR_LEN];
};

int fstatfs(int, struct statfs *);
int statfs(const char *, struct statfs *);

__END_DECLS

#endif
