#ifndef __SYS_STATVFS_H
#define __SYS_STATVFS_H

#include <SYS/TYPES.H>

__BEGIN_DECLS

#define FSTYPSZ	16

struct statvfs {
	unsigned long f_frsize;
	unsigned long f_bsize;
	fsblkcnt_t f_blocks;
	fsblkcnt_t f_bfree;
	fsblkcnt_t f_bavail;
	fsfilcnt_t f_files;
	fsfilcnt_t f_ffree;
	fsfilcnt_t f_favail;
	unsigned long f_fsid;
	unsigned long f_flag;
	unsigned long f_namemax;
	char f_basetype[FSTYPSZ];
};

#define ST_RDONLY	0x01
#define ST_NOSUID	0x02

int fstatvfs(int, struct statvfs *);
int statvfs(const char *, struct statvfs *);

__END_DECLS

#endif
