#ifndef __TYPES_H
#define __TYPES_H

#include <ARCH/SETUP.H>

#ifndef __P
#define __P(x)	x
#endif
#ifndef __cplusplus
#ifndef __BEGIN_DECLS
#define __BEGIN_DECLS
#endif
#ifndef __END_DECLS
#define __END_DECLS
#endif
#else
#ifndef __BEGIN_DECLS
#define __BEGIN_DECLS	extern "C" {
#endif
#ifndef __END_DECLS
#define __END_DECLS	}
#endif
#endif

#ifdef __GNUC__
#define __PRINTF_ATTR__(c, ch) __attribute__ ((__format__ (__printf__, c, ch)))
#define __PRINTF0_ATTR__(c, ch) /*__attribute__ ((__format__ (__printf0__, c, ch)))*/
#define __FORMAT_ATTR__(c) __attribute__ ((__format_arg__ (c)))
#define __SCANF_ATTR__(c, ch) __attribute__ ((__format__ (__scanf__, c, ch)))
#define __CONST_ATTR__ __attribute__((__const__))
#define __NORET_ATTR__ __attribute__((__noreturn__))
#define __ALIGN_ATTR__(x) __attribute__((__aligned__(x)))
#if __GNUC__ >= 3
#define __MALLOC_ATTR__ __attribute__((__malloc__))
#define __PURE_ATTR__ __attribute__((__pure__))
#else
#define __MALLOC_ATTR__
#define __PURE_ATTR__
#endif
#if __GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 1)
#define __finline__	__inline__ __attribute__((__always_inline__))
#else
#define __finline__	__inline__
#endif
/* gcc has some bug --- it sometimes thinks that external addresses
   are constant (it happens if they are passed to inline function)
   (x) + (x) is a workaround */
#define __is_constant(x)	__builtin_constant_p((x) + (x))
#else
#define __PRINTF_ATTR__(c, ch)
#define __PRINTF0_ATTR__(c, ch)
#define __FORMAT_ATTR__(c)
#define __SCANF_ATTR__(c, ch)
#define __CONST_ATTR__
#define __NORET_ATTR__
#define __ALIGN_ATTR__(x)
#define __MALLOC_ATTR__
#define __PURE_ATTR__
#define __finline__		inline
#define __is_constant(x)	(0)
#endif

#if (__DEBUG >= 2) && defined(__GNUC__) && 0
static __inline__ void __attribute__ ((__format__ (__printf__, 1, 2))) ___checkint(char *__p, ...) { }
#define __checkint(__a, __b)	___checkint(__a, __b),
#else
#define __checkint(__a, __b)
#endif

#if !defined(__GNUC__) || (__GNUC__ <= 2 && __GNUC_MINOR__ < 96)
#define __likely(x)	(__checkint("%d", x) (int)(x))
#define __unlikely(x)	(__checkint("%d", x) (int)(x))
#else
#define __likely(x)	(__checkint("%d", x) __builtin_expect((int)(x),1))
#define __unlikely(x)	(__checkint("%d", x) __builtin_expect((int)(x),0))
#endif

#include <ARCH/TYPES.H>
#include <ARCH/BT.H>

#include <ENDIAN.H>

	/* it is probably not compliant to this, but bash needs it to compile */
#ifdef _POSIX_VERSION
#undef _POSIX_VERSION
#endif
#define _POSIX_VERSION		199009L

typedef __s64 __sec_t;
typedef __u64 __usec_t;

#define __sec_t_format __64_format

#ifndef __CROSS_COMPILING_LINKER
typedef unsigned mode_t;
typedef __u16 uid_t;
typedef __u16 gid_t;
typedef __u64 dev_t;
typedef __s64 pid_t;
typedef __s64 time_t;
typedef long suseconds_t;
typedef __u64 ino_t;
typedef unsigned nlink_t;
typedef int blksize_t;
typedef __s64 blkcnt_t;
typedef int key_t;
typedef time_t clock_t;
typedef __u64 fsblkcnt_t;
typedef __u64 fsfilcnt_t;

typedef __s8 int8_t;
typedef __s16 int16_t;
typedef __s32 int32_t;
typedef __s64 int64_t;

typedef __u8 uint8_t;
typedef __u16 uint16_t;
typedef __u32 uint32_t;
typedef __u64 uint64_t;

typedef __u8 u_int8_t;
typedef __u16 u_int16_t;
typedef __u32 u_int32_t;
typedef __u64 u_int64_t;

typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned u_int;
typedef unsigned long u_long;
typedef int64_t quad_t;
typedef uint64_t u_quad_t;

typedef char *caddr_t;
typedef __const__ char *c_caddr_t;
typedef volatile char *v_caddr_t;
typedef long intptr_t;
typedef unsigned long uintptr_t;

typedef double __double_t;
typedef double __float_t;

typedef __s32 __ct_rune_t;
typedef __ct_rune_t __rune_t;
#ifndef	__cplusplus
typedef __ct_rune_t __wchar_t;
#else
typedef wchar_t __wchar_t;
#endif
typedef __ct_rune_t __wint_t;

typedef union {
	char __mbstate8[128];
	__s64 _mbstateL;
} __mbstate_t;

#define __offsetof(type, field) ((size_t)(&((type *)0)->field))

#define __warn_references(sym,msg)

#if defined(__GNUC__) && defined(__OPTIMIZE__)
void __unreachable_node(void);
#define __unreachable_code()	__unreachable_node();
#else
#define __unreachable_code()	KERNEL$SUICIDE("__unreachable_code");
#endif

#define NBBY		8

#ifndef FD_SETSIZE
#define FD_SETSIZE	1024
#endif

typedef unsigned long   fd_mask;
#define NFDBITS (sizeof(fd_mask) * NBBY)	/* bits per mask */

#ifndef howmany
#define howmany(x, y)   (((x) + ((y) - 1)) / (y))
#endif

typedef struct fd_set {
	fd_mask fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

/*
#define _fdset_mask(n)	((fd_mask)1 << ((n) & (NFDBITS - 1)))
#define FD_SET(n, p)	((p)->fds_bits[(unsigned)(n)/NFDBITS] |= _fdset_mask(n))
#define FD_CLR(n, p)	((p)->fds_bits[(unsigned)(n)/NFDBITS] &= ~_fdset_mask(n))
#define FD_ISSET(n, p)	((p)->fds_bits[(unsigned)(n)/NFDBITS] & _fdset_mask(n))
*/
#define FD_SET(n, p)	__BS((p)->fds_bits, n)
#define FD_CLR(n, p)	__BR((p)->fds_bits, n)
#define FD_ISSET(n, p)	__BT((p)->fds_bits, n)
#define FD_COPY(f, t)	(*(t) = *(f))
#define FD_ZERO(p)	do { unsigned __i; for (__i = 0; __i < (unsigned)howmany(FD_SETSIZE, NFDBITS); __i++) (p)->fds_bits[__i] = 0; } while (0)

typedef struct __pthread_s *pthread_t;
typedef unsigned long pthread_key_t;

typedef struct {
	struct __pthread_attr_s *__p;
} pthread_attr_t;

typedef struct {
	struct __pthread_cond_s *__p;
	int __pshared;
	volatile int __shared_cnt;
} pthread_cond_t;

typedef struct {
	struct __pthread_condattr_s *__p;
} pthread_condattr_t;

#define __PTHREAD_ID_ENTRIES	8
#define __PTHREAD_ID_LEN	(__PTHREAD_ID_ENTRIES * 4)

typedef struct {
	struct __pthread_mutex_s *__p;
	int __pshared;
	int __mtype;
	volatile int __shared_val;
	volatile int __recurse_cnt;
	volatile pthread_t __owner;
	__u32 __owner_id[__PTHREAD_ID_ENTRIES];
} pthread_mutex_t;

typedef struct {
	struct __pthread_mutexattr_s *__p;
} pthread_mutexattr_t;

typedef long pthread_once_t;

typedef struct {
	struct __pthread_rwlock_s *__p;
	int __pshared;
	int __shared_val;
	int __wr_blocked;
	volatile int __shmem_lock;
} pthread_rwlock_t;

typedef struct {
	struct __pthread_rwlockattr_s *__p;
} pthread_rwlockattr_t;

typedef struct {
	volatile int __spin;
} pthread_spinlock_t;

#endif

#endif
