#ifndef __UNISTD_H
#define __UNISTD_H

#include <SYS/TYPES.H>

#ifndef SEEK_SET
#define	SEEK_SET	0
#endif
#ifndef SEEK_CUR
#define	SEEK_CUR	1
#endif
#ifndef SEEK_END
#define	SEEK_END	2
#endif

#define L_SET	SEEK_SET
#define L_INCR	SEEK_CUR
#define L_XTND	SEEK_END

__BEGIN_DECLS

void __NORET_ATTR__ _exit(int __status);
int getdtablesize(void);
int dup(int __h);
int dup2(int __h, int __to);
int close(int __h);
ssize_t read(int __h, void *__buf, size_t __size);
ssize_t write(int __h, __const__ void *__buf, size_t __size);
ssize_t pread(int __h, void *__buf, size_t __size, off_t __offset);
ssize_t pwrite(int __h, __const__ void *__buf, size_t __size, off_t __offset);
off_t lseek(int __h, off_t __offset, int __whence);
int ftruncate(int __h, off_t __offset);
int truncate(__const__ char *__filename, off_t __offset);

int fchown(int __h, uid_t __owner, gid_t __group);
int chown(__const__ char *__filename, uid_t __owner, gid_t __group);
int lchown(__const__ char *__filename, uid_t __owner, gid_t __group);
int fchownat(int __dirfd, __const__ char *__filename, uid_t __owner, gid_t __group, int flags);

int fsync(int __fd);
int fdatasync(int __fd);

int chdir(__const__ char *__path);
int fchdir(int __fd);
char *getcwd(char *__buf, size_t __size);
char *getcwdat(int __dirfd, char *__buf, size_t __size);
char *get_current_dir_name(void);
char *getwd(char *__buf);

int rmdir(__const__ char *__filename);
int unlink(__const__ char *__filename);
int unlinkat(int __dirfd, __const__ char *__filename, int __flags);
int link(__const__ char *__oldpath, const char *__newpath);
int linkat(int __olddirfd, __const__ char *__oldpath, int __newdirfd, __const__ char *__newpath, int __flags);
int symlink(__const__ char *__oldpath, const char *__newpath);
int symlinkat(__const__ char *__oldpath, int __newdirfd, const char *__newpath);
int readlink(__const__ char *__filename, char *__buf, size_t __bufsiz);
int readlinkat(int __dirfd, __const__ char *__filename, char *__buf, size_t __bufsiz);
int eaccess(__const__ char *__filename, int __mode);
int access(__const__ char *__filename, int __mode);
int faccessat(int __dirfd, __const__ char *__filename, int __mode, int __flags);

#define	F_OK	0
#define X_OK	1
#define W_OK	2
#define R_OK	4

char *_join_paths(__const__ char *__dir, __const__ char *__file);
int _is_local(__const__ char *__path);
int _is_absolute(__const__ char *__path);
char *_fullpath(char *__buf, __const__ char *__path, size_t __size);
char *_fullpathat(char *__buf, int __dirfd, __const__ char *__path, size_t __size);

#define _ABS_NO		0
#define _ABS_CURROOT	1
#define _ABS_LOGREL	2
#define _ABS_TOTAL	3

int pipe(int *__fd);

int pause(void);

size_t getpagesize(void);
pid_t getpid(void);
pid_t getppid(void);
uid_t getuid(void);
int setuid(uid_t __u);
gid_t getgid(void);
int setgid(gid_t __u);
uid_t geteuid(void);
int seteuid(uid_t __u);
gid_t getegid(void);
int setegid(gid_t __u);
int setreuid(uid_t __r, uid_t __e);
int setregid(gid_t __r, gid_t __e);
int getgroups(int __size, gid_t *__list);
int setgroups(size_t __size, const gid_t *__list);

int setpgid(pid_t __pid, pid_t __pgid);
pid_t getpgid(pid_t __pid);
int setpgrp(pid_t __pid, pid_t __pgid);
pid_t getpgrp(void);
pid_t setsid(void);

int issetugid(void);

unsigned sleep(unsigned __seconds);
int usleep(unsigned long __usec);

char *getlogin __P((void));
int getlogin_r __P((char *, int));

int sync __P((void));

pid_t fork __P((void));
pid_t vfork __P((void));
int execl(__const__ char *__path, __const__ char *__arg, ...);
int execlp(__const__ char *__file, __const__ char *__arg, ...);
int execle(__const__ char *__path, __const__ char *__arg, ...);
int execv(__const__ char *__path, char *__const__ __argv[]);
int execvp(__const__ char *__file, char *__const__ __argv[]);
int execve(__const__ char *__path, char *__const__ __argv[], char *__const__ __envp[]);
int pthread_atfork(void (*)(void), void (*)(void), void (*)(void));

struct timeval;
int select __P((int, fd_set *, fd_set *, fd_set *, struct timeval *));

int brk(void *__end);
void *sbrk(ssize_t __inc);

void swab(const void *, void *, ssize_t);

extern int KERNEL$__NEEDCANCEL;
extern void (*KERNEL$__CANCEL_START_FN)(void);
extern void (*KERNEL$__CANCEL_END_FN)(void);
extern void (*KERNEL$__CANCEL_TEST_FN)(void);

#define __cancel_start()						\
do {									\
	if (__unlikely(KERNEL$__NEEDCANCEL)) KERNEL$__CANCEL_START_FN();\
} while (0)

#define __cancel_end()							\
do {									\
	if (__unlikely(KERNEL$__NEEDCANCEL)) KERNEL$__CANCEL_END_FN();	\
} while (0)

#define __cancel_test()							\
do {									\
	if (__unlikely(KERNEL$__NEEDCANCEL)) KERNEL$__CANCEL_TEST_FN();	\
} while (0)

#define __cancel_in(a)							\
do {									\
	if (__likely(!KERNEL$__NEEDCANCEL)) {				\
		a;							\
	} else {							\
		KERNEL$__CANCEL_START_FN();				\
		a;							\
		KERNEL$__CANCEL_END_FN();				\
	}								\
} while (0)

/*-
 * Copyright (c) 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)unistd.h	8.12 (Berkeley) 4/27/95
 * $FreeBSD: src/include/unistd.h,v 1.35.2.10 2002/04/15 12:52:28 nectar Exp $
 */

#define STDIN_FILENO	0
#define STDOUT_FILENO	1
#define STDERR_FILENO	2

#ifndef _POSIX_SOURCE
#define	F_ULOCK		0	/* unlock locked section */
#define	F_LOCK		1	/* lock a section for exclusive use */
#define	F_TLOCK		2	/* test and lock a section for exclusive use */
#define	F_TEST		3	/* test a section for locks by other procs */
#endif

int getopt(int, char *__const__ [], __const__ char *);
extern char *optarg;
extern int optind;
extern int opterr;
extern int optopt;

extern char *suboptarg;
int getsubopt (char **, char *__const__ *, char **);

int mkstemps(char *, int);
int mkstemp(char *);
char *mkdtemp(char *);
char *mktemp(char *);

unsigned alarm __P((unsigned));
char	*crypt __P((const char *, const char *));
const char *crypt_get_format __P((void));
int	crypt_set_format __P((const char *));
int	isatty __P((int));
int	lockf __P((int, int, off_t));
int	nice __P((int));
char	*getpass __P((const char *));
int	getdomainname __P((char *, size_t));
int	gethostname __P((char *, size_t));
long	sysconf __P((int));
pid_t	tcgetpgrp __P((int));
int	tcsetpgrp __P((int, pid_t));
char	*ttyname __P((int));
unsigned ualarm __P((unsigned, unsigned));
long	fpathconf __P((int, int));
long	pathconf __P((const char *, int));

#define _SC_ARG_MAX		1
#define _SC_CHILD_MAX		2
#define _SC_CLK_TCK		3
#define _SC_NGROUPS_MAX		4
#define _SC_OPEN_MAX		5
#define _SC_JOB_CONTROL		6
#define _SC_SAVED_IDS		7
#define _SC_VERSION		8
#define _SC_BC_BASE_MAX		9
#define _SC_BC_DIM_MAX		10
#define _SC_BC_SCALE_MAX	11
#define _SC_BC_STRING_MAX	12
#define _SC_COLL_WEIGHTS_MAX	13
#define _SC_EXPR_NEST_MAX	14
#define _SC_LINE_MAX		15
#define _SC_RE_DUP_MAX		16
#define _SC_2_VERSION		17
#define _SC_2_C_BIND		18
#define _SC_2_C_DEV		19
#define _SC_2_CHAR_TERM		20
#define _SC_2_FORT_DEV		21
#define _SC_2_FORT_RUN		22
#define _SC_2_LOCALEDEF		23
#define _SC_2_SW_DEV		24
#define _SC_2_UPE		25
#define _SC_STREAM_MAX		26
#define _SC_TZNAME_MAX		27
#define _SC_ASYNCHRONOUS_IO	28
#define _SC_MAPPED_FILES	29
#define _SC_MEMLOCK		30
#define _SC_MEMLOCK_RANGE	31
#define _SC_MEMORY_PROTECTION	32
#define _SC_MESSAGE_PASSING	33
#define _SC_PRIORITIZED_IO	34
#define _SC_PRIORITY_SCHEDULING 35
#define _SC_REALTIME_SIGNALS	36
#define _SC_SEMAPHORES		37
#define _SC_FSYNC		38
#define _SC_SHARED_MEMORY_OBJECTS 39
#define _SC_SYNCHRONIZED_IO	40
#define _SC_TIMERS		41
#define _SC_AIO_LISTIO_MAX	42
#define _SC_AIO_MAX		43
#define _SC_AIO_PRIO_DELTA_MAX	44
#define _SC_DELAYTIMER_MAX	45
#define _SC_MQ_OPEN_MAX		46
#define _SC_PAGESIZE		47
#define _SC_RTSIG_MAX		48
#define _SC_SEM_NSEMS_MAX	49
#define _SC_SEM_VALUE_MAX	50
#define _SC_SIGQUEUE_MAX	51
#define _SC_TIMER_MAX		52

#define _SC_NPROCESSORS_CONF	57
#define _SC_NPROCESSORS_ONLN	58


#define _PC_LINK_MAX		1
#define _PC_MAX_CANON		2
#define _PC_MAX_INPUT		3
#define _PC_NAME_MAX		4
#define _PC_PATH_MAX		5
#define _PC_PIPE_BUF		6
#define _PC_CHOWN_RESTRICTED	7
#define _PC_NO_TRUNC		8
#define _PC_VDISABLE		9

#define _POSIX_THREAD_SAFE_FUNCTIONS	200112L

__END_DECLS

#endif
