#include <SPAD/DEV_KRNL.H>
#include <KERNEL/VMDEF.H>

static unsigned rq = 0;
static unsigned long total_size = 0;

#if KERNEL_BOUNCE_NEEDED == 0

int KERNEL$RESERVE_BOUNCE(char *device, unsigned requests, unsigned long size)
{
	int spl;
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_TOP);
	rq += requests;
	total_size += size;
	LOWER_SPLX(spl);
	return 0;
}

	/* must not block */
void KERNEL$UNRESERVE_BOUNCE(char *device, unsigned requests, unsigned long size)
{
	int spl;
	if (requests > rq || size > total_size) KERNEL$SUICIDE("KERNEL$UNRESERVE_BOUNCE: UNDERRUN, RESERVED(%u,%lu), FREEING(%u, %lu)", rq, total_size, requests, size);
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_TOP);
	rq -= requests;
	total_size -= size;
	LOWER_SPLX(spl);
}

#else

!!! FIXME

#endif
