#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>
#include <STRING.H>
#include <SPAD/LINK.H>

#include <PRG/BIND_SYS/FSDCODE.H>

void FSD_SET_ENTRY(void *e);

long FSD_DIR(char *ptr, long *cookie, char *error);
long FSD_OPEN(char *file, char *error);
int FSD_READ(void *ptr, int size, char *error);
int FSD_CLOSE(char *error);


static long (*FSD_ENTRY)(int code, void *ptr, long n, void *self, char **error);

void FSD_SET_ENTRY(void *e)
{
	/*__debug_printf("FSD: entry %p\n", e);*/
	FSD_ENTRY = (void *)((char *)e + __offsetof(struct link_header, startup_code));
}

long FSD_DIR(char *ptr, long *cookie, char *error)
{
	char *err;
	long new_cookie = FSD_ENTRY(FSD_DIR_CODE, ptr, *cookie, FSD_ENTRY, &err);
	if (new_cookie == -1) {
		strlcpy(error, err, __MAX_STR_LEN);
		return -1;
	}
	*cookie = new_cookie;
	return 0;
}

long FSD_OPEN(char *file, char *error)
{
	char *err;
	long len = FSD_ENTRY(FSD_OPEN_CODE, file, 0, FSD_ENTRY, &err);
	if (len == -1) {
		strlcpy(error, err, __MAX_STR_LEN);
		return -1;
	}
	return len;
}

int FSD_READ(void *ptr, int size, char *error)
{
	char *err;
	long code = FSD_ENTRY(FSD_READ_CODE, ptr, size, FSD_ENTRY, &err);
	if (code == -1) {
		strlcpy(error, err, __MAX_STR_LEN);
		return -1;
	}
	return 0;
}

int FSD_CLOSE(char *error)
{
	char *err;
	long code = FSD_ENTRY(FSD_CLOSE_CODE, NULL, 0, FSD_ENTRY, &err);
	if (code == -1) {
		strlcpy(error, err, __MAX_STR_LEN);
		return -1;
	}
	return 0;
}

