#include <SPAD/LIBC.H>
#include <KERNEL/THREAD.H>
#include <KERNEL/DEV.H>
#include <SPAD/DL.H>
#include <KERNEL/ASM.H>
#include <SPAD/SHELL.H>
#include <SPAD/VM.H>
#include <KERNEL/MFS.H>
#include <KERNEL/PROC.H>
#include <KERNEL/ENV.H>
#include <KERNEL/PARAMS.H>
#include <STRING.H>

static DLLZRQ dl;
static SHRCRQ shrcrq;
static SHCCRQ shccrq;
static CTX *ctx;

extern AST_STUB MFS_INITIALIZED;
extern AST_STUB INIT_LINKED;
extern AST_STUB INIT_CREATED_CONTEXT;
extern AST_STUB INIT_CONFIG_EXECUTED;

void INIT_KERNEL(void);

void INIT_KERNEL(void)
{
	ENV_INIT();
	THREAD_INIT();
	CACHE_INIT();
	DEV_INIT();
	KERNEL_PROC_INIT();
	PARAMS_INIT();
	/*
	slab_test();
	malloc_test();
	wq_test();
	timer_test();
	kbd_test();
	KERNEL$SUICIDE("reloc passed...: %p", INIT_KERNEL);
	wq_test();
	timer_test();
	*/
	MFS_INIT(MFS_INITIALIZED);
}

DECL_AST(MFS_INITIALIZED, SPL_DEV, IORQ)
{
	if (RQ->status) {
		__critical_printf("UNABLE TO REGISTER MFS: %s\n", strerror(-RQ->status));
		HALT_KERNEL();
	}
	memset(&dl, 0, sizeof(dl));
	dl.fn = &INIT_LINKED;
	dl.handle = __DL_GET_KERNEL_HANDLE();
	dl.caller = NULL;
	strlcpy(dl.modname, "SHELL", __MAX_STR_LEN);
	RETURN_IORQ(&dl, KERNEL$DL_LOAD_LAZY);
}

DECL_AST(INIT_LINKED, SPL_DEV, DLLZRQ)
{
	if (RQ->status) {
		__critical_printf("UNABLE TO LOAD SHELL: %s\n", RQ->error);
		HALT_KERNEL();
	}
	shccrq.fn = &INIT_CREATED_CONTEXT;
	RETURN_IORQ(&shccrq, SHELL$CREATE_CONTEXT);
}

DECL_AST(INIT_CREATED_CONTEXT, SPL_DEV, SHCCRQ)
{
	if (__unlikely(RQ->status < 0)) {
		__critical_printf("UNABLE TO ALLOCATE SHELL CONTEXT: %s\n", strerror(-RQ->status));
		HALT_KERNEL();
	}
	shrcrq.fn = &INIT_CONFIG_EXECUTED;
	ctx = shrcrq.ctx = RQ->ctx;
	shrcrq.ptr = "CALL MFS:/CONFIG.SYS";
	shrcrq.len = strlen(shrcrq.ptr);
	shrcrq.narg = 0;
	shrcrq.arg = NULL;
	RETURN_IORQ(&shrcrq, SHELL$RUN_COMMANDS);
}

DECL_AST(INIT_CONFIG_EXECUTED, SPL_DEV, SHRCRQ)
{
	__critical_printf("SHELL FINISHED WITH EXIT CODE %ld%s%s\n", RQ->status, *RQ->error_msg ? ": " : "", RQ->error_msg);
	RETURN;
}


