#include <SPAD/LIST.H>
#include <KERNEL/ASM.H>

#include <ARCH/IO.H>

static DECL_LIST(ports);

	/* !!! SMPFIX: use some spinlock here */
int KERNEL$REGISTER_IO_RANGE(IO_RANGE *p)
{
	IO_RANGE *pp;
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_ALMOST_TOP), spl)))
		KERNEL$SUICIDE("KERNEL$REGISTER_IO_RANGE AT SPL %08X", spl);
	RAISE_SPL(SPL_ALMOST_TOP);
	LIST_FOR_EACH(pp, &ports, IO_RANGE, list) {
		if (__unlikely(pp == p))
			KERNEL$SUICIDE("KERNEL$REGISTER_IO_RANGE: REGISTERING RANGE "IO_FORMAT" - "IO_FORMAT" TWICE", p->start, p->start + p->len - 1);
		if (__unlikely(pp->start >= p->start + p->len)) break;
		if (__likely(pp->start + pp->len <= p->start)) continue;
		LOWER_SPLX(spl);
		return -EBUSY;
	}
	ADD_TO_LIST_BEFORE(&pp->list, &p->list);
	LOWER_SPLX(spl);
	return 0;
}

void KERNEL$UNREGISTER_IO_RANGE(IO_RANGE *p)
{
	IO_RANGE *pp;
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_ALMOST_TOP), spl)))
		KERNEL$SUICIDE("KERNEL$UNREGISTER_IO_RANGE AT SPL %08X", spl);
	RAISE_SPL(SPL_ALMOST_TOP);
	LIST_FOR_EACH(pp, &ports, IO_RANGE, list) if (pp == p) goto found;
	KERNEL$SUICIDE("KERNEL$UNREGISTER_IO_RANGE: UNREGISTERING NON-REGISTERED RANGE "IO_FORMAT" - "IO_FORMAT"", p->start, p->start + p->len - 1);
	found:
	DEL_FROM_LIST(&p->list);
	LOWER_SPLX(spl);
}

