#include <SPAD/LIBC.H>
#include <UNISTD.H>
#include <STRING.H>
#include <KERNEL/CONSOLE.H>
#include <KERNEL/ASM.H>
#include <ARCH/IO.H>
#include <SYS/UTSNAME.H>
#include <KERNEL/RELEASE.H>
#include <ARCH/ID.H>

__const__ int KERNEL$KERNEL = 1;

int errno;

char *__progname = "KERNEL";

static void cp_call(void *x, __const__ char *data, int len)
{
	CONSOLE_WRITE(data, len);
}

int __critical_printf(__const__ char *fmt, ...)
{
	int i;
	va_list args;
	va_start(args, fmt);
	i = __vxprintf(cp_call, NULL, fmt, args);
	va_end(args);
	return i;
}

int __critical_vprintf(__const__ char *fmt, va_list args)
{
	return __vxprintf(cp_call, NULL, fmt, args);
}

void (* volatile KERNEL$SUICIDE_RESTORE_VIDEOMODE)(void) = NULL;
int (* volatile KERNEL$SUICIDE_DUMP)(void) = NULL;
void * volatile KERNEL$SUICIDE_DUMP_PARAM = NULL;

void KERNEL$SUICIDE(__const__ char *fmt, ...)
{
	va_list args;
	va_start(args, fmt);
	KERNEL$DI();
	if (KERNEL$SUICIDE_RESTORE_VIDEOMODE) KERNEL$SUICIDE_RESTORE_VIDEOMODE();
	__critical_printf("SYSTEM SUICIDE: ");
	__vxprintf(cp_call, NULL, fmt, args);
	__critical_printf("\n");
	HALT_KERNEL_STKDUMP();
}

void _exit_msg(int status, __const__ char *msg)
{
	KERNEL$SUICIDE("KERNEL ATTEMPTED TO EXIT, STATUS %d%s%s", status, msg ? ", " : "", msg ? msg : "");
}

void _exit(int status)
{
	_exit_msg(status, NULL);
}

void _stop(char *msg)
{
	KERNEL$SUICIDE("KERNEL ATTEMPTED TO STOP%s%s", msg && *msg ? ": " : "", msg ? msg : "");
}

void _background(char *msg)
{
}

void (*__exit_func)(int status);

int uname(struct utsname *buf)
{
	char *e;
	memset(buf, 0, sizeof(struct utsname));
	strlcpy(buf->sysname, "SPAD", SYS_NMLN);
	if (!(e = getenv("HOSTNAME"))) e = "";
	strlcpy(buf->nodename, e, SYS_NMLN);
	strlcpy(buf->release, SPAD_RELEASE, SYS_NMLN);
	strlcpy(buf->version, SPAD_VERSION, SYS_NMLN);
	strlcpy(buf->machine, ARCH_ID, SYS_NMLN);
	if (!(e = getenv("DOMAINNAME"))) e = "";
	strlcpy(buf->domainname, e, SYS_NMLN);
	return 0;
}

