#include <STRING.H>
#include <SPAD/HASH.H>
#include <SPAD/TIMER.H>
#include <SPAD/WQ.H>
#include <KERNEL/DEV.H>
#include <KERNEL/KSPAWN.H>
#include <KERNEL/UDATA.H>
#include <SPAD/IOCTL.H>
#include <SPAD/CD.H>
#include <SYS/MMAN.H>
#include <KERNEL/PROC.H>
#include <STDLIB.H>
#include <SPAD/ENV.H>
#include <KERNEL/SYSCALL.H>
#include <SIGNAL.H>
#include <LIB/KERNEL/USIGNAL.H>
#include <LIB/KERNEL/UTHREAD.H>
#include <LIB/KERNEL/UIO.H>
#include <LIB/KERNEL/ULIBC.H>
#include <KERNEL/TIMER.H>
#include <SPAD/SYNC.H>
#include <ENDIAN.H>
#include <KERNEL/SELECT.H>
#include <SPAD/LINK.H>
#include <KERNEL/LINK.H>

#include <UNISTD.H>
#include <SYS/WAIT.H>
#include <SPAD/LIBPROC.H>

#define SWAPPER_DEVICE		"SYS$SWAPPER"

#define MAX_RESWAP_TIME		5
#define RESWAP_TIME_DECAY	10

#define pcb_swapstring_size		(__MAX_STR_LEN - 1 + 2 + 8 + 1)

typedef struct {
	LIST_ENTRY list;

	KSPAWNRQ *ksp;

	char jobname[9];
	unsigned char ln_mode;
	FFILE **forktable;
	int forktable_n;
	char **options;
	int n_options;

	char **parse_params_arg;
	int parse_params_state;
	char **params;
	int n_params;
	char ***env;
	LNT lnt;
	union {
		IORQ iorq;
		MALLOC_REQUEST mrq;
		OPENRQ openrq;
		IOCTLRQ ioctlrq;
	} u;
	char *map_name;
	int mapmode;
	int swaphandle;

	char state;		/* PCB_xxx */
	char waitdone;
	char background;	/* if PCB_STOPPED */
	char terminate_flag;
	WQ wait;

	int info;
	void *session;

	void *arg;

	char swapstring[pcb_swapstring_size];

	CWD *cwd;
	IORQ *rq;
	char *init_page;
	int init_page_start;
	int init_page_end;
	unsigned long init_page_pos;
	unsigned long top_page_pos;
	unsigned long vpos;

	ENV_CALLBACK env_call;
	char **env_ptr;
	int env_pos;
	char put_mode;
	char put_env;
	char env_mod;

	char **env_copy;
	LOGICAL_LIST_REQUEST llr;
} PROC_CONTROL_BLOCK;

#define PCB_SPAWNED		0
#define PCB_DONE		1
#define PCB_SWAPPEDOUT		2
#define PCB_STOPPED		3
#define PCB_LOCKED_SPAWNED	4
#define PCB_LOCKED_DONE		5
#define PCB_LOCKED_SWAPPED	6
#define PCB_LOCKED_STOPPED	7
#define PCB_PREPARING		12
#define PCB_DESTROYING		20

#define PCB_LOCKED_MASK		4
#define PCB_STATE_MASK		(~PCB_LOCKED_MASK)

#define MAPMODE_OVERWRITE	0x01
#define MAPMODE_PRIVATE		0x02
#define MAPMODE_OPEN_NONEX	0x04
#define MAPMODE_IGNORE_NONEX	0x08
#define MAPMODE_BLOCK_NONEX	0x10
#define MAPMODE_MAPEXTRA	0x20
#define MAPMODE_UNMAP		0x40
#define MAPMODE_DEFUNMAP	0x80

#define UDATA_PAGE(s)		(UPLACE(s) & (PAGE_CLUSTER_SIZE - 1))

#define quota_options(name, quota)					\
	name ".LIMIT", OPT_LONG, 1, MAXLONG, procoffset(quota.q_limit),	\
	name ".GRANTED", OPT_LONG, 1, MAXLONG, procoffset(quota.q_granted),\
	name ".ADVANTAGE", OPT_LONG_DISADV, 1, MAX_ADVANTAGE, procoffset(quota.q_disadv)

#define sched_options(name, pmin, pmax)					\
	name ".PRI", OPT_INV_PRI, 1, PRI_MAX, procoffset(pmin),		\
	name ".PRI", OPT_INV_PRI, 1, PRI_MAX, procoffset(pmax),		\
	name ".MINPRI", OPT_INV_PRI, 1, PRI_MAX, procoffset(pmax),	\
	name ".MAXPRI", OPT_INV_PRI, 1, PRI_MAX, procoffset(pmin)

__const__ PROC_OPTION PROC_OPTIONS[] = {
	sched_options("SCHED", sch.mininvpri, sch.maxinvpri),
	sched_options("IOSCHED", iosch_mininvpri, iosch_maxinvpri),
	quota_options("SUBPROC", procq),
	quota_options("HANDLE", hq),
	quota_options("SYSCALL", uq),
	quota_options("VM", vmq),
	quota_options("PAGETABLE", pgtblq),
	quota_options("IO", ioq),
	NULL, 0, 0, 0, 0
};

extern __const__ char BOOTSTRAP_START[], BOOTSTRAP_END[];

static __finline__ int HEAP_INIT(char *page)
{
	unsigned long udt = __unlikely(KERNEL$KERNEL) ? KUPLACE(UDATA_TOP) : (unsigned long)(*(void **)UPLACE(UDATA_STRUCT + OFF_UDATA_base)) + UDATA_TOP;
	*(void **)&page[UDATA_PAGE(UDATA_STRUCT + OFF_UDATA_base)] = __unlikely(KERNEL$KERNEL) ? (void *)KUVMBASE : *(void **)UPLACE(UDATA_STRUCT + OFF_UDATA_base);
	*(void **)&page[UDATA_PAGE(UDATA_STRUCT + (int)(unsigned long)&((UDATA *)NULL)->heap_freelist)] = (void *)(((udt + sizeof(size_t) + __MALLOC_ALIGN - 1) & ~(unsigned long)(__MALLOC_ALIGN - 1)) - sizeof(size_t));
	return ((UDATA_PAGE(UDATA_TOP) + sizeof(size_t) + __MALLOC_ALIGN - 1) & ~(unsigned long)(__MALLOC_ALIGN - 1)) - sizeof(size_t);
}

static __finline__ unsigned long HEAP_ALLOC(char *page, int size, int test)
{
	unsigned long ret = (unsigned long)*(void **)&page[UDATA_PAGE(UDATA_STRUCT + (int)(unsigned long)&((UDATA *)NULL)->heap_freelist)];
	size = MALLOC_ALIGN(size);
	if (test && __unlikely(((unsigned)ret & (PAGE_CLUSTER_SIZE - 1)) + size + sizeof(HEAP_FREELIST_T) > PAGE_CLUSTER_SIZE)) return 0;
	*(void **)&page[UDATA_PAGE(UDATA_STRUCT + (int)(unsigned long)&((UDATA *)NULL)->heap_freelist)] = (void *)(ret + size);
	memset(page + (ret & (PAGE_CLUSTER_SIZE - 1)), 0, size);
	*(size_t *)&page[ret & (PAGE_CLUSTER_SIZE - 1)] = size;
	return ret + sizeof(size_t);
}

static __finline__ int HEAP_DONE(char *page)
{
	unsigned long ret = (unsigned long)*(void **)&page[UDATA_PAGE(UDATA_STRUCT + (int)(unsigned long)&((UDATA *)NULL)->heap_freelist)];
	HEAP_FREELIST_T *hf = (HEAP_FREELIST_T *)&page[ret & (PAGE_CLUSTER_SIZE - 1)];
	hf->size = (PAGE_CLUSTER_SIZE * UPAGES - sizeof(size_t) - (ret & (PAGE_CLUSTER_SIZE - 1))) & ~(size_t)(__MALLOC_ALIGN - 1);
	hf->next = NULL;
	return (unsigned long)(hf + 1) & (PAGE_CLUSTER_SIZE - 1);
}

#include <KERNEL/LIBPROCA.I>

struct subproc_ctl {
	LIST_HEAD proc_list;
	int n_procs;
	int n_swapped;
	WQ proc_wait;
	XLIST_HEAD free_kspawnrqs;
	int timer_active;
	TIMER timer;
	AST process_ast;
	unsigned reswap_time;
	time_t last_reswap_time;
	unsigned reswap_n;
	XLIST_HEAD kspawnrq_pages;
};

typedef struct {
	LIST_ENTRY list;
	KSPAWNRQ ksp;
} KSPAWNRQ_WRAPPER;

typedef struct {
	LIST_ENTRY list;
	void *addr;
} KSPAWNRQ_PAGE;

extern AST_STUB do_process_ast;

static struct subproc_ctl const_subproc_ctl;

static void _make_subproc_ctl(void)
{
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_MALLOC), spl)))
		KERNEL$SUICIDE("_make_subproc_ctl AT SPL %08X", spl);
	RAISE_SPL(SPL_MALLOC);
	if (__likely(!SUBPROC_CTL)) {
		if (__likely(!KERNEL$KERNEL)) SUBPROC_CTL = malloc(sizeof(struct subproc_ctl));
		if (__unlikely(!SUBPROC_CTL)) SUBPROC_CTL = &const_subproc_ctl;
		memset(SUBPROC_CTL, 0, sizeof(struct subproc_ctl));
		INIT_LIST(&SUBPROC_CTL->proc_list);
		WQ_INIT(&SUBPROC_CTL->proc_wait, "KERNEL$SUBPROC_CTL_PROC_WAIT");
		INIT_TIMER(&SUBPROC_CTL->timer);
		SUBPROC_CTL->process_ast.fn = do_process_ast;
		INIT_XLIST(&SUBPROC_CTL->free_kspawnrqs);
		INIT_XLIST(&SUBPROC_CTL->kspawnrq_pages);
	}
	LOWER_SPLX(spl);
}

static __finline__ void make_subproc_ctl(void)
{
	if (__unlikely(!SUBPROC_CTL)) _make_subproc_ctl();
}

static PROC_CONTROL_BLOCK *find_job(char *jobname)
{
	PROC_CONTROL_BLOCK *pcb;
	LIST_FOR_EACH(pcb, &SUBPROC_CTL->proc_list, PROC_CONTROL_BLOCK, list) if (!_strcasecmp(pcb->jobname, jobname)) return pcb;
	return NULL;
}

static PROC_CONTROL_BLOCK *find_job_active(char *jobname)
{
	PROC_CONTROL_BLOCK *pcb = find_job(jobname);
	if (__unlikely(!pcb) || __unlikely(pcb->state == PCB_DESTROYING)) return NULL;
	return pcb;
}

extern AST_STUB free_pcb_got_ll;
static void free_pcb_delete(PROC_CONTROL_BLOCK *pcb);
extern AST_STUB free_pcb_deleted;
static void free_pcb_finish(PROC_CONTROL_BLOCK *pcb);

extern AST_STUB lnte_allocated;
extern IO_STUB do_dup;
extern AST_STUB lnte_open;
extern IO_STUB proc_spawn_parse_params;
extern AST_STUB proc_swapnode_created;
extern AST_STUB proc_ioctl_tested;
extern AST_STUB copy_environ;
extern IO_STUB proc_do_spawn;

extern AST_STUB PROCESS_DONE;

static __finline__ void FREE_PCB(PROC_CONTROL_BLOCK *pcb)
{
	KSPAWNRQ *ksp = pcb->ksp;
	KSPAWNRQ_WRAPPER *kspw;
	free(pcb);
	if (__unlikely(KERNEL$KERNEL) || __unlikely(!ksp)) return;
	kspw = LIST_STRUCT(ksp, KSPAWNRQ_WRAPPER, ksp);
	ADD_TO_XLIST(&SUBPROC_CTL->free_kspawnrqs, &kspw->list);
}

static __finline__ void INIT_PCB(PROC_CONTROL_BLOCK *pcb)
{
	int i;
	pcb->ksp->lnt = &pcb->lnt;
	pcb->ksp->pcb = pcb;
	memset(pcb->jobname, 0, sizeof pcb->jobname);
	pcb->forktable = NULL;
	pcb->forktable_n = 0;
	pcb->options = NULL;
	pcb->n_options = 0;
	pcb->params = NULL;
	pcb->n_params = 0;
	pcb->arg = NULL;
	pcb->swaphandle = -1;
	pcb->state = PCB_PREPARING;
	pcb->waitdone = 0;
	pcb->init_page = NULL;
	VOID_LIST_ENTRY(&pcb->list);
	WQ_INIT(&pcb->wait, "KERNEL$PCB_WAIT");
	for (i = 0; i < LNT_HASH_SIZE; i++) INIT_XLIST(&pcb->lnt.hash[i]);
	pcb->session = NO_SESSION;
	pcb->info = 0;
	pcb->cwd = NULL;
	pcb->env_copy = NULL;
}

static PROC_CONTROL_BLOCK *ALLOC_PCB(void)
{
	PROC_CONTROL_BLOCK *pcb;
	KSPAWNRQ_WRAPPER *kspw;
	KSPAWNRQ_PAGE *pg;
	if (__unlikely(KERNEL$KERNEL)) {
		pcb = malloc(sizeof(PROC_CONTROL_BLOCK) + sizeof(KSPAWNRQ));
		if (__unlikely(!pcb)) return NULL;
		pcb->ksp = (KSPAWNRQ *)(pcb + 1);
		goto ret;
	}

	/* Reason for this: terminating process must not allocate more memory
	   (otherwise deadlock would occur) --- so posting KSPAWNRQ must not do
	   copy on write --- so we allocate pages as MAP_SHARED. We unmap them
	   in the child anyway, so there's not any sharing hapenning. The
	   allocations are split to 3 structures because when freeing them after
	   fork we must not touch the shared page and because kernel can only
	   touch the shared page. */

	pcb = malloc(sizeof(PROC_CONTROL_BLOCK));
	if (__unlikely(!pcb)) return NULL;
	if (__likely(!XLIST_EMPTY(&SUBPROC_CTL->free_kspawnrqs))) {
		kspw = LIST_STRUCT(SUBPROC_CTL->free_kspawnrqs.next, KSPAWNRQ_WRAPPER, list);
		DEL_FROM_LIST(&kspw->list);
		goto ret_set;
	}
	kspw = mmap(NULL, PAGE_CLUSTER_SIZE, PROT_READ | PROT_WRITE, MAP_SHARED | MAP_ANONYMOUS, -1, 0);
	if (__unlikely(!kspw)) {
		unmap_fail:
		munmap(kspw, PAGE_CLUSTER_SIZE);
		goto fail;
	}
	if (__unlikely(kspw == MAP_FAILED)) {
		fail:
		__slow_free(pcb);
		return NULL;
	}
	pg = malloc(sizeof(KSPAWNRQ_PAGE));
	if (__unlikely(!pg)) goto unmap_fail;
	pg->addr = kspw;
	ADD_TO_XLIST(&SUBPROC_CTL->kspawnrq_pages, &pg->list);

	while (!(((unsigned long)kspw ^ (unsigned long)(kspw + 2)) & PAGE_CLUSTER_SIZE)) {
		ADD_TO_XLIST(&SUBPROC_CTL->free_kspawnrqs, &kspw->list);
		kspw++;
	}
	ret_set:
	pcb->ksp = &kspw->ksp;
	ret:
	INIT_PCB(pcb);
	return pcb;
}

DECL_IOCALL(KERNEL$PROC_SPAWN, SPL_DEV, PROC_SPAWN_RQ)
{
	PROC_CONTROL_BLOCK *pcb;
	make_subproc_ctl();
	/*__debug_printf("proc_spawn.");*/
	if (__unlikely(!(pcb = ALLOC_PCB()))) {
		KERNEL$MEMWAIT((IORQ *)RQ, KERNEL$PROC_SPAWN, PAGE_CLUSTER_SIZE);
		RETURN;
	}
	pcb->ln_mode = RQ->default_lnm;
#if __DEBUG >= 1
	if (pcb->ln_mode != LN_NONE && pcb->ln_mode != LN_PUBLIC && __unlikely(pcb->ln_mode != LN_ALL))
		KERNEL$SUICIDE("KERNEL$PROC_SPAWN: LN MODE %d", (unsigned)pcb->ln_mode);
#endif
	pcb->parse_params_arg = RQ->params;
	pcb->parse_params_state = __STATE_NOFIRST;
	pcb->params = RQ->params;
	pcb->env = RQ->env ? &RQ->env : &environ;
	if (__unlikely(!RQ->session_change))
		KERNEL$SUICIDE("KERNEL$PROC_SPAWN: NULL SESSION");
	pcb->session = RQ->session_change;
	pcb->info = RQ->info;
	RQ->pcb = pcb;
	pcb->rq = (IORQ *)RQ;
	pcb->cwd = RQ->cwd;
	RETURN_IORQ_LSTAT(RQ, proc_spawn_parse_params);
}

static void CLOSE_LNTE_HANDLE(PROC_CONTROL_BLOCK *pcb, int h)
{
	if (__likely(h >= 0)) {
		h &= LNTE_HANDLE_MASK;
		if (__unlikely(h == pcb->swaphandle)) pcb->swaphandle = -1;
		KERNEL$FAST_CLOSE(h);
	}
}

static void free_pcb(PROC_CONTROL_BLOCK *pcb)
{
	int i;
	pcb->state = PCB_DESTROYING;
	for (i = 0; i < LNT_HASH_SIZE; i++) while (!XLIST_EMPTY(&pcb->lnt.hash[i])) {
		LNTE *lnte = LIST_STRUCT(pcb->lnt.hash[i].next, LNTE, hash);
		CLOSE_LNTE_HANDLE(pcb, lnte->handle);
		DEL_FROM_LIST(&lnte->hash);
		KERNEL$UNIVERSAL_FREE(lnte);
	}
	if (__unlikely(pcb->swaphandle != -1)) KERNEL$FAST_CLOSE(pcb->swaphandle);
	if (__unlikely(pcb->init_page != NULL)) KERNEL$FREE_KERNEL_PAGE(pcb->init_page, VM_TYPE_WIRED_MAPPED);
	for (i = 0; i < pcb->n_options; i++) KERNEL$UNIVERSAL_FREE(pcb->options[i]);
	KERNEL$UNIVERSAL_FREE(pcb->options);
	if (pcb->arg) KERNEL$UNIVERSAL_FREE(pcb->arg);
	if (pcb->env_copy) KERNEL$UNIVERSAL_FREE(pcb->env_copy);
	UIO_FREE_FORKTABLE(pcb->forktable, pcb->forktable_n);

	if (__unlikely(!pcb->jobname[0])) {
		free_pcb_finish(pcb);
		return;
	}
	pcb->llr.prefix = "";	/* !!! FIXME: use prefixes */
	pcb->llr.fn = free_pcb_got_ll;
	CALL_IORQ(&pcb->llr, KERNEL$LIST_LOGICALS);
}

DECL_AST(free_pcb_got_ll, SPL_DEV, LOGICAL_LIST_REQUEST)
{
	PROC_CONTROL_BLOCK *pcb = GET_STRUCT(RQ, PROC_CONTROL_BLOCK, llr);
	if (__unlikely(pcb->llr.status < 0)) {
		free_pcb_finish(pcb);
		RETURN;
	}
	pcb->env_pos = 0;
	free_pcb_delete(pcb);
	RETURN;
}

static void free_pcb_delete(PROC_CONTROL_BLOCK *pcb)
{
	while (pcb->env_pos < pcb->llr.n_entries) {
		char *n = pcb->llr.entries[pcb->env_pos++]->name;
		if (strncmp(n, "SYS$", 4) && strncmp(n, "NET$", 4)) continue;
		stpcpy(stpcpy(stpcpy(pcb->swapstring, n), ":/"), pcb->jobname);
		pcb->u.openrq.fn = free_pcb_deleted;
		pcb->u.openrq.flags = _O_DELETE | _O_DELETE_PROC | _O_CLOSE | _O_NOPOSIX;
		pcb->u.openrq.path = pcb->swapstring;
		pcb->u.openrq.cwd = NULL;
		CALL_IORQ(&pcb->u.openrq, KERNEL$OPEN);
		return;
	}
	KERNEL$FREE_LOGICAL_LIST(&pcb->llr);
	free_pcb_finish(pcb);
}

DECL_AST(free_pcb_deleted, SPL_DEV, OPENRQ)
{
	PROC_CONTROL_BLOCK *pcb = GET_STRUCT(RQ, PROC_CONTROL_BLOCK, u.openrq);
	free_pcb_delete(pcb);
	RETURN;
}

static void free_pcb_finish(PROC_CONTROL_BLOCK *pcb)
{
	if (__likely(pcb->list.next != &pcb->list)) {
		SUBPROC_CTL->n_procs--;
		DEL_FROM_LIST(&pcb->list);
	}
	WQ_WAKE_ALL(&pcb->wait);
	WQ_WAKE_ALL(&SUBPROC_CTL->proc_wait);
	if (pcb->rq) CALL_AST(pcb->rq);
	FREE_PCB(pcb);
	return;
}

static int is_option(char *opt, char *optend, char *val)
{
	long l;
	int i;
	for (i = 0; PROC_OPTIONS[i].name; i++) if (__unlikely(!__strcasexcmp(PROC_OPTIONS[i].name, opt, optend))) {
		switch (PROC_OPTIONS[i].type) {
			case OPT_LONG:
			case OPT_LONG_DISADV:
			case OPT_INV_PRI:
				if (__unlikely(!val)) return -EBADSYN;
				if (__unlikely(__get_number(val, val + strlen(val), 0, &l))) return -EINVAL;
				if (l < PROC_OPTIONS[i].min || l > PROC_OPTIONS[i].max) return -ERANGE;
				return 1;
			default:
				KERNEL$SUICIDE("is_option: INVALID TYPE %d", PROC_OPTIONS[i].type);
		}
	}
	return 0;
}

static size_t set_option(PROC_CONTROL_BLOCK *pcb, char *opt, char *optend, char *val)
{
	int i;
	char *v;
	size_t l, ll;
	if (__unlikely(!val)) val = "";
	l = optend - opt + 2 + strlen(val);
	for (i = 0; i < pcb->n_options; i++) {
		v = pcb->options[i];
		if (__unlikely(!__memcasexcmp(v, opt, optend)) && __likely(v[optend - opt] == '=')) {
			if (l <= __alloc_size(v) + 1) goto copy_it;
			if (l <= __alloc_size(pcb->arg)) {
				KERNEL$UNIVERSAL_FREE(v);
				get_new:
				v = pcb->arg;
				pcb->arg = NULL;
				goto copy_it;
			}
			return l;
			copy_it:
			memcpy(v, opt, optend - opt);
			v[optend - opt] = 0;
			__upcase(v);
			v[optend - opt] = '=';
			strcpy(v + (optend - opt) + 1, val);
			pcb->options[i] = v;
			return 0;
		}
	}
	ll = (pcb->n_options + 1) * sizeof(char *);
	if (ll <= __alloc_size(pcb->options)) goto array_ok;
	if (__unlikely(ll > __alloc_size(pcb->arg))) return ll;
	memcpy(pcb->arg, pcb->options, ll - sizeof(char *));
	KERNEL$UNIVERSAL_FREE(pcb->options);
	pcb->options = pcb->arg;
	pcb->arg = NULL;
	array_ok:
	if (l > __alloc_size(pcb->arg)) return l;
	pcb->n_options++;
	goto get_new;
}

static __finline__ void prepare_pcb_to_run(PROC_CONTROL_BLOCK *pcb)
{
	KSPAWNRQ *ksp = pcb->ksp;
	pcb->state = PCB_SPAWNED;
	memcpy(ksp->jobname, pcb->jobname, sizeof ksp->jobname);
	ksp->ln_mode = pcb->ln_mode;
	ksp->forktable = pcb->forktable;
	ksp->forktable_n = pcb->forktable_n;
	ksp->options = pcb->options;
	ksp->n_options = pcb->n_options;
	ksp->error[0] = 0;
	ksp->fn = PROCESS_DONE;
	ksp->tmp3 = AST_STUB_SPL(PROCESS_DONE, -1);	/* not needed in kernel, but it doesn't hurt */
}

static void run_pcb(PROC_CONTROL_BLOCK *pcb)
{
	prepare_pcb_to_run(pcb);
	CALL_IORQ(pcb->ksp, KERNEL_KSPAWN);
}

static void unlock_pcb(PROC_CONTROL_BLOCK *pcb)
{
	if (__unlikely(!(pcb->state & PCB_LOCKED_MASK)))
		KERNEL$SUICIDE("unlock pcb: UNLOCKING UNLOCKED PCB, JOB %s, STATE %d", pcb->jobname, pcb->state);
	pcb->state &= ~PCB_LOCKED_MASK;
	if (pcb->state == PCB_SWAPPEDOUT) {
		SUBPROC_CTL->n_swapped--;
		run_pcb(pcb);
	} else if (__likely(pcb->state == PCB_SPAWNED)) {
		DO_BREAK(&KERNEL$PROC_KERNEL, pcb->ksp, 0);
	} else if (__unlikely(pcb->state != PCB_STOPPED) && __unlikely(pcb->state != PCB_DONE)) KERNEL$SUICIDE("unlock_pcb: JOB %s, STATE %d", pcb->jobname, pcb->state);
	WQ_WAKE_ALL(&pcb->wait);
	WQ_WAKE_ALL(&SUBPROC_CTL->proc_wait);
}

DECL_AST(lnte_allocated, SPL_DEV, MALLOC_REQUEST)
{
	LNTE *lnte;
	char *c, *d;
	PROC_CONTROL_BLOCK *pcb = GET_STRUCT(RQ, PROC_CONTROL_BLOCK, u.mrq);
	IO_DISABLE_CHAIN_CANCEL(SPL_DEV, pcb->rq);
	/*__debug_printf("la[%s].", pcb->map_name);*/
	if (__unlikely(RQ->status < 0)) {
		pcb->rq->status = RQ->status;
		err0:
		if (pcb->state == PCB_PREPARING) {
			free_pcb(pcb);
			RETURN;
		}
		unlock_pcb(pcb);
		RETURN_AST(pcb->rq);
	}
	lnte = RQ->ptr;
	memset(lnte, 0, sizeof(LNTE));
	strcpy(lnte->name, pcb->map_name);
	lnte->user = pcb->mapmode;
	c = strchr(lnte->name, '=');
	if (c) *c++ = 0;
	if (__unlikely(__check_logical_name(lnte->name, 1))) {
		badsyn:
		pcb->rq->status = -EBADSYN;
		KERNEL$UNIVERSAL_FREE(lnte);
		goto err0;
	}
	pcb->map_name = (void *)lnte;
	if (__unlikely(pcb->mapmode & (MAPMODE_UNMAP | MAPMODE_DEFUNMAP))) {
		pcb->u.openrq.fn = lnte_open;
		pcb->u.openrq.status = 0;
		RETURN_AST(&pcb->u.openrq);
	}
	if (!c) {
		c = lnte->name + strlen(lnte->name) + 1;
		strcpy(c, lnte->name);
		if (__unlikely(!*c)) goto badsyn;
		d = c + strlen(c) - 1;
		if (*d != ':') *++d = ':';
		*++d = '/';
		*++d = 0;
	}
	pcb->u.openrq.flags =
		(__unlikely(!strcmp(lnte->name, "STDIN")) ? O_RDONLY :
		 __unlikely(!strcmp(lnte->name, "STDOUT")) || __unlikely(!strcmp(lnte->name, "STDERR")) ?
		 O_CREAT | O_WRONLY | O_APPEND : _O_NOACCESS) | _O_NOPOSIX;
	if (__unlikely(pcb->mapmode & (MAPMODE_OVERWRITE | MAPMODE_OPEN_NONEX))) {
		if (pcb->mapmode & MAPMODE_OVERWRITE) pcb->u.openrq.flags |= O_CREAT | O_TRUNC;
		if (pcb->mapmode & MAPMODE_OPEN_NONEX) pcb->u.openrq.flags |= _O_NOOPEN;
	}
	if (!strcmp(lnte->name, SWAPPER_DEVICE)) {
		pcb->u.openrq.flags = (pcb->u.openrq.flags & ~(O_ACCMODE | _O_NOOPEN)) | O_CREAT | _O_MKDIR | O_RDWR;
	}
	pcb->u.openrq.path = c;
	pcb->u.openrq.cwd = pcb->cwd;
	pcb->u.openrq.fn = lnte_open;
	if (__unlikely(c[0] == ':')) {
		long n;
		if (__unlikely(__get_number(c + 1, c + strlen(c), 0, &n))) {
			pcb->u.openrq.status = -EBADSYN;
			RETURN_AST(&pcb->u.openrq);
		}
		pcb->u.openrq.rename_handle = n;
		RETURN_IORQ_CANCELABLE(&pcb->u.openrq, do_dup, pcb->rq);
	}
	RETURN_IORQ_CANCELABLE(&pcb->u.openrq, KERNEL$OPEN, pcb->rq);
}

DECL_IOCALL(do_dup, SPL_DEV, OPENRQ)
{
	int r = _dup_noposix(RQ->rename_handle, (IORQ *)RQ, do_dup);
	if (__unlikely(r < 0)) RETURN;
	RQ->status = r;
	RETURN_AST(RQ);
}

DECL_AST(lnte_open, SPL_DEV, OPENRQ)
{
	char *c;
	int hash;
	PROC_CONTROL_BLOCK *pcb = GET_STRUCT(RQ, PROC_CONTROL_BLOCK, u.openrq);
	LNTE *lnte, *nl;
	IO_DISABLE_CHAIN_CANCEL(SPL_DEV, pcb->rq);
	if (__unlikely(RQ->status < 0)) {
		KERNEL$UNIVERSAL_FREE(pcb->map_name);
		if (__unlikely(pcb->mapmode & MAPMODE_IGNORE_NONEX) && RQ->status != -EPERM && RQ->status != -EACCES) {
			RETURN_IORQ_LSTAT(pcb->rq, proc_spawn_parse_params);
		}
		pcb->rq->status = RQ->status;
		if (pcb->state == PCB_PREPARING) {
			free_pcb(pcb);
			RETURN;
		}
		unlock_pcb(pcb);
		RETURN_AST(pcb->rq);
	}
	lnte = (LNTE *)pcb->map_name;
	if (__unlikely(pcb->mapmode & (MAPMODE_UNMAP | MAPMODE_DEFUNMAP))) {
		lnte->handle = -1;
	} else {
		if (!strcmp(lnte->name, SWAPPER_DEVICE)) pcb->swaphandle = RQ->status;
		lnte->handle = RQ->status | (__likely(!(pcb->mapmode & MAPMODE_PRIVATE)) ? LNTE_PUBLIC : 0);
		if (!strcmp(lnte->name, "STDIN") || !strcmp(lnte->name, "STDOUT") || !strcmp(lnte->name, "STDERR")) lnte->handle |= LNTE_FILE_SHARE;
		if (pcb->mapmode & MAPMODE_BLOCK_NONEX) lnte->handle |= LNTE_BLOCK_IF_NOT_FOUND;
		/*__debug_printf("name: %s, mapmode %x, handle %x\n", lnte->name, pcb->mapmode, lnte->handle);*/
	}
	c = lnte->name;
	hash = 0;
	quickcasehash(c, *c, hash);
	hash &= LNT_HASH_SIZE - 1;
	/* !!! FIXME: this may run while the process is running: use ordered lists */
	XLIST_FOR_EACH(nl, &pcb->lnt.hash[hash], LNTE, hash) if (!strcmp(nl->name, lnte->name)) {
		int h;
		if ((pcb->mapmode & MAPMODE_MAPEXTRA && !(nl->user & MAPMODE_MAPEXTRA))) {
			clr:
			CLOSE_LNTE_HANDLE(pcb, lnte->handle);
			KERNEL$UNIVERSAL_FREE(lnte);
			goto ret;
		}
		if (__unlikely(pcb->mapmode & MAPMODE_DEFUNMAP)) {
			DEL_FROM_LIST(&nl->hash);
				/* !!! SMPFIX: sync other cpus here */
			if (__unlikely(pcb->state == PCB_LOCKED_SPAWNED)) CLEAR_SUBPROC_LN_CACHE();
			CLOSE_LNTE_HANDLE(pcb, nl->handle);
			KERNEL$UNIVERSAL_FREE(nl);
			goto clr;
		}
		h = nl->handle;
		nl->handle = lnte->handle;
		nl->dev_ptr = lnte->dev_ptr;
		nl->dcall = lnte->dcall;
		nl->dcall_type = lnte->dcall_type;
		nl->dctl = lnte->dctl;
		nl->unload = lnte->unload;
		nl->user = lnte->user;
		if (__unlikely(pcb->state == PCB_LOCKED_SPAWNED)) CLEAR_SUBPROC_LN_CACHE();
		CLOSE_LNTE_HANDLE(pcb, h);
		KERNEL$UNIVERSAL_FREE(lnte);
		goto ret;
	}
	if (__unlikely(pcb->mapmode & MAPMODE_DEFUNMAP)) goto clr;
	ADD_TO_XLIST(&pcb->lnt.hash[hash], &lnte->hash);
	if (__unlikely(pcb->state == PCB_LOCKED_SPAWNED)) CLEAR_SUBPROC_LN_CACHE();
	ret:
	RETURN_IORQ_LSTAT(pcb->rq, proc_spawn_parse_params);
}

DECL_AST(arg_allocated, SPL_DEV, MALLOC_REQUEST)
{
	PROC_CONTROL_BLOCK *pcb = GET_STRUCT(RQ, PROC_CONTROL_BLOCK, u.mrq);
	IO_DISABLE_CHAIN_CANCEL(SPL_DEV, pcb->rq);
	if (__unlikely(RQ->status < 0)) {
		pcb->rq->status = RQ->status;
		if (pcb->state == PCB_PREPARING) {
			free_pcb(pcb);
			RETURN;
		}
		unlock_pcb(pcb);
		RETURN_AST(pcb->rq);
	}
	if (__unlikely(pcb->arg != NULL)) KERNEL$UNIVERSAL_FREE(pcb->arg);
	pcb->arg = RQ->ptr;
	RETURN_IORQ_LSTAT(pcb->rq, proc_spawn_parse_params);
}

DECL_IOCALL(proc_spawn_parse_params, SPL_DEV, PROC_SPAWN_RQ)
{
	PROC_CONTROL_BLOCK *bl, *pcb = RQ->pcb;
	int i;
	int o;
	char *s;
	char *jobname = NULL;
	char *opt, *optend, *val;
	char *p, *pe;

	struct __param_table params[] = {
		"MAPNONE", __PARAM_BOOL, ~0, LN_NONE, NULL,
		"MAPPUBLIC", __PARAM_BOOL, ~0, LN_PUBLIC, NULL,
		"MAPALL", __PARAM_BOOL, ~0, LN_ALL, NULL,
		"JOBNAME", __PARAM_STRING, 1, 9, NULL,	/* must be last */
		NULL, 0, 0, 0, NULL,
	};

	/*__debug_printf("parse_params[%d].", pcb->mapmode);*/

	params[0].__p = &pcb->ln_mode;
	params[1].__p = &pcb->ln_mode;
	params[2].__p = &pcb->ln_mode;
	if (pcb->state == PCB_PREPARING) params[3].__p = &jobname;
	else params[3].__name = NULL;

	if (RQ->mapextra && *RQ->mapextra) {
		/*__debug_printf("MAPEXTRA: %s.\n", RQ->mapextra);*/
		pcb->map_name = RQ->mapextra;
		RQ->mapextra = strchr(RQ->mapextra, 0) + 1;
		pcb->mapmode = MAPMODE_MAPEXTRA;
		if (__likely(pcb->map_name[0] == '=')) {
			pcb->map_name++;
			pcb->mapmode |= MAPMODE_BLOCK_NONEX;
		}
		if (!strchr(pcb->map_name, '=')) pcb->mapmode = MAPMODE_MAPEXTRA | MAPMODE_UNMAP;
		pcb->u.mrq.size = sizeof(LNTE) + strlen(pcb->map_name);
		pcb->u.mrq.fn = lnte_allocated;
		RETURN_IORQ_CANCELABLE(&pcb->u.mrq, KERNEL$UNIVERSAL_MALLOC, RQ);
	}

	if (__likely(pcb->parse_params_arg != NULL)) while (__parse_params(&pcb->parse_params_arg, &pcb->parse_params_state, params, &opt, &optend, &val)) {
		/*__debug_printf("opt:[%s],%d, val:[%s]", opt, optend-opt, val);*/
		if (jobname) strcpy(pcb->jobname, jobname), jobname = NULL;
		if (opt) {
			size_t r;
			if (__likely(optend - opt >= 3) && !_memcasecmp("MAP", opt, 3)) {
				char *r;
				int mode = 0;
				opt += 3;
				while (opt < optend) {
					if (__likely(optend - opt >= 4) && !_memcasecmp("OVER", opt, 4)) {
						if (__unlikely(mode & (MAPMODE_OVERWRITE | MAPMODE_OPEN_NONEX))) goto badsyn;
						mode |= MAPMODE_OVERWRITE;
						opt += 4;
					} else if (__likely(optend - opt >= 4) && !_memcasecmp("PRIV", opt, 4)) {
						if (__unlikely(mode & MAPMODE_PRIVATE)) goto badsyn;
						mode |= MAPMODE_PRIVATE;
						opt += 4;
					} else if (__likely(optend - opt >= 5) && !_memcasecmp("NONEX", opt, 5)) {
						if (__unlikely(mode & (MAPMODE_OVERWRITE | MAPMODE_OPEN_NONEX | MAPMODE_IGNORE_NONEX))) goto badsyn;
						mode |= MAPMODE_OPEN_NONEX;
						opt += 5;
					} else if (__likely(optend - opt >= 8) && !_memcasecmp("IGNNONEX", opt, 8)) {
						if (__unlikely(mode & (MAPMODE_OPEN_NONEX | MAPMODE_IGNORE_NONEX))) goto badsyn;
						mode |= MAPMODE_IGNORE_NONEX;
						opt += 8;
					} else goto badsyn;
				}
				pcb->mapmode = mode;
				if (__unlikely(!val) || __unlikely(!*val)) {
					badsyn:
					RQ->status = -EBADSYN;
					err:
					if (pcb->state == PCB_PREPARING) {
						free_pcb_ret:
						free_pcb(pcb);
						RETURN;
					}
					if (pcb->state == PCB_LOCKED_SPAWNED) UNBLOCK_LNT();
					unlock_pcb(pcb);
					if (pcb->state == PCB_DONE && pcb->info & PROC_INFO_AUTO_EXIT) pcb->rq = NULL, free_pcb(pcb);
					RETURN_AST(RQ);
				}
				pcb->map_name = val;
				r = strchr(val, '=');
				if (__unlikely(!r)) {
					pcb->u.mrq.size = sizeof(LNTE) + strlen(val) * 2 + 3;
				} else {
					pcb->u.mrq.size = sizeof(LNTE) + strlen(val);
				}
				pcb->u.mrq.fn = lnte_allocated;
				RETURN_IORQ_CANCELABLE(&pcb->u.mrq, KERNEL$UNIVERSAL_MALLOC, RQ);
			}
			if (!__strcasexcmp("UNMAP", opt, optend) || !__strcasexcmp("DEFUNMAP", opt, optend)) {
				if (__unlikely(!val) || __unlikely(!*val)) goto badsyn;
				if (__unlikely(strchr(val, '=') != NULL)) goto badsyn;
				pcb->map_name = val;
				pcb->mapmode = !__strcasexcmp("UNMAP", opt, optend) ? MAPMODE_UNMAP : MAPMODE_DEFUNMAP;
				pcb->u.mrq.size = sizeof(LNTE) + strlen(val);
				pcb->u.mrq.fn = lnte_allocated;
				RETURN_IORQ_CANCELABLE(&pcb->u.mrq, KERNEL$UNIVERSAL_MALLOC, RQ);
			}
			if (__unlikely(o = is_option(opt, optend, val))) {
				if (__unlikely(o < 0)) {
					RQ->status = o;
					goto err;
				}
				if (__unlikely(r = set_option(pcb, opt, optend, val))) {
					alloc_arg:
					pcb->parse_params_arg--;
					pcb->u.mrq.size = r;
					pcb->u.mrq.fn = arg_allocated;
					RETURN_IORQ_CANCELABLE(&pcb->u.mrq, KERNEL$UNIVERSAL_MALLOC, RQ);
				}
				continue;
			}
			if (__unlikely(pcb->state != PCB_PREPARING)) {
				if (__likely(!__strcasexcmp("NOSWAP", opt, optend)) && __likely(!val)) continue;
				goto badsyn;
			}
			if (__unlikely(!__strcasexcmp("SET", opt, optend))) {
				int ad;
				char **c;
				size_t nvar, strl;
				char *str, *sstr, **ptr, **pptr;
				char *st;
				unsigned vall;
				if (__unlikely(!val) || __unlikely(!*val) || __unlikely(*val == '=')) goto badsyn;
				st = strchr(val, '=');
				if (__likely(st != NULL)) vall = st++ - val;
				else vall = strlen(val);
				if (pcb->env == &pcb->env_copy && __likely(pcb->env_copy != NULL)) {
					char *top;
					c = pcb->env_copy;
					top = (char *)c + __alloc_size(c);
					while (*c) {
						if (__likely(*c > (char *)c) && __likely(*c < top)) top = *c;
						if (__likely(strlen(*c) > vall) && __unlikely(!memcmp(*c, val, vall)) && __likely((*c)[vall] == '=')) {
							if (__likely(st != NULL)) {
								*c = val;
							} else {
								char **d;
								for (d = c + 1; *d != NULL; d++) ;
								memmove(c, c + 1, (d + 2 - c) * sizeof(char *));
							}
							goto cont;
						}
						c++;
					}
					if (__unlikely(!st)) goto cont;
					if (__likely((char *)(c + 2) <= top)) {
						c[0] = val;
						c[1] = NULL;
						goto cont;
					}
				}
				nvar = strl = 0;
				c = *pcb->env;
				if (__likely(c != NULL)) while (*c) {
					strl += strlen(*c) + 1;
					nvar++;
					c++;
				}
				nvar++;
				if (__likely(st != NULL)) /*strl += strlen(val) + 1, */nvar++;
				if (strl + nvar * sizeof(char *) > __alloc_size(pcb->arg)) {
					r = strl + nvar * sizeof(char *);
					goto alloc_arg;
				}
				str = sstr = (char *)pcb->arg + __alloc_size(pcb->arg) - strl;
				ptr = pptr = pcb->arg;
				pcb->arg = NULL;
				ad = 0;
				c = *pcb->env;
				if (__likely(c != NULL)) while (*c) {
					if (__likely(strlen(*c) > vall) && __unlikely(!memcmp(*c, val, vall)) && __likely((*c)[vall] == '=')) {
						if (__likely(st != NULL)) *ptr++ = val, ad = 1;
					} else {
						*ptr++ = str;
						str = stpcpy(str, *c) + 1;
					}
					c++;
				}
				if (__likely(st != NULL) && __likely(!ad)) *ptr++ = val;
				*ptr++ = NULL;
				if (__unlikely((char *)ptr > sstr))
					KERNEL$SUICIDE("proc_spawn_parse_params: ENV INDEX OVERFLOW");
				if (__unlikely(str > (char *)pptr + __alloc_size(pptr)))
					KERNEL$SUICIDE("proc_spawn_parse_params: ENV STR OVERFLOW");
				if (__likely(pcb->env_copy != NULL)) KERNEL$UNIVERSAL_FREE(pcb->env_copy);
				pcb->env_copy = pptr;
				pcb->env = &pcb->env_copy;
				cont:
				continue;
			}
			pcb->params[pcb->n_params++] = opt - 1;
		} else {
			if (__unlikely(pcb->state != PCB_PREPARING)) goto badsyn;
			pcb->params[pcb->n_params++] = val;
		}
	}

	if (pcb->state != PCB_PREPARING) {
		RQ->status = 0;
		goto err;
	}

	if (jobname) strcpy(pcb->jobname, jobname);

	if (__unlikely(!pcb->n_params)) goto badsyn;
	pcb->params[pcb->n_params++] = NULL;

	if (*pcb->jobname) {
		char *c = pcb->jobname;
		if (__unlikely(c[0] == '.') && (__unlikely(!c[1]) || (__unlikely(c[1] == '.') && __unlikely(!c[2])))) goto err_einval;
		while (*c) {
			if (__unlikely(*c == '/') || __unlikely(*c == ':') || __unlikely(*c == '^')) {
				err_einval:
				RQ->status = -EINVAL;
				goto err;
			}
			c++;
		}
		__upcase(pcb->jobname);
		if (__unlikely((bl = find_job(pcb->jobname)) != NULL)) {
			RQ->status = -EEXIST;
			goto err;
		}
		goto jobname_done;
	}
	s = strrchr(pcb->params[0], '/');
	if (__unlikely(!s)) {
		s = strchr(pcb->params[0], ':');
		if (__unlikely(!s) || __unlikely(!*++s)) s = pcb->params[0];
	} else {
		if (__unlikely(!*++s)) {
			s -= 2;
			while (s >= pcb->params[0] && *s != '/') s--;
			if (s < pcb->params[0]) s = pcb->params[0];
			else s++;
		}
	}
	for (i = 0; s[i] && s[i] != '.' && s[i] != '/' && i < 8; i++) pcb->jobname[i] = s[i];
	if (__unlikely(!i)) pcb->jobname[i++] = '0';
	pcb->jobname[i] = 0;
	__upcase(pcb->jobname);
	again:
	if (__unlikely((bl = find_job(pcb->jobname)) != NULL)) {
		long num = 0;
		char nump[9];
		int i = strlen(pcb->jobname);
		while (i) {
			i--;
			if (pcb->jobname[i] == '.') {
				if (__unlikely(__get_number(&pcb->jobname[i + 1], pcb->jobname + strlen(pcb->jobname), 0, &num))) num = 0;
				pcb->jobname[i] = 0;
				break;
			}
			if (pcb->jobname[i] < '0' || pcb->jobname[i] > '9') break;
		}
		num++;
		if (num >= 100000000) {
			RQ->status = -ENFILE;
			goto err;
		}
		_snprintf(nump, 9, "%ld", num);
		if (strlen(nump) == 8) {
			strcpy(pcb->jobname, nump);
			goto again;
		}
		if (strlen(pcb->jobname) + 1 + strlen(nump) > 8)
			pcb->jobname[8 - strlen(nump) - 1] = 0;
		strcat(pcb->jobname, ".");
		strcat(pcb->jobname, nump);
		goto again;
	}
	jobname_done:;
	memcpy(&RQ->jobname, pcb->jobname, 9);

	ADD_TO_LIST(&SUBPROC_CTL->proc_list, &pcb->list);
	SUBPROC_CTL->n_procs++;

	if (__unlikely(pcb->swaphandle != -1)) goto swp_hndl;
	stpcpy(stpcpy(pcb->swapstring, SWAPPER_DEVICE ":/"), pcb->jobname);
	do_creat:
	pcb->u.openrq.fn = proc_swapnode_created;
	pcb->u.openrq.flags = O_CREAT | _O_MKDIR | O_RDWR | _O_NOPOSIX;
	pcb->u.openrq.path = pcb->swapstring;
	pcb->u.openrq.cwd = NULL;
	RETURN_IORQ_CANCELABLE(&pcb->u.openrq, KERNEL$OPEN, RQ);

	swp_hndl:
	p = KERNEL$HANDLE_PATH(pcb->swaphandle);
	if (__unlikely(!p)) {
		RQ->status = -EBADF;
		goto free_pcb_ret;
	}
	pe = strchr(p, ':');
	stpcpy(mempcpy(pcb->swapstring, p, pe - p + 2), pcb->jobname);
	goto do_creat;
}

DECL_AST(proc_swapnode_created, SPL_DEV, IOCTLRQ)
{
	PROC_CONTROL_BLOCK *pcb = GET_STRUCT(RQ, PROC_CONTROL_BLOCK, u.openrq);
	IO_DISABLE_CHAIN_CANCEL(SPL_DEV, pcb->rq);
	if (__unlikely(pcb->u.openrq.status < 0)) {
		pcb->rq->status = pcb->u.openrq.status;
		free_pcb(pcb);
		RETURN;
	}
	pcb->swaphandle = pcb->u.openrq.status;
	pcb->u.ioctlrq.fn = proc_ioctl_tested;
	pcb->u.ioctlrq.h = pcb->swaphandle;
	pcb->u.ioctlrq.ioctl = IOCTL_SWAPPER_ISUSED;
	pcb->u.ioctlrq.param = 0;
	pcb->u.ioctlrq.v.ptr = 0;
	pcb->u.ioctlrq.v.len = 0;
	pcb->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	/*__debug_printf("iotest - start.");*/
	RETURN_IORQ_CANCELABLE(&pcb->u.ioctlrq, KERNEL$IOCTL, pcb->rq);
}

DECL_AST(proc_ioctl_tested, SPL_DEV, IOCTLRQ)
{
	int i;
	unsigned long l;
	LNT *ln;
	FFILE **handles;
	VMMAP *vmmap;
	char *c;
	unsigned heap_end;
	struct link_header *lh;
	struct section *secs;
	unsigned long bootstrap_code;
	PROC_CONTROL_BLOCK *pcb = GET_STRUCT(RQ, PROC_CONTROL_BLOCK, u.ioctlrq);
	IO_DISABLE_CHAIN_CANCEL(SPL_DEV, pcb->rq);
	/*__debug_printf("iotest:[%ld]",RQ->status);*/
	if (pcb->u.ioctlrq.status != 0) {
		if (pcb->u.ioctlrq.status != -EINTR) RETURN_IORQ_LSTAT(pcb->rq, proc_do_spawn);
		pcb->rq->status = pcb->u.ioctlrq.status;
		goto err;
	}
	if (__unlikely(!(pcb->init_page = KERNEL$ALLOC_KERNEL_PAGE(VM_TYPE_WIRED_MAPPED)))) {
		if (__unlikely(KERNEL$OOM(VM_TYPE_WIRED_MAPPED))) {
			pcb->rq->status = -ENOMEM;
			err:
			free_pcb(pcb);
			RETURN;
		}
		RETURN_IORQ_CANCELABLE(&pcb->u.ioctlrq, KERNEL$WAIT_ON_FREEMEM, pcb->rq);
	}

/* heap layout:
	LNT
	HANDLES (to lib:/kernel.dll)
	FFILE (for lib:/kernel.dll)
	VMMAPS (3 vmmaps, one for swapper:, one for lib:/kernel.dll, one reserved)
*/

	pcb->top_page_pos = pcb->init_page_pos = (KERNEL$KERNEL ? KUVMBASE : (unsigned long)*(void **)UPLACE(UDATA_STRUCT + OFF_UDATA_base)) & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1);
	memset(pcb->init_page + UDATA_PAGE(UDATA_BOTTOM), 0, UDATA_PAGE(UDATA_TOP) + __MALLOC_ALIGN - UDATA_PAGE(UDATA_BOTTOM));
	pcb->init_page_start = UDATA_PAGE(UDATA_BOTTOM);
	pcb->init_page_end = HEAP_INIT(pcb->init_page);

	/* LNT */
	l = HEAP_ALLOC(pcb->init_page, sizeof(LNT), 0);
	*(LNT **)&pcb->init_page[UDATA_PAGE(UDATA_STRUCT + OFF_UDATA_lnt)] = (LNT *)l;
	ln = (LNT *)&pcb->init_page[l & (PAGE_CLUSTER_SIZE - 1)];
	for (i = 0; i < LNT_HASH_SIZE; i++) {
		ln->hash[i].next = (void *)UPLACE(UDATA_LIST_END);
	}

	/* HANDLES */
	l = HEAP_ALLOC(pcb->init_page, sizeof(FFILE *) * (POSIX_RESERVED_HANDLES * 2), 0);
	((UDATA *)&pcb->init_page[UDATA_PAGE(UDATA_STRUCT)])->handles = (FFILE **)l;
	((UDATA *)&pcb->init_page[UDATA_PAGE(UDATA_STRUCT)])->n_handles = POSIX_RESERVED_HANDLES * 2;
	handles = (FFILE **)&pcb->init_page[l & (PAGE_CLUSTER_SIZE - 1)];

	l = HEAP_ALLOC(pcb->init_page, sizeof(VMMAP) * 2, 0);
	((UDATA *)&pcb->init_page[UDATA_PAGE(UDATA_STRUCT)])->vmmaps = (VMMAP *)l;
	((UDATA *)&pcb->init_page[UDATA_PAGE(UDATA_STRUCT)])->n_vmmaps = 2;
	vmmap = (VMMAP *)&pcb->init_page[l & (PAGE_CLUSTER_SIZE - 1)];
	vmmap[0].vmaddr = (void *)KERNEL_DLL_BASE;
	vmmap[0].vmsize = PAGE_CLUSTER_SIZE;
	vmmap[0].handle = -1;
	vmmap[0].flags = PROT_READ | PROT_WRITE | PROT_EXEC | MAP_ANONYMOUS | MAP_PRIVATE | MAP_INHERIT;
	vmmap[1].vmaddr = (void *)(pcb->init_page_pos - STACK_SIZE);
	vmmap[1].vmsize = STACK_SIZE + UPAGES * PAGE_CLUSTER_SIZE;
	vmmap[1].handle = -1;
	vmmap[1].flags = PROT_READ | PROT_WRITE | PROT_EXEC | MAP_ANONYMOUS | MAP_PRIVATE | MAP_INHERIT;

	l = HEAP_ALLOC(pcb->init_page, sizeof(VMMAP) * 3, 0);
	((UDATA *)&pcb->init_page[UDATA_PAGE(UDATA_STRUCT)])->vmmaps_b = (VMMAP *)l;

	c = KERNEL$GET_CWD(pcb->cwd);
	if (__likely(c != NULL)) {
		if (__likely((l = HEAP_ALLOC(pcb->init_page, strlen(c) + 1, 1)) != 0)) {
			strcpy(&pcb->init_page[l & (PAGE_CLUSTER_SIZE - 1)], c);
			((UDATA *)&pcb->init_page[UDATA_PAGE(UDATA_STRUCT)])->cwd = (char *)l;
		}
	}

	*(int *)&pcb->init_page[UDATA_PAGE(UDATA_SPL)] = SPL_X(SPL_ZERO);
	*(int *)&pcb->init_page[UDATA_PAGE(UDATA_BPL)] = SPL_X(SPL_ZERO);
	__CLEAR_ASTS((void **)&pcb->init_page[UDATA_PAGE(UDATA_AST_QUEUES)], (void **)UPLACE(UDATA_AST_QUEUES));
	heap_end = HEAP_DONE(pcb->init_page);
	lh = memcpy(pcb->init_page + heap_end, BOOTSTRAP_START, BOOTSTRAP_END - BOOTSTRAP_START);
	/*__debug_printf("bootstrap start %x\n", heap_end);*/
	secs = (struct section *)((char *)lh + lh->sections);
	secs[0].ptr = (__f_off)lh;
	secs[1].ptr = secs[0].ptr + secs[0].len;
	secs[2].ptr = secs[1].ptr + secs[1].len;
	secs[3].ptr = secs[2].ptr + secs[2].len;
	secs[4].ptr = secs[3].ptr + secs[3].len;
	bootstrap_code = ((unsigned long)*(void **)&pcb->init_page[UDATA_PAGE(UDATA_STRUCT + (int)(unsigned long)&((UDATA *)NULL)->heap_freelist)] & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1)) + heap_end;
	if (__unlikely(LINK_RELOC(lh, bootstrap_code - (unsigned long)lh)))
		KERNEL$SUICIDE("proc_ioctl_tested: CAN'T RELOC BOOTSTRAP CODE");
	
	pcb->init_page_end = heap_end + (BOOTSTRAP_END - BOOTSTRAP_START);
	arch_init_udata(pcb, bootstrap_code);
	/*__debug_printf("heap_end: %x\n", heap_end);*/
	/*__debug_printf("ips: %x, ipe: %x\n", pcb->init_page_start, pcb->init_page_end);*/
	pcb->env_ptr = &pcb->params[pcb->n_params - 1];
	pcb->env_pos = -1;
	pcb->put_mode = 0;
	pcb->put_env = 0;
	pcb->env_mod = 2;
	pcb->u.ioctlrq.fn = copy_environ;
	pcb->u.ioctlrq.status = 0;
	RETURN_AST(&pcb->u.ioctlrq);
}

static void ENV_CHG_CALLBACK(ENV_CALLBACK *e)
{
	PROC_CONTROL_BLOCK *pcb = LIST_STRUCT(e, PROC_CONTROL_BLOCK, env_call);
	pcb->env_mod = 1;
}

DECL_AST(copy_environ, SPL_DEV, IOCTLRQ)
{
	PROC_CONTROL_BLOCK *pcb = GET_STRUCT(RQ, PROC_CONTROL_BLOCK, u.ioctlrq);
	IO_DISABLE_CHAIN_CANCEL(SPL_DEV, pcb->rq);
	if (__likely(pcb->env_mod == 2)) {
		pcb->env_call.fn = ENV_CHG_CALLBACK;
		KERNEL$REGISTER_ENV_CALLBACK(&pcb->env_call);
		pcb->env_mod = 0;
	}
	if (__unlikely(pcb->u.ioctlrq.status != 0)) {
		pcb->rq->status = pcb->u.ioctlrq.status;
		KERNEL$UNREGISTER_ENV_CALLBACK(&pcb->env_call);
		free_pcb(pcb);
		RETURN;
	}

	if (__unlikely(pcb->put_mode == 2)) {
		pcb->init_page_pos = pcb->top_page_pos;
		pcb->init_page_start = arch_set_stack_bottom;
		pcb->init_page_end = arch_set_stack_top;
		goto sstack3;
	}

	if (pcb->put_mode == 3) {
		KERNEL$UNREGISTER_ENV_CALLBACK(&pcb->env_call);
		RETURN_IORQ_LSTAT(pcb->rq, proc_do_spawn);
	}

	if (__unlikely(pcb->env_mod)) {
		pcb->env_mod = 0;
		pcb->put_mode = 0;
		pcb->init_page_start = pcb->init_page_end = UDATA_PAGE(UDATA_BOTTOM);
		pcb->init_page_pos = pcb->top_page_pos;
		mode_1:
		pcb->env_ptr = &pcb->params[pcb->n_params - 1];
		pcb->env_pos = -1;
		pcb->put_env = 0;
	}

	next_str:
	if (__unlikely(!pcb->init_page_start)) {
		flush_page:
		pcb->u.ioctlrq.fn = copy_environ;
		pcb->u.ioctlrq.h = pcb->swaphandle;
		pcb->u.ioctlrq.ioctl = IOCTL_SWAPPER_PUTPAGE;
		pcb->u.ioctlrq.param = pcb->init_page_pos + pcb->init_page_start;
		pcb->u.ioctlrq.v.ptr = (unsigned long)pcb->init_page + pcb->init_page_start;
		pcb->u.ioctlrq.v.len = pcb->init_page_end - pcb->init_page_start;
		pcb->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
		pcb->init_page_pos -= pcb->init_page_start = pcb->init_page_end = PAGE_CLUSTER_SIZE;
		RETURN_IORQ_CANCELABLE(&pcb->u.ioctlrq, KERNEL$IOCTL, pcb->rq);
	}

	if (pcb->env_ptr == &pcb->params[-1] && !pcb->put_env) {
		pcb->env_ptr = *pcb->env;
		pcb->put_env = 1;
		if (__likely(pcb->env_ptr != NULL)) while (*pcb->env_ptr) pcb->env_ptr++;
	}
	if (__unlikely(pcb->env_ptr == *pcb->env - 1) && pcb->put_env) {
		if (!pcb->put_mode) {
			set_mode_1:
			pcb->vpos = (__unlikely(KERNEL$KERNEL) ? KUVMBASE : (unsigned long)*(void **)UPLACE(UDATA_STRUCT + OFF_UDATA_base));
			pcb->put_mode = 1;
			while (pcb->init_page_start & (sizeof(char *) - 1)) {
				pcb->init_page[--pcb->init_page_start] = 0;
			}
			goto mode_1;
		}
		done:
		pcb->vpos = pcb->init_page_pos + pcb->init_page_start;
		if (__likely(pcb->init_page_pos == pcb->top_page_pos)) {
			sstack3:
			arch_set_stack(pcb, pcb->vpos);
			pcb->put_mode = 3;
			goto flush_page;
		}
		pcb->put_mode = 2;
		goto flush_page;
	}
	if (pcb->put_mode == 1) {
		if (__likely(pcb->env_ptr != NULL) && __likely(*pcb->env_ptr != NULL)) {
			if (__unlikely(**pcb->env_ptr == '@') && pcb->put_env) goto dec_env;
			pcb->vpos -= strlen(*pcb->env_ptr) + 1;
			*(char **)&pcb->init_page[pcb->init_page_start -= sizeof(char *)] = (char *)pcb->vpos;
		} else {
			*(char **)&pcb->init_page[pcb->init_page_start -= sizeof(char *)] = NULL;
			if (__unlikely(!pcb->env_ptr)) goto done;
		}
		dec_env:
		pcb->env_ptr--;
		goto next_str;
	}
	if (__unlikely(!pcb->env_ptr)) goto set_mode_1;
	if (!*pcb->env_ptr) goto dec_env;
	if (__unlikely(**pcb->env_ptr == '@') && pcb->put_env) goto dec_env;
	if (__likely(pcb->env_pos == -1)) pcb->env_pos = strlen(*pcb->env_ptr);
	next_chr:
	pcb->init_page[--pcb->init_page_start] = pcb->env_ptr[0][pcb->env_pos--];
	if (__unlikely(pcb->env_pos == -1)) goto dec_env;
	if (__unlikely(!pcb->init_page_start)) goto flush_page;
	goto next_chr;
}

DECL_IOCALL(proc_do_spawn, SPL_DEV, PROC_SPAWN_RQ)
{
	PROC_CONTROL_BLOCK *pcb = RQ->pcb;
	KERNEL$FAST_CLOSE(pcb->swaphandle);
	pcb->swaphandle = -1;
	/*__debug_printf("do_spawn.");*/
	run_pcb(pcb);
	WQ_WAKE_ALL(&pcb->wait);
	WQ_WAKE_ALL(&SUBPROC_CTL->proc_wait);
	RQ->status = 0;
	pcb->rq = NULL;
	/*__debug_printf("ret.");*/
	RETURN_AST(RQ);
}

static void process_timer(TIMER *t);

DECL_AST(PROCESS_DONE, SPL_DEV, KSPAWNRQ)
{
	PROC_CONTROL_BLOCK *pcb = RQ->pcb;
	/*__debug_printf("exit (%d) %s (%ld): %s.\n", KERNEL$KERNEL ? 0 : SYSCALL1(SYS_DEPTH), RQ->jobname, RQ->status, RQ->error);*/
	if (__unlikely((pcb->state & PCB_STATE_MASK) != PCB_SPAWNED))
		KERNEL$SUICIDE("PROCESS_DONE: PROCESS %s NOT IN SPAWNED STATE: %d", pcb->jobname, pcb->state);
	if (RQ->status == -EINTR) {
		unsigned l;
		SUBPROC_CTL->n_swapped++;
		pcb->state = (pcb->state & ~PCB_STATE_MASK) | PCB_SWAPPEDOUT;
		WQ_WAKE_ALL(&pcb->wait);
		WQ_WAKE_ALL(&SUBPROC_CTL->proc_wait);
		WQ_WAKE_ALL(&KERNEL$LOGICAL_WAIT);
		l = time(NULL) - SUBPROC_CTL->last_reswap_time;
		if (__unlikely(l < MAX_RESWAP_TIME)) {
			SUBPROC_CTL->reswap_n++;
			if (SUBPROC_CTL->reswap_n > SUBPROC_CTL->n_procs) {
				SUBPROC_CTL->reswap_n = 0;
				if (__likely(SUBPROC_CTL->reswap_time < MAX_RESWAP_TIME * JIFFIES_PER_SECOND)) SUBPROC_CTL->reswap_time++;
			}
		} else {
			SUBPROC_CTL->reswap_n = 0;
			l -= MAX_RESWAP_TIME;
			SUBPROC_CTL->last_reswap_time += l;
			l *= JIFFIES_PER_SECOND / RESWAP_TIME_DECAY;
			if (__unlikely(l >= SUBPROC_CTL->reswap_time)) SUBPROC_CTL->reswap_time = 0;
			else SUBPROC_CTL->reswap_time -= l;
		}
		if (!SUBPROC_CTL->timer_active) {
			SUBPROC_CTL->timer_active = 1;
			SUBPROC_CTL->timer.fn = process_timer;
			if (__likely(!SUBPROC_CTL->reswap_time)) {
				RAISE_SPL(SPL_TIMER);
				process_timer(&SUBPROC_CTL->timer);
				LOWER_SPL(SPL_DEV);
			} else {
				KERNEL$SET_TIMER(SUBPROC_CTL->reswap_time, &SUBPROC_CTL->timer);
			}
		}
		RETURN;
	}
	if (__unlikely(RQ->status == -ESTOPPED) || __unlikely(RQ->status == -EBACKGROUND)) {
		pcb->state = (pcb->state & ~PCB_STATE_MASK) | PCB_STOPPED;
		pcb->background = RQ->status == -EBACKGROUND;
		WQ_WAKE_ALL(&pcb->wait);
		WQ_WAKE_ALL(&SUBPROC_CTL->proc_wait);
		WQ_WAKE_ALL(&KERNEL$LOGICAL_WAIT);
		if (SIGCHLD_FOR_STOPPED()) raise(SIGCHLD);
		RETURN;
	}
	pcb->state = (pcb->state & ~PCB_STATE_MASK) | PCB_DONE;
	WQ_WAKE_ALL(&pcb->wait);
	WQ_WAKE_ALL(&SUBPROC_CTL->proc_wait);
	WQ_WAKE_ALL(&KERNEL$LOGICAL_WAIT);
	if (pcb->state == PCB_DONE && pcb->info & PROC_INFO_AUTO_EXIT) pcb->rq = NULL, free_pcb(pcb);
	if (__likely(!KERNEL$KERNEL)) raise(SIGCHLD);
	RETURN;
}

static void process_timer(TIMER *t)
{
	LOWER_SPL(SPL_TIMER);
	SUBPROC_CTL->last_reswap_time = time(NULL);
	CALL_AST(&SUBPROC_CTL->process_ast);
}

DECL_AST(do_process_ast, SPL_DEV, AST)
{
	PROC_CONTROL_BLOCK *pcb;
	int i;
	SUBPROC_CTL->timer_active = 0;
	if (!SUBPROC_CTL->n_swapped) RETURN;
	if (__unlikely(LIST_EMPTY(&SUBPROC_CTL->proc_list))) RETURN;
	for (i = 0; i < SUBPROC_CTL->n_procs; i++) {
		pcb = LIST_STRUCT(SUBPROC_CTL->proc_list.prev, PROC_CONTROL_BLOCK, list);
		DEL_FROM_LIST(&pcb->list);
		ADD_TO_LIST(&SUBPROC_CTL->proc_list, &pcb->list);
		if (pcb->state == PCB_SWAPPEDOUT) {
			SUBPROC_CTL->n_swapped--;
			if (SUBPROC_CTL->n_swapped) {
				SUBPROC_CTL->timer_active = 1;
				SUBPROC_CTL->timer.fn = process_timer;
				KERNEL$SET_TIMER(SUBPROC_CTL->reswap_time, &SUBPROC_CTL->timer);
			}
			run_pcb(pcb);
			break;
		}
	}
	RETURN;
}

int KERNEL$PROC_GET_FLAGS(char *proc, void *session, void **session_result)
{
	int flags;
	int spl;
	PROC_CONTROL_BLOCK *pcb;
	make_subproc_ctl();
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_DEV), KERNEL$SPL)))
		KERNEL$SUICIDE("KERNEL$PROC_GET_FLAGS AT SPL %08X", KERNEL$SPL);
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_DEV);
	pcb = find_job_active(proc);
	if (__unlikely(!pcb)) {
		flags = -ESRCH;
		goto lower_ret;
	}
	if (__likely(session != NULL) && __unlikely(pcb->session != session)) {
		flags = -ETTYCHG;
		goto lower_ret;
	}
	*session_result = pcb->session;
	flags = pcb->info;
	lower_ret:
	LOWER_SPLX(spl);
	return flags;
}

void KERNEL$PROC_GET_JOB_NAME(char from[9])
{
	int spl;
	PROC_CONTROL_BLOCK *pcb, *ppcb;
	make_subproc_ctl();
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_DEV), KERNEL$SPL)))
		KERNEL$SUICIDE("KERNEL$PROC_GET_JOB_NAME AT SPL %08X", KERNEL$SPL);
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_DEV);
	ppcb = NULL;
	LIST_FOR_EACH(pcb, &SUBPROC_CTL->proc_list, PROC_CONTROL_BLOCK, list) {
		if (pcb->state != PCB_DESTROYING && strcmp(pcb->jobname, from) > 0 && (!ppcb || strcmp(pcb->jobname, ppcb->jobname) < 0)) ppcb = pcb;
	}
	if (__unlikely(!ppcb)) *from = 0;
	else strcpy(from, ppcb->jobname);
	LOWER_SPLX(spl);
}

DECL_IOCALL(KERNEL$PROC_REMAP, SPL_DEV, PROC_SPAWN_RQ)
{
	PROC_CONTROL_BLOCK *pcb;
	make_subproc_ctl();
	pcb = find_job_active(RQ->jobname);
	if (__unlikely(!pcb)) {
		RQ->status = -ESRCH;
		RETURN_AST(RQ);
	}
	if (__likely(RQ->session != NULL) && __unlikely(RQ->session != pcb->session)) {
		RQ->status = -ETTYCHG;
		RETURN_AST(RQ);
	}
	if ((pcb->state & PCB_STATE_MASK) == PCB_SPAWNED) {
		char **arg;
		int state;
		char *opt, *optend, *val;
		struct __param_table params[] = {
			NULL, 0, 0, 0, NULL,
		};
		if (!RQ->params) goto cio;
		arg = RQ->params;
		state = __STATE_NOFIRST;
		while (__unlikely(__parse_params(&arg, &state, params, &opt, &optend, &val))) {
			if (__likely(!__strcasexcmp("NOSWAP", opt, optend)) && __likely(!val)) {
				/*DO_BREAK(&KERNEL$PROC_KERNEL, pcb->ksp);*/
				goto noswap;
			}
		}
		cio:
		KERNEL$CIO((IORQ *)pcb->ksp);
		wait:
		WQ_WAIT(&pcb->wait, RQ, KERNEL$PROC_REMAP);
		RETURN;
	}
	noswap:
	if (__unlikely(pcb->state & PCB_LOCKED_MASK)) goto wait;
	pcb->state |= PCB_LOCKED_MASK;
	pcb->parse_params_arg = RQ->params;
	pcb->parse_params_state = __STATE_NOFIRST;
	pcb->n_params = 0;
	if (RQ->info != -1) pcb->info = RQ->info;
	if (__likely(RQ->session_change != NULL)) pcb->session = RQ->session_change;
	RQ->pcb = pcb;
	pcb->rq = (IORQ *)RQ;
	pcb->cwd = RQ->cwd;
	RETURN_IORQ_LSTAT(RQ, proc_spawn_parse_params);
}

DECL_IOCALL(KERNEL$PROC_CTRL, SPL_DEV, PROC_CTRL_RQ)
{
	PROC_CONTROL_BLOCK *pcb;
	*RQ->msg = 0;
	make_subproc_ctl();
	pcb = find_job_active(RQ->jobname);
	if (__unlikely(!pcb)) {
		RQ->status = -ESRCH;
		RETURN_AST(RQ);
	}
	if (__unlikely(pcb->state & PCB_LOCKED_MASK)) {
		wait:
		WQ_WAIT(&pcb->wait, RQ, KERNEL$PROC_CTRL);
		RETURN;
	}
	if (__likely(RQ->session != NULL) && __unlikely(pcb->session != RQ->session)) {
		RQ->status = -ETTYCHG;
		RETURN_AST(RQ);
	}
	switch (RQ->op) {
		case PROC_CTRL_STOP:
		case PROC_CTRL_KILL:
			if (__unlikely(pcb->state == PCB_DONE)) break;
			if (pcb->state == PCB_SPAWNED) {
				cio:
				KERNEL$CIO((IORQ *)pcb->ksp);
				goto wait;
			}
			if (pcb->state == PCB_SWAPPEDOUT) SUBPROC_CTL->n_swapped--;
			if (RQ->op == PROC_CTRL_STOP) {
				pcb->state = PCB_STOPPED;
				pcb->background = 0;
				if (SIGCHLD_FOR_STOPPED()) raise(SIGCHLD);
			} else {
				pcb->state = PCB_DONE;
				pcb->ksp->status = __EXIT_SIGNAL_VAL + SIGKILL;
				strlcpy(pcb->ksp->error, "KILLED", __MAX_STR_LEN);
				if (__likely(!KERNEL$KERNEL)) raise(SIGCHLD);
			}
			WQ_WAKE_ALL(&pcb->wait);
			WQ_WAKE_ALL(&SUBPROC_CTL->proc_wait);
			if (pcb->state == PCB_DONE && pcb->info & PROC_INFO_AUTO_EXIT) pcb->rq = NULL, free_pcb(pcb);
			break;
		case PROC_CTRL_RESUME:
			pcb->waitdone = 0;
			if (pcb->state == PCB_STOPPED) run_pcb(pcb);
			break;
		case PROC_CTRL_ZAP:
			if (pcb->state == PCB_SPAWNED) goto cio;
			if (pcb->state == PCB_SWAPPEDOUT) SUBPROC_CTL->n_swapped--;
			RQ->status = 0;
			pcb->rq = (IORQ *)RQ;
			free_pcb(pcb);
			RETURN;
		case PROC_CTRL_WAIT:
		case PROC_CTRL_NOWAIT:
			if (__unlikely(pcb->state == PCB_STOPPED)) {
				strlcpy(RQ->msg, pcb->ksp->error, __MAX_STR_LEN);
				RQ->status = pcb->background ? -EBACKGROUND : -ESTOPPED;
				RETURN_AST(RQ);
			}
			if (pcb->state != PCB_DONE) {
				if (RQ->op == PROC_CTRL_NOWAIT) {
					RQ->status = PROC_RUNNING;
					RETURN_AST(RQ);
				}
				goto wait;
			}
			strlcpy(RQ->msg, pcb->ksp->error, __MAX_STR_LEN);
			RQ->status = pcb->ksp->status;
			RETURN_AST(RQ);
		default:
			RQ->status = -ENOOP;
			RETURN_AST(RQ);
	}
	RQ->status = 0;
	RETURN_AST(RQ);
}

void SWAP_ALL_SUBPROCESSES(void)
{
	int cio;
	PROC_CONTROL_BLOCK *pcb;
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_DEV)))
		KERNEL$SUICIDE("SWAP_ALL_SUBPROCESSES AT SPL %08X", KERNEL$SPL);
#endif
	if (__unlikely(!SUBPROC_CTL)) return;
	cio = 0;
	LIST_FOR_EACH(pcb, &SUBPROC_CTL->proc_list, PROC_CONTROL_BLOCK, list) {
		if (__likely((pcb->state & PCB_STATE_MASK) == PCB_SPAWNED)) {
			cio = 1;
			KERNEL$CIO((IORQ *)pcb->ksp);
		}
	}
	if (cio)  {
		SUBPROC_CTL->last_reswap_time = 0;
		SUBPROC_CTL->reswap_time = 0;
		SUBPROC_CTL->reswap_n = 0;
	}
}

static pid_t forkpid = 'A';

static void inc_forkpid(void)
{
	int s = 0;
	char c;
	again:
	c = (forkpid >> s) & 0xff;
	if (__unlikely(!c)) {
		forkpid |= (pid_t)'A' << s;
		return;
	}
	if (__likely(c < 'Z')) {
		forkpid += (pid_t)1 << s;
		return;
	}
	forkpid -= (pid_t)('Z' - 'A') << s;
	s += 8;
	if (s < sizeof(pid_t) * 8) goto again;
}

struct atfork_struct {
	LIST_ENTRY list;
	void (*prepare)(void);
	void (*parent)(void);
	void (*child)(void);
};

static DECL_LIST(atfork);

pid_t fork(void)
{
	int tim;
	int spl;
	PROC_CONTROL_BLOCK *pcb, *xpcb;
	int r;
	struct atfork_struct *af;
	if (__unlikely(KERNEL$KERNEL)) {
		errno = EKERNEL;
		goto ret0;
	}
	LIST_FOR_EACH_BACK_UNLIKELY(af, &atfork, struct atfork_struct, list)
		if (af->prepare != NULL) af->prepare();
	make_subproc_ctl();
	if (__unlikely(!(pcb = ALLOC_PCB()))) {
		errno = ENOMEM;
		goto ret0;
	}
	spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_DEV), spl))) KERNEL$SUICIDE("fork AT SPL %08X", spl);
	RAISE_SPL(SPL_DEV);
	pcb->ln_mode = LN_ALL;
	next_forkpid:
	*(__u64 *)pcb->jobname = __64CPU2LE(forkpid);
	pcb->jobname[8] = 0;
	inc_forkpid();
	if (__unlikely(find_job(pcb->jobname) != NULL)) goto next_forkpid;
	ADD_TO_LIST(&SUBPROC_CTL->proc_list, &pcb->list);
	SUBPROC_CTL->n_procs++;
	stpcpy(stpcpy(pcb->swapstring, SWAPPER_DEVICE ":/"), pcb->jobname);
	if (__unlikely((open(pcb->swapstring, _O_CLOSE | O_CREAT | O_EXCL | _O_MKDIR | O_RDWR | _O_NOPOSIX, 0700)) == -1)) {
		goto ret3;
	}
	if (__unlikely(UIO_MAKE_FORKTABLE(&pcb->forktable, &pcb->forktable_n))) goto ret3;
	prepare_pcb_to_run(pcb);
	RAISE_SPL(SPL_TOP);
	SYSCALL1(SYS_CANCEL_ALL);
	tim = TIMER_DISABLE();
	LIST_FOR_EACH(xpcb, &SUBPROC_CTL->proc_list, PROC_CONTROL_BLOCK, list) {
		if (__likely((xpcb->state & PCB_STATE_MASK) == PCB_SPAWNED)) {
			SUSPEND_KERNEL_AST((IORQ *)xpcb->ksp);
		}
	}
	r = KERNEL_FORK(pcb->ksp);
	if (__unlikely(r <= 0)) {
		pid_t ret;
		TIMER_ENABLE(tim);
		LIST_FOR_EACH(xpcb, &SUBPROC_CTL->proc_list, PROC_CONTROL_BLOCK, list) {
			if (__likely((xpcb->state & PCB_STATE_MASK) == PCB_SPAWNED)) {
				RESUME_KERNEL_AST((IORQ *)xpcb->ksp);
			}
		}
		if (__unlikely(r < 0)) {
			errno = r;
			goto ret4;
		}
		ret = __64LE2CPU(*(__u64 *)pcb->jobname);
		LOWER_SPLX(spl);
		LIST_FOR_EACH_UNLIKELY(af, &atfork, struct atfork_struct, list)
			if (af->parent != NULL) af->parent();
		return ret;
	} else {
		__CLEAR_ASTS(KERNEL$AST_QUEUES, KERNEL$AST_QUEUES);
		KERNEL$PPL = 0;
		__barrier();
		SIGNAL_FORK();
		TIMER_FORK();
		THREAD_FORK();
		ULIBC_FORK();
		UIO_FORK();
		LOWER_SPL(SPL_DEV);
		SIGNAL_FORK_INTR_KEYS();
		SELECT_FORK();
		while (!LIST_EMPTY(&SUBPROC_CTL->proc_list)) {
			PROC_CONTROL_BLOCK *pcb = LIST_STRUCT(SUBPROC_CTL->proc_list.next, PROC_CONTROL_BLOCK, list);
			pcb->jobname[0] = 0;
			pcb->rq = NULL;
			pcb->ksp = NULL;
			free_pcb(pcb);
		}
		while (!XLIST_EMPTY(&SUBPROC_CTL->kspawnrq_pages)) {
			KSPAWNRQ_PAGE *pg = LIST_STRUCT(SUBPROC_CTL->kspawnrq_pages.next, KSPAWNRQ_PAGE, list);
			DEL_FROM_LIST(&pg->list);
			munmap(pg->addr, PAGE_CLUSTER_SIZE);
			free(pg);
		}
		INIT_XLIST(&SUBPROC_CTL->free_kspawnrqs);
		SUBPROC_CTL->n_procs = 0;
		SUBPROC_CTL->n_swapped = 0;
		INIT_TIMER(&SUBPROC_CTL->timer);
		SUBPROC_CTL->timer_active = 0;
		arc4random_invalidate();
		LOWER_SPLX(spl);
		LIST_FOR_EACH_UNLIKELY(af, &atfork, struct atfork_struct, list)
			if (af->child != NULL) af->child();
		return 0;
	}

	ret4:
	LOWER_SPL(SPL_DEV);
	ret3:
	free_pcb(pcb);
	LOWER_SPLX(spl);
	ret0:
	return -1;
}

pid_t vfork(void)
{
	return fork();
}

pid_t waitpid(pid_t pid, int *status, int options)
{
	int spl;
	PROC_CONTROL_BLOCK *pcb, *p;
	PROC_CTRL_RQ pcr;
	pid_t ret;
	long r;
	__cancel_start();
	make_subproc_ctl();
	/*__debug_printf("WAITPID(%Ld,%d) (%08x,%08x)", pid, options, KERNEL$SPL, KERNEL$PPL);*/
	if (__unlikely(pid == WAIT_MYPGRP)) pid = WAIT_ANY;
	else if (__unlikely(pid < WAIT_ANY)) goto echild;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_DEV), KERNEL$SPL))) KERNEL$SUICIDE("waitpid AT SPL %08X", KERNEL$SPL);
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_DEV);
	again:
	p = NULL;
	LIST_FOR_EACH(pcb, &SUBPROC_CTL->proc_list, PROC_CONTROL_BLOCK, list) if (pid == (ret = __64LE2CPU(*(__u64 *)pcb->jobname)) || pid == WAIT_ANY) {
		p = pcb;
		if (__unlikely(pcb->waitdone)) continue;
		if (pcb->state == PCB_DONE) {
			pcb->waitdone = 1;
			if (__likely(status != NULL)) {
				if (__unlikely(__IS_EXIT_SIGNAL(pcb->ksp->status))) *status = W_EXITCODE(0, pcb->ksp->status - __EXIT_SIGNAL_VAL);
				else if (__likely(pcb->ksp->status >= 0 && pcb->ksp->status < 256)) *status = W_EXITCODE(pcb->ksp->status, 0);
				else *status = W_EXITCODE(255, 0);
			}
			memcpy(pcr.jobname, pcb->jobname, 9);
			pcr.op = PROC_CTRL_ZAP;
			pcr.msg = (char *)&KERNEL$LIST_END;
			pcr.session = NULL;
			SYNC_IO(&pcr, KERNEL$PROC_CTRL);
			LOWER_SPLX(spl);
			/*__debug_printf("returned: %Ld. (pcb status %ld, status %d)\n", ret, pcb->ksp->status, status ? *status : 1234);*/
			__cancel_end();
			return ret;
		}
		if (pcb->state == PCB_STOPPED && options & WUNTRACED) {
			pcb->waitdone = 1;
			if (__likely(*status != NULL)) *status = W_STOPCODE(SIGSTOP);
			/*__debug_printf("returned stopped: %Ld. (pcb status %ld, status %d)\n", ret, pcb->ksp->status, status ? *status : 1234);*/
			__cancel_end();
			return ret;
		}
	}
	if (!p) {
		LOWER_SPLX(spl);
		echild:
		/*__debug_printf("no child.");*/
		errno = ECHILD;
		__cancel_end();
		return -1;
	}
	if ((options & WNOHANG)) {
		/*__debug_printf("no hang.");*/
		LOWER_SPLX(spl);
		__cancel_end();
		return 0;
	}
	if (pid != WAIT_ANY) {
		/*__debug_printf("sleeping on proc.");*/
		r = WQ_WAIT_SYNC_SIGINTERRUPT(&p->wait);
	} else {
		/*__debug_printf("sleeping on all procs.");*/
		r = WQ_WAIT_SYNC_SIGINTERRUPT(&SUBPROC_CTL->proc_wait);
	}
	/*__debug_printf("wake up.");*/
	if (__unlikely(r != 0)) {
		/*__debug_printf("interrupted.");*/
		LOWER_SPLX(spl);
		errno = -r;
		__cancel_end();
		return -1;
	}
	goto again;
}

int killpg(pid_t pgrp, int sig)
{
	return kill(-pgrp, sig);
}

static int kill_proc(pid_t proc, int sig);
static int kill_all(int sig);

int kill(pid_t pid, int sig)
{
	int spl;
	if (__unlikely((unsigned)sig >= NSIG)) {
		errno = EINVAL;
		return -1;
	}
	if (__unlikely(KERNEL$KERNEL)) {
		errno = EKERNEL;
		return -1;
	}
	make_subproc_ctl();
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_DEV), KERNEL$SPL))) KERNEL$SUICIDE("kill AT SPL %08X", KERNEL$SPL);
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_DEV);
	if (__unlikely(pid == -1) || __unlikely(pid == 0)) {
		if (__unlikely(kill_all(sig))) goto ret_minus_1;
		if (!pid) raise(sig);
	} else if (__unlikely(pid == getpid())) {
		LOWER_SPLX(spl);
		return raise(sig);
	} else {
		if (__unlikely(pid < 0)) pid = -pid;
		if (__unlikely(kill_proc(pid, sig))) {
			errno = ESRCH;
			ret_minus_1:
			LOWER_SPLX(spl);
			return -1;
		}
	}
	LOWER_SPLX(spl);
	return 0;
}

static int kill_proc(pid_t proc, int sig)
{
	void *m;
	PROC_CONTROL_BLOCK *pcb;
	IOCTLRQ io;
	PROC_CTRL_RQ pcr;
#if __DEBUG >= 1
	if (KERNEL$SPL != SPL_X(SPL_DEV))
		KERNEL$SUICIDE("kill_proc AT SPL %08X", KERNEL$SPL);
#endif
	proc = __64CPU2LE(proc);
	memcpy(pcr.jobname, &proc, 8);
	pcr.jobname[9] = 0;
	pcb = find_job_active(pcr.jobname);
	if (__unlikely(!pcb)) return -1;
	if (__unlikely(!sig)) return 0;
	if (__unlikely(sig == SIGSTOP)) {
		cont:
		pcr.op = sig == SIGSTOP ? PROC_CTRL_STOP : PROC_CTRL_RESUME;
		pcr.msg = (char *)&KERNEL$LIST_END;
		pcr.session = NULL;
		SYNC_IO(&pcr, KERNEL$PROC_CTRL);
		return 0;
	}
	io.h = open(pcb->swapstring, O_RDWR | _O_NOPOSIX);
	if (__unlikely(io.h == -1)) goto nosw;
	m = mmap(NULL, PAGE_CLUSTER_SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, io.h, KERNEL$STACKPAGE & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1));
	if (__unlikely(m == MAP_FAILED)) goto nosw;
	__ORL(&((UDATA *)((char *)m + (KERNEL$STACKPAGE & (PAGE_CLUSTER_SIZE - 1)) + UDATA_STRUCT))->sigpending, 1L << sig);
	munmap(m, PAGE_CLUSTER_SIZE);
	SYSCALL2(SYS_BREAK, (unsigned long)pcb->ksp);
	close(io.h);
	nosw:
	if (__unlikely(sig == SIGCONT) || __unlikely(sig == SIGKILL)) goto cont;
	return 0;
}

static int kill_all(int sig)
{
	PROC_CONTROL_BLOCK *pcb;
	int n, i;
	pid_t *p;
#if __DEBUG >= 1
	if (KERNEL$SPL != SPL_X(SPL_DEV))
		KERNEL$SUICIDE("kill_all AT SPL %08X", KERNEL$SPL);
#endif
	alloc_again:
	n = SUBPROC_CTL->n_procs;
	p = __sync_malloc(n * sizeof(pid_t));
	if (__unlikely(!p)) {
		return -1;
	}
	if (__unlikely(SUBPROC_CTL->n_procs > n)) {
	/* number of processes may have grown while we were waiting
	   in __sync_malloc */
		__slow_free(p);
		goto alloc_again;
		
	}
	i = 0;
	LIST_FOR_EACH(pcb, &SUBPROC_CTL->proc_list, PROC_CONTROL_BLOCK, list) {
		p[i++] = __64LE2CPU(*(__u64 *)pcb->jobname);
	}
#if __DEBUG >= 1
	n = SUBPROC_CTL->n_procs;
	if (__unlikely(i != n))
		KERNEL$SUICIDE("kill: NUMBER OF PROCESSES MISCOUNTED: %d != %d (n_procs)", i, n);
#endif
	for (i = 0; i < n; i++) {
		kill_proc(p[i], sig);
	}
	free(p);
	return 0;
}

int pthread_atfork(void (*prepare)(void), void (*parent)(void), void (*child)(void))
{
	struct atfork_struct *af;
	if (__unlikely(KERNEL$KERNEL)) return EKERNEL;
	if (__unlikely(!(af = malloc(sizeof(struct atfork_struct))))) return ENOMEM;
	af->prepare = prepare;
	af->parent = parent;
	af->child = child;
	ADD_TO_LIST_END(&atfork, &af->list);
	return 0;
}

void LIBPROC_CLEANUP(int sigkill)
{
	PROC_CONTROL_BLOCK *pcb;
	RAISE_SPL(SPL_DEV);
	LIST_FOR_EACH(pcb, &SUBPROC_CTL->proc_list, PROC_CONTROL_BLOCK, list) {
		pcb->terminate_flag = 0;
	}
	again:
	LIST_FOR_EACH(pcb, &SUBPROC_CTL->proc_list, PROC_CONTROL_BLOCK, list) if (pcb->forktable || sigkill) {
		if (pcb->state == PCB_DONE) {
			PROC_CTRL_RQ pcr;
			memcpy(pcr.jobname, pcb->jobname, 9);
			pcr.op = PROC_CTRL_ZAP;
			pcr.msg = (char *)&KERNEL$LIST_END;
			pcr.session = NULL;
			SYNC_IO(&pcr, KERNEL$PROC_CTRL);
			goto again;
		} else if (pcb->state == PCB_PREPARING) {
			if (!pcb->forktable) {
				goto slp;
			}
			/* when process uses both threads and fork and exits
			   while fork is in progress, it will leak references.
			   The same applies for dup & many other :-/ */
		} else {
			DEL_FROM_LIST(&pcb->list);
			ADD_TO_LIST_END(&SUBPROC_CTL->proc_list, &pcb->list);
			if (!pcb->terminate_flag) {
				pcb->terminate_flag = 1;
				kill(__64LE2CPU(*(__u64 *)pcb->jobname), SIGKILL);
			} else {
				slp:
				KERNEL$SLEEP(1);
			}
			goto again;
		}
	}
	LOWER_SPL(SPL_BOTTOM);
}
