#include <SPAD/LIBC.H>
#include <SPAD/LIST.H>
#include <SPAD/LINK.H>
#include <STRING.H>
#include <KERNEL/VMDEF.H>

#include <KERNEL/LINK.H>

static int process_relocs(struct link_header *lh, struct relocs *rels, __f_off value)
{
	struct section *secs = (struct section *)((char *)lh + lh->sections);
	__u8 *rel = (__u8 *)((char *)lh + rels->rel);
	__f_off pos = 0;
	unsigned type = REL_DEFAULT_TYPE;
	unsigned section = REL_DEFAULT_SECTION;
	unsigned count, add = 0 /* against warning */;
	value -= rels->last_val;
	if (__unlikely(!value)) return 0;
	rels->last_val += value;
	while (1) {
/* this is check is not exact ---
   it is check against most corruptions, not against all corruptions */
		if (__unlikely((char *)rel < (char *)secs[0].ptr) || __unlikely((char *)rel >= (char *)secs[0].ptr + secs[0].len)) return -1;
		if (__likely(rel[0] < REL_SPECIAL)) {
			pos += rel[0];
			rel++;
			do_reloc:
			count = 0;
			do_repeat:
			/*__debug_printf("reloc @ %x (%x)\n", pos, (char *)rel - (char *)secs[0].ptr);*/
			if (__unlikely(pos + sizeof(__f_off) > secs[section].len)) {
				return -1;
			}
			if (__likely(type == REL_SPECIAL_TYPE_ADD))
				*(__f_off *)((char *)secs[section].ptr + pos) += value;
			else
				*(__f_off *)((char *)secs[section].ptr + pos) -= value;
			if (__unlikely(count)) {
				add_do_repeat:
				count--;
				pos += add;
				goto do_repeat;
			}
			continue;
		} else if (__likely(rel[0] & REL_SPECIAL_LONG1)) {
			pos += ((rel[0] & REL_SPECIAL_LONG1_VAL) << 8) + rel[1];
			rel += 2;
			goto do_reloc;
		} else if (rel[0] & REL_SPECIAL_RLE) {
			count = (rel[0] & REL_SPECIAL_RLE_REPEAT_MINUS_3) + 3;
			add = rel[1];
			rel += 2;
			if (__unlikely(count == REL_SPECIAL_RLE_REPEAT_MINUS_3 + 3)) count += *rel++;
			goto add_do_repeat;
		} else if (rel[0] & REL_SPECIAL_LONG2) {
			int i = rel[0] & REL_SPECIAL_LONG2_BYTES_MINUS_1;
			rel++;
			do {
				pos += rel[0] << (8 * i);
				rel++;
			} while (--i >= 0);
			goto do_reloc;
		} else {
			type = rel[0] & REL_SPECIAL_TYPE_MASK;
			if (__unlikely(type == REL_SPECIAL_TYPE_END)) return 0;
			if (__unlikely(type >= REL_SPECIAL_TYPE_INVALID)) {
				return -1;
			}
			section = rel[1];
			if (__unlikely(section >= lh->n_sections)) {
				return -1;
			}
			rel += 2;
			pos = 0;
			continue;
		}
	}
}

/*
 * NOTE: this is called to relocate kernel itself.
 * It is not relocated and must not use global or static variables.
 * switch statement is also forbidden.
 */

int LINK_RELOC(struct link_header *lh, __f_off voff)
{
	int i;
	struct section *secs = (struct section *)((char *)lh + lh->sections);
	for (i = 0; i <= 4; i++) {
		if (__unlikely(process_relocs(lh, &secs[i].relocs, secs[i].ptr + voff))) {
			/*__debug_printf("relf: %d\n", i);*/
			return -1;
		}
	}
	if (__unlikely(voff != 0)) for (i = 0; i <= 4; i++) secs[i].ptr += voff;
	return 0;
}

#include <KERNEL/LINKSIZE.I>

int LINK_RELOC_MODULE(void *code_off, void *data_off)
{
	struct link_header *h = code_off;
	struct section *secs = (struct section *)((char *)h + h->sections);
	if (__likely(!data_off)) data_off = (char *)code_off + secs[2].offset;
	secs[0].ptr = (__f_off)code_off + secs[0].offset;
	secs[1].ptr = (__f_off)code_off + secs[1].offset;
	secs[2].ptr = (__f_off)data_off;
	secs[3].ptr = (__f_off)data_off + (secs[3].offset - secs[2].offset);
	secs[4].ptr = (__f_off)data_off + (secs[4].offset - secs[2].offset);
	return LINK_RELOC(h, 0);
}

int LINK_GET_MODULE_EXPORT_NAME(void *code_off, char **name, int *sh, char error[__MAX_STR_LEN])
{
	char *nm;
	struct link_header *h = code_off;
	*sh = !!(h->flags & LINK_SHARED);
	nm = (char *)((__f_off)h + h->lib_name);
	if (__unlikely(nm < (char *)h) || __unlikely(nm >= (char *)h + h->compression_offset) || __unlikely(!memchr(nm, 0, (char *)h + h->compression_offset - nm))) {
		_snprintf(error, __MAX_STR_LEN, "BAD MODULE EXPORT NAME");
		return -1;
	}
	*name = nm;
	return 0;
}

int LINK_GET_DEPENDENCY(void *code_off, unsigned n, char **name, unsigned *flags, char error[__MAX_STR_LEN])
{
	char *nm;
	struct link_header *h = code_off;
	struct library *l;
	if (__unlikely(n >= h->n_libs)) KERNEL$SUICIDE("LINK_GET_DEPENDENCY: INDEX %u, MAX %u", n, h->n_libs);
	l = (struct library *)((__f_off)h + h->libs) + n;
	if (__unlikely((char *)l < (char *)h) || __unlikely((char *)(l + 1) > (char *)h + h->compression_offset)) {
		badf:
		_snprintf(error, __MAX_STR_LEN, "BAD DEPENDENCY");
		return -1;
	}
	*flags = l->flags;
	nm = (char *)h + l->lib_name;
	if (__unlikely(nm < (char *)h) || __unlikely(nm >= (char *)h + h->compression_offset) || __unlikely(!memchr(nm, 0, (char *)h + h->compression_offset - nm))) goto badf;
	*name = nm;
	return 0;
}

int LINK_GET_SYMBOL(void *code_off, __const__ char *name, int mode, __f_off *val)
{
	struct link_header *h = code_off;
	struct sym *syms = (struct sym *)((__f_off)h + h->syms);
	int bot, top;
	again:
	switch (mode) {
		case SYM_EXPORTED:
			bot = 0;
			top = h->n_exported_syms - 1;
			break;
		case SYM_SPECIAL:
			bot = h->n_exported_syms;
			top = h->n_exported_syms + h->n_special_syms - 1;
			break;
		case SYM_INTERNAL:
			bot = h->n_exported_syms + h->n_special_syms;
			top = h->n_syms - 1;
			break;
		default:
			KERNEL$SUICIDE("LINK_GET_SYMBOL: MODE %d", mode);
	}
	while (top >= bot) {
		int mid = (top + bot) / 2;
		int c = strcmp((char *)h + syms[mid].name, name);
		if (c < 0) bot = mid + 1;
		else if (__likely(c > 0)) top = mid - 1;
		else {
			__f_off soff;
			unsigned sec = (__u8)((char *)h + syms[mid].name)[-1];
			if (__unlikely(sec == 0xff)) soff = 0;
			else if (__unlikely((unsigned)sec >= h->n_sections)) return -1;
			else soff = ((struct section *)((char *)h + h->sections))[sec].ptr;
			*val = syms[mid].value + soff;
			return 0;
		}
	}
	if (mode--) goto again;
	return -1;
}

int LINK_FIXUP_DLL_DEPENDENCY(void *code_off, int dll_n, void *dll_off, char error[__MAX_STR_LEN])
{
	int i;
	struct link_header *h = code_off;
	struct library *lib = (struct library *)((__f_off)h + h->libs) + dll_n;
	struct lib_sym *ls;
	for (ls = (struct lib_sym *)((__f_off)h + lib->syms), i = 0; (unsigned)i < lib->n_syms; ls++, i++) {
		__f_off val;
		if (__unlikely(LINK_GET_SYMBOL(dll_off, (char *)h + ls->name, SYM_EXPORTED, &val))) {
			_snprintf(error, __MAX_STR_LEN, "SYMBOL `%s' NOT FOUND", (char *)h + ls->name);
			return -1;
		}
		if (__unlikely(process_relocs(h, &ls->reloc, val))) {
			/*__debug_printf("fixup fail: %s: %d != %d\n", (char *)h + ls->name, ls->reloc.last_val, val);*/
			_snprintf(error, __MAX_STR_LEN, "RELOC OF SYMBOL `%s' FAILED", (char *)h + ls->name);
			return -1;
		}
	}
	return 0;
}

char *LINK_GET_SYMBOL_NAME(void *code, __const__ void *sym, unsigned long *offset, int codeonly)
{
	char *name;
	struct section *secs;
	struct sym *syms;
	unsigned sec, i;
	struct link_header *lh = code;
	if (__unlikely(lh->flags & LINK_STRIPPED)) return NULL;
	secs = (struct section *)((char *)lh + lh->sections);
	for (sec = 0; sec <= 4; sec++) {
		if ((char *)sym >= (char *)secs[sec].ptr && (char *)sym < (char *)secs[sec].ptr + secs[sec].len) {
			if (!codeonly || sec == 1) goto found_sec;
		}
	}
	return NULL;
	found_sec:
	syms = (struct sym *)((char *)lh + lh->syms);
	*offset = (unsigned long)-1L;
	name = NULL;
	for (i = 0; i < lh->n_syms; i++) {
		if (((char *)lh + syms[i].name)[-1] == sec && syms[i].value + secs[sec].ptr <= (__f_off)sym && (__f_off)sym - (syms[i].value + secs[sec].ptr) < *offset)
			name = (char *)lh + syms[i].name, *offset = (__f_off)sym - (syms[i].value + secs[sec].ptr);
	}
	return name;
}

int LINK_GET_SYMBOL_COUNTS(void *code, unsigned *n_exported_syms, unsigned *n_special_syms, unsigned *n_syms, char error[__MAX_STR_LEN])
{
	struct link_header *lh = code;
	if (__unlikely(lh->n_exported_syms > lh->n_syms) ||
	    __unlikely(lh->n_special_syms > lh->n_syms) ||
	    __unlikely(lh->n_exported_syms + lh->n_special_syms > lh->n_syms)) {
		_snprintf(error, __MAX_STR_LEN, "INVALID SYMBOL COUNTS");
		return -1;
	}
	*n_exported_syms = lh->n_exported_syms;
	*n_special_syms = lh->n_special_syms;
	*n_syms = lh->n_syms;
	return 0;
}

char *LINK_GET_SYMBOL_BY_INDEX(void *code, unsigned idx, __f_off *val, char error[__MAX_STR_LEN])
{
	struct link_header *lh = code;
	struct sym *sym = (struct sym *)((__f_off)lh + lh->syms) + idx;
	unsigned sec;
	__f_off soff;
	if (__unlikely(idx >= lh->n_syms))
		KERNEL$SUICIDE("LINK_GET_SYMBOL_BY_INDEX: INVALID INDEX %u (%u SYMBOLS)", idx, lh->n_syms);
	sec = (__u8)((char *)lh + sym->name)[-1];
	if (__unlikely(sec == 0xff)) soff = 0;
	else if (__unlikely((unsigned)sec >= lh->n_sections)) {
		_snprintf(error, __MAX_STR_LEN, "BAD SYMBOL SECTION %u", sec);
		return NULL;
	} else soff = ((struct section *)((char *)lh + lh->sections))[sec].ptr;
	*val = sym->value + soff;
	return (char *)lh + sym->name;
}


