#ifndef __KERNEL_LINK_H
#define __KERNEL_LINK_H

#include <SPAD/LINK.H>
#include <SPAD/LIBC.H>

int LINK_CHECK_HEADER(void *head, unsigned *header_size, unsigned *n_dependencies, unsigned *hash_method, unsigned *compression_method, unsigned long *compressed_file_size, char error[__MAX_STR_LEN]);
int LINK_GET_SECTIONS_SIZE(void *head, unsigned long *code_size, unsigned long *rodata_size, unsigned long *data_size, unsigned long *bss_size, char error[__MAX_STR_LEN]);
int LINK_RELOC(struct link_header *lh, __f_off voff);
int LINK_RELOC_MODULE(void *code_off, void *data_off);
int LINK_GET_MODULE_EXPORT_NAME(void *code_off, char **name, int *sh, char error[__MAX_STR_LEN]);
int LINK_GET_DEPENDENCY(void *code_off, unsigned n, char **name, unsigned *flags, char error[__MAX_STR_LEN]);
#define SYM_EXPORTED	0
#define SYM_SPECIAL	1
#define SYM_INTERNAL	2
int LINK_GET_SYMBOL(void *code_off, __const__ char *name, int mode, __f_off *val);
int LINK_FIXUP_DLL_DEPENDENCY(void *code_off, int dll_n, void *dll_off, char error[__MAX_STR_LEN]);
char *LINK_GET_SYMBOL_NAME(void *code, __const__ void *sym, unsigned long *offset, int codeonly);
int LINK_GET_SYMBOL_COUNTS(void *code, unsigned *n_exported_syms, unsigned *n_special_syms, unsigned *n_syms, char error[__MAX_STR_LEN]);
char *LINK_GET_SYMBOL_BY_INDEX(void *code, unsigned idx, __f_off *val, char error[__MAX_STR_LEN]);

#endif
