static int refill_reserved(PROC *p, WQ **wq);

alloc
{
	type *h;
	if (__likely(p->reserved)) {
		goth:
#if __DEBUG >= 1
		if (__unlikely(XLIST_EMPTY(&p->reserved_list)))
			KERNEL$SUICIDE("RESERVED LIST EMPTY, RESERVED COUNT %d", p->reserved);
#endif
		h = LIST_STRUCT(p->reserved_list.next, type, list_entry);
		DEL_FROM_LIST(&h->list_entry);
		p->reserved--;
	} else {
		if (refill_reserved(p, wq)) {
			goto goth;
		}
		return NULL;
	}
#if __DEBUG >= 1
	if (__unlikely(h->proc_entry != p))
		KERNEL$SUICIDE("HANDLE NOT IN PROCESS: HANDLE %p, PROC_ENTRY %p, PROCESS %p", h, h->proc_entry, p);
#endif
			/*test_all_handles();*/
	alloc_special;
			/*test_all_handles();*/
	return h;
}

/* Warning: PROC_FREE_UIORQ may destroy the process */

void ffree(type *h)
{
	PROC *p = h->proc_entry;
	DEL_FROM_LIST(&h->list_entry);
	ADD_TO_XLIST(&p->reserved_list, &h->list_entry);
	if (__unlikely(++p->reserved >= reserved_max(p) * 2)) {
		if (__unlikely(!p->on_reclaim_list)) {
			p->on_reclaim_list = 1;
			ADD_TO_XLIST(&reclaim_list, &p->reclaim_list);
		}
	}
	WQ_WAKE_ALL(&p->free_resources);
	free_debug;
	free_special;	/* must be last --- may destroy process */
}

static int refill_reserved(PROC *p, WQ **wq)
{
	if (p->reserved < reserved_min(p)) do {
		type *h;
		QUOTA_R *pzap;
		retry:
		QRALLOC(&p->q, 1, q_isroot, q_parent, Q_NULL_CALL, pzap, {
			PROC *pz;
			PROC *diff;
			h_zap:
			QRZAP(pzap, q_forall, q_forall_tail, pzap, 1);
			pz = LIST_STRUCT(pzap, PROC, q);
			if (pz == p) goto restrict_done;
			if (shutdown_some(pz, 0)) {
				goto retry;
			}
			FIND_DIFFERING_PROC(p, pz, diff, {
				QRRESTRICT(&diff->q);
				goto restrict_done;
			});
			restrict_done:
			*wq = &p->free_resources;
			shutdown_self:
			shutdown_some(p, 1);
			return !XLIST_EMPTY(&p->reserved_list);
		});
		if (charge_alloc) {
			if (__unlikely((*wq = KERNEL$MAY_ALLOC(p, charge_alloc)) != NULL)) {
				QRFREE(&p->q, 1, q_isroot, q_parent, Q_NULL_CALL);
				goto shutdown_self;
			}
		}
		h = __slalloc(&slab);
		if (__unlikely(!h)) {
			QRFREE(&p->q, 1, q_isroot, q_parent, Q_NULL_CALL);
			pzap = &KERNEL$PROC_KERNEL.q;
			goto h_zap;
		}
		h->proc_entry = p;
		ADD_TO_XLIST(&p->reserved_list, &h->list_entry);
		p->reserved++;
		new_special;
	} while (__likely(p->reserved < reserved_max(p)));
	return 1;
}

static __finline__ void free_one_reserved(PROC *p, type *h)
{
	DEL_FROM_LIST(&h->list_entry);
	p->reserved--;
	drop_special;
	__slfree(h);
	QRFREE(&p->q, 1, q_isroot, q_parent, Q_NULL_CALL);
}

static int free_reserved(PROC *p, int n)
{
	type *h, *hh;
	int f = 0;
	XLIST_FOR_EACH(h, &p->reserved_list, type, list_entry) {
		if (h >= &p->reserved_area[0] && h < &p->reserved_area[reserved_area_size]) continue;
		hh = LIST_STRUCT(h->list_entry.prev, type, list_entry);
		free_one_reserved(p, h);
		if (!--n) return 1;
		f = 1;
		h = hh;
	}
	return f;
}

#undef type
#undef proc_entry
#undef alloc
#undef alloc_special
#undef ffree
#undef free_debug
#undef free_special
#undef new_special
#undef drop_special
#undef reserved
#undef reserved_list
#undef list_entry
#undef refill_reserved
#undef reserved_min
#undef reserved_max
#undef q
#undef q_isroot
#undef q_parent
#undef q_forall
#undef q_forall_tail
#undef shutdown_some
#undef slab
#undef charge_alloc
#undef free_one_reserved
#undef free_reserved
#undef reserved_area
#undef reserved_area_size

