DECL_AST(IORQ_AST_, SPL_DEV, IORQ_)
{
	unsigned long pf;
	UIORQ *u = GET_STRUCT(RQ, UIORQ, u.iorq_);
#if __DEBUG >= 1
	if (__unlikely((u->u.iorq_.status & RQS_PROC_MASK) == RQS_PROC))
		KERNEL$SUICIDE(__stringify(IORQ_AST_)": ACTIVE REQUEST, STATUS %lX", u->u.iorq_.status);
#endif
	copyagain:
	pf = POST(u->proc, u->iorq, &u->u.iorq_);
	/*__debug_printf("%p: post: %lx\n", u->proc, pf);*/
	if (__unlikely(pf != 0)) {
		u->pfw.fn = IORQ_PAGE_ERROR;
		u->pfw.status = RQS_PROCESSING;
		u->pfw.tmp1 = (unsigned long)IORQ_POST_AST;
		if (__likely(!VM_FAULT(u->proc, (void *)(pf & ~1UL), (pf & PF_WRITE) | PF_SWAPPER, &u->pfw))) {
			goto copyagain;
		}
		RETURN;
	}
	PROC_FREE_UIORQ(u);
	RETURN;
}

DECL_IOCALL(IORQ_RECALL_, SPL_DEV, IORQ_)
{
	HANDLE *h;
	UIORQ *u = GET_STRUCT(RQ, UIORQ, u.iorq_);
	if (__unlikely(KERNEL$LOCKUP_LEVEL >= LOCKUP_LEVEL_ALL_IORQS)) {
		u->u.iorq_.status = -EINTR;
		RETURN_AST(&u->u.iorq_);
	}
	/*__debug_printf("recall: %p\n", u->proc);*/
	if (__likely((unsigned long)u->vspace == UPLACE(UDATA_STRUCT + OFF_UDATA_vspace)))
		u->u.iorq_.v.vspace = (HANDLE *)&u->proc->vspace;
	else {
		GET_HANDLE_FAST(h, u->proc, (unsigned long)u->vspace, 0, (IORQ *)&u->u.iorq_, {
			if (__unlikely(__IS_ERR(h))) {
				ret_err_h:
				/*u->u.iorq_.v.vspace = NULL;*/
				u->u.iorq_.status = __PTR_ERR(h);
				RETURN_AST(&u->u.iorq_);
			}
			if (__unlikely(!h)) {
				ret_wait:
				/*u->u.iorq_.v.vspace = NULL;*/
				RETURN;
			}
		});
		u->u.iorq_.v.vspace = h;
		LOWER_SPL(SPL_DEV);
	}
	GET_HANDLE_FAST(h, u->proc, u->u.iorq_.h, 0, (IORQ *)&u->u.iorq_, {
		if (__unlikely(__IS_ERR(h))) goto ret_err_h;
		if (__unlikely(!h)) goto ret_wait;
	});
	u->u.iorq_.handle = h;
	rop(u->sys);
}

static void SYSCALL_NAME(unsigned long sys, unsigned long rq, unsigned long arg3)
{
	WQ *wq;
	UIORQ *u;
	HANDLE *h;
	unsigned long vf;
	/*__debug_printf("syscall(%x): %p, %p\n", sys, PROC_RUN, rq);*/
	/*if (__unlikely(!rq)) goto end;*/
	CHECK_RQ_ALIGN(rq, IORQ_ALIGN, end);
	u = PROC_ALLOC_UIORQ(PROC_RUN, &wq);
	if (__unlikely(!u)) {
		PROC_WAIT(PROC_RUN, wq);
		goto end;
	}
	u->iorq = (IORQ *)rq;
	retry:
	vf = GET(PROC_RUN, (IORQ *)rq, &u->u.iorq_);
	if (__unlikely(vf != 0)) {
		if (__likely(!PROC_VM_FAULT(PROC_RUN, (void *)(vf & ~1UL), (vf & PF_WRITE) | PF_SWAPPER))) goto retry;
		end_free:
		PROC_FREE_UIORQ(u);
		goto end;
	}
	if (__unlikely(SYSCALL_RETURN(PROC_RUN, 0))) goto end_free;
	/*__debug_printf("sio: h = %d, v = (%Lx,%ld,%p), p = %ld.", u->u.iorq_.h, u->u.iorq_.v.ptr, u->u.iorq_.v.len, u->u.iorq_.v.vspace, u->u.iorq_.progress);*/
	u->u.iorq_.fn = IORQ_AST_;
	u->u.iorq_.tmp1 = (unsigned long)IORQ_RECALL_;
	u->u.iorq_.status = RQS_PROCESSING;
	u->vspace = u->u.iorq_.v.vspace;
	if (__likely((unsigned long)u->vspace == UPLACE(UDATA_STRUCT + OFF_UDATA_vspace))) {
		u->u.iorq_.v.vspace = (HANDLE *)&PROC_RUN->vspace;
	} else {
		GET_HANDLE_FAST(h, PROC_RUN, (unsigned long)u->vspace, 0, (IORQ *)&u->u.iorq_, {
			if (__unlikely(__IS_ERR(h))) {
				ret_err_h:
				/*u->u.iorq_.v.vspace = NULL;*/
				u->u.iorq_.status = __PTR_ERR(h);
				LOWER_SPL(SPL_USER);
				CALL_AST(&u->u.iorq_);
				JMP_IDLE_LOOP();
				return;
			}
			if (__unlikely(!h)) {
				ret_wait:
				/*u->u.iorq_.v.vspace = NULL;*/
				u->sys = sys;
				goto end;
			}
		});
		u->u.iorq_.v.vspace = h;
		LOWER_SPL(SPL_DEV);
	}
	GET_HANDLE_FAST(h, PROC_RUN, u->u.iorq_.h, 0, (IORQ *)&u->u.iorq_, {
		if (__unlikely(__IS_ERR(h))) goto ret_err_h;
		if (__unlikely(!h)) goto ret_wait;
	});
#ifdef test_flags
	if (__unlikely(!(h->handle_num & (test_flags(sys))))) {
		/*__debug_printf("procio: wanted(%x for %s) eperm (%x, %x)\n", u->u.iorq_.h, __func__, h->handle_num, test_flags(sys));*/
		h = __ERR_PTR(-EPERM);
		goto ret_err_h;
	}
#endif
	u->u.iorq_.handle = h;
	LOWER_SPL(SPL_USER);
	op(sys);
	JMP_IDLE_LOOP();
	return;
	end:
	END_SYSCALL;
}

#undef IORQ_
#undef IORQ_AST_
#undef __FN_IORQ_AST_
#undef IORQ_RECALL_
#undef __FN_IORQ_RECALL_
#undef iorq_
#undef op
#undef rop
#undef POST
#undef GET
#undef SYSCALL_NAME
#ifdef test_flags
#undef test_flags
#endif
