#include <SPAD/SHELL.H>
#include <ARCH/IO.H>
#include <STRING.H>
#include <STDLIB.H>
#include <SPAD/SYSLOG.H>
#include <SPAD/WQ.H>

#include <KERNEL/SYSLOG.H>

char log_buffer[LOG_BUFFER_SIZE];
volatile unsigned log_buffer_start = 0, log_buffer_end = 0;
int log_buffer_overflow = 0;
WQ_DECL(log_wait, "KERNEL$LOG_WAIT");

#define N_LOG_ARGS	5

static SHRCRQ log_rq;
static SHCCRQ ctx_rq;
static int log_rq_pending = 0;
static CTX *log_ctx = NULL;
static char log_cmd[__MAX_STR_LEN];
static __const__ char *log_args[N_LOG_ARGS];
static char error_msg[__MAX_STR_LEN];
extern AST_STUB log_write_done;
extern AST_STUB log_ctx_created;

void log_write_buffer(void)
{
	char *e, *p;
	int i;
	again:
	if (__unlikely(log_rq_pending)) return;
	if (log_buffer_start == log_buffer_end) {
		int lo;
		KERNEL$DI();
		if (__unlikely(log_buffer_start != log_buffer_end)) {
			KERNEL$EI();
			goto neq;
		}
		log_buffer_start = log_buffer_end = 0;
		lo = log_buffer_overflow;
		log_buffer_overflow = 0;
		KERNEL$EI();
		WQ_WAKE_ALL(&log_wait);
		if (__likely(!lo)) return;
		KERNEL$SYSLOG(__SYSLOG_SW_WARNING, "SYSLOG", "LOG WRITE RATE TOO FAST --- MESSAGES LOST");
		goto again;
	}
	neq:
	if (__unlikely(!log_ctx)) {
		ctx_rq.fn = log_ctx_created;
		log_rq_pending = 1;
		CALL_IORQ(&ctx_rq, SHELL$CREATE_CONTEXT);
		return;
	}
	log_rq.fn = log_write_done;
	log_rq.ctx = log_ctx;
	if (__unlikely((e = getenv("@KERNEL$LOG_CMD")) != NULL)) {
		strlcpy(log_cmd, e, __MAX_STR_LEN);
		log_rq.ptr = log_cmd;
		log_rq.len = strlen(log_cmd);
	} else {
		log_rq.ptr = "LOG:/LOG.CMD '%@'";
		log_rq.len = strlen(log_rq.ptr);
	}
	log_rq.arg = log_args;
	log_rq.narg = N_LOG_ARGS;
	log_args[0] = log_rq.ptr;
	p = log_buffer + log_buffer_start;
	for (i = 1; i < N_LOG_ARGS; i++) {
		log_args[i] = p;
		p += strlen(p) + 1;
	}
	log_buffer_start = p - log_buffer;
	log_rq.error_msg = error_msg;
	log_rq_pending = 1;
	CALL_IORQ(&log_rq, SHELL$RUN_COMMANDS);
}

DECL_AST(log_write_done, SPL_TIMER, SHRCRQ)
{
	log_rq_pending = 0;
	log_write_buffer();
	RETURN;
}

DECL_AST(log_ctx_created, SPL_TIMER, SHCCRQ)
{
	log_rq_pending = 0;
	if (__unlikely(RQ->status < 0)) {
		__critical_printf("UNABLE TO ALLOCATE LOG SHELL CONTEXT: %s\n", strerror(-RQ->status));
		RETURN;
	}
	log_ctx = RQ->ctx;
	log_write_buffer();
	RETURN;
}
