#include <SPAD/LIBC.H>
#include <KERNEL/ASM.H>
#include <SPAD/AC.H>
#include <ARCH/IRQ.H>
#include <ARCH/BITOPS.H>
#include <KERNEL/TIME.H>
#include <KERNEL/SYSLOG.H>
#include <KERNEL/VM.H>

#include <SPAD/TIMER.H>
#include <KERNEL/TIMER.H>

#define JIFFIES_LOCKUP_ONE_PASS		1
#define JIFFIES_LOCKUP_ALL_IORQS	2
#define JIFFIES_LOCKUP_KERNEL_IORQS	3

LIST_HEAD SMALL_WHEEL[SMALL_WHEEL_SIZE];
LIST_HEAD BIG_WHEEL[BIG_WHEEL_SIZE];

IRQ_CONTROL TIMER_IRQ_CONTROL;

static AST TIMER_IRQ_AST;
static AST TIMER_AST;
static int TIMER_IRQ_AST_PENDING;
static int TIMER_AST_PENDING;

static LIST_HEAD pending_list;

static AST LOCKUP_AST;
static int LOCKUP_AST_PENDING;

DECL_RT_IRQ_HANDLER(TIMER_IRQ)
{
	/*{
		static int counter = 0;
		if (!(++counter & 511)) KERNEL$STACK_DUMP();
	}*/
	/* there are almost no empty rt irqs, so this will test them*/
	/*static int x = 0;
	if (!(++x & 3)) IRQ_RETURN;*/
	KERNEL_HOLD_JIFFIES++;
	if (__unlikely(KERNEL_HOLD_JIFFIES > JIFFIES_LOCKUP_ONE_PASS)) {
		if (__unlikely(KERNEL_HOLD_JIFFIES > JIFFIES_LOCKUP_ALL_IORQS)) {
			if (__unlikely(KERNEL_HOLD_JIFFIES > JIFFIES_LOCKUP_KERNEL_IORQS)) {
				KERNEL$LOCKUP_LEVEL = LOCKUP_LEVEL_KERNEL_IORQS;
			} else {
				KERNEL$LOCKUP_LEVEL = LOCKUP_LEVEL_ALL_IORQS;
			}
		} else {
			KERNEL$LOCKUP_LEVEL = LOCKUP_LEVEL_ONE_PASS;
		}
	}
	if (__likely(!TIMER_IRQ_AST_PENDING)) {
		TIMER_IRQ_AST_PENDING = 1;
		IRQ_POST_AST(&TIMER_IRQ_AST);
	}
	TIMER_IRQ_AST_PENDING++;
	IRQ_RETURN;
}

static void process_big_wheel(void);

DECL_AST(TIMER_IRQ_AST_FN, SPL_TOP, AST)
{
	int i;
	LIST_HEAD *list;
	if (__unlikely(__SUBINZ(&TIMER_IRQ_AST_PENDING, 1))) {
		CALL_AST(&TIMER_IRQ_AST);
	}
	if (__likely(KERNEL_HOLD_JIFFIES == 1)) {
		/* why not just WQ_WAKE_ALL(&KERNEL$LOCKUP_EVENTS)?:
			--- it may take long time and we are on SPL_TOP
			    - no loops are allowed on SPL_TOP
			--- another interrupt may set KERNEL$LOCKUP_LEVEL
			    during this time and we never finish
		*/
		if (__unlikely(!WQ_EMPTY(&KERNEL$LOCKUP_EVENTS))) {
			/* let at least the first one to go through even if it takes longer to process the queue than one timer tick */
			IORQ *rq = WQ_GET_ONE(&KERNEL$LOCKUP_EVENTS);
			/* no need to check rq != NULL, because we are at SPL_TOP */
			CALL_IORQ_LSTAT_EXPR(rq, (IO_STUB *)rq->tmp1);
			if (__likely(!LOCKUP_AST_PENDING)) {
				LOCKUP_AST_PENDING = 1;
				CALL_AST(&LOCKUP_AST);
			}
		}
	}
	/*if (__unlikely(KERNEL_HOLD_JIFFIES == JIFFIES_LOCKUP_KERNEL_IORQS + 2)) {
		__critical_printf("LOCKUP IN KERNEL (%u)\n", KERNEL_HOLD_JIFFIES);
		KERNEL$STACK_DUMP();
	}*/
	ARCH_UPDATE_TIME();
	i = ((unsigned)__JIFFIES >> KERNEL$JIFFIES_STEP_BITS) & (SMALL_WHEEL_SIZE - 1);
	if (__unlikely(!i)) {
		process_big_wheel();
		list = &SMALL_WHEEL[0];
	} else {
		list = &SMALL_WHEEL[i];
		INC_JIFFIES_LO();
	}
	if (__likely(LIST_EMPTY(list)) && __likely(!log_buffer_end)) {
		RETURN;
	}
	LIST_JOIN(&pending_list, list);
	INIT_LIST(list);

	if (__likely(!TIMER_AST_PENDING)) {
		TIMER_AST_PENDING = 1;
		RETURN_AST(&TIMER_AST);
	}
	RETURN;
}

static void process_big_wheel(void)
{
	LIST_ENTRY *n;
	LIST_HEAD *list;
	list = &BIG_WHEEL[((unsigned)__JIFFIES >> (SMALL_WHEEL_BITS + KERNEL$JIFFIES_STEP_BITS)) & (BIG_WHEEL_SIZE - 1)];
	n = list->next;
/* !!! TODO: this breaks the requirement that there shouldn't be loop on SPL_TOP. Move it down to SPL_TIMER */
	while (n != (LIST_ENTRY *)list) {
		TIMER *t = LIST_STRUCT(n, TIMER, list);
		u_jiffies_t j;
		n = n->next;
		j = __TIMER_GET_JIFFIES(t);
		if ((j & ~(u_jiffies_t)(unsigned)((SMALL_WHEEL_SIZE << KERNEL$JIFFIES_STEP_BITS) - 1)) == __JIFFIES) {
			unsigned wp = ((unsigned)j >> KERNEL$JIFFIES_STEP_BITS) & (SMALL_WHEEL_SIZE - 1);
			DEL_FROM_LIST(&t->list);
			ADD_TO_LIST(&SMALL_WHEEL[wp], &t->list);
		}
	}
	INC_JIFFIES();
}

DECL_AST(TIMER_AST_FN, SPL_TIMER, AST)
{
	LIST_ENTRY *l;
	TIMER *t;
	TIMER_AST_PENDING = 0;
	if (__unlikely(log_buffer_end)) log_write_buffer();
	__barrier();
	RAISE_SPL(SPL_TOP);
	while ((l = pending_list.next) != (LIST_ENTRY *)(void *)&pending_list) {
		DEL_FROM_LIST(l);
		l->next = NULL;
		t = LIST_STRUCT(l, TIMER, list);
		t->fn(t);
		LOWER_SPL(SPL_TIMER);
		RAISE_SPL(SPL_TOP);
	}
	RETURN;
}

DECL_AST(LOCKUP_AST_FN, SPL_ZERO, AST)
{
	WQ_WAKE_ALL_PL(&KERNEL$LOCKUP_EVENTS);
	LOCKUP_AST_PENDING = 0;
	RETURN;
}

void KTIMER_INIT(void)
{
	int i;
	TIMER_IRQ_AST.fn = &TIMER_IRQ_AST_FN;
	TIMER_IRQ_AST_PENDING = 0;
	TIMER_AST.fn = &TIMER_AST_FN;
	TIMER_AST_PENDING = 0;
	LOCKUP_AST.fn = &LOCKUP_AST_FN;
	LOCKUP_AST_PENDING = 0;
	INIT_LIST(&pending_list);
	for (i = 0; i < SMALL_WHEEL_SIZE; i++) INIT_LIST(&SMALL_WHEEL[i]);
	for (i = 0; i < BIG_WHEEL_SIZE; i++) INIT_LIST(&BIG_WHEEL[i]);
	__JIFFIES = 0;
	KERNEL_VM_INIT_2();
}


