#ifndef __KERNEL_UDATA_H
#define __KERNEL_UDATA_H

#include <SYS/TYPES.H>
#include <KERNEL/SYSDEF.H>
#include <SPAD/AC.H>
#include <SPAD/LIST.H>
#include <SPAD/DEV_KRNL.H>
#include <SPAD/WQ.H>
#include <SIGNAL.H>
#include <KERNEL/DEV.H>
#include <KERNEL/UDATADEF.H>
#include <SPAD/SWAPPER.H>

typedef struct {
	void *vmaddr;
	size_t vmsize;
	__v_off offset;
	int handle;
	short flags;
	short error;
#if VMMAP_PAD > 0
	char pad[VMMAP_PAD];
#endif
} VMMAP;

typedef struct {
	size_t size;
	void *next;
} HEAP_FREELIST_T;

typedef struct ___thread THREAD;

typedef struct {
	void *base;

	FFILE **handles;
	int n_handles;
	int last_handle;
	LNT *lnt;
	VMMAP *vmmaps;		/* vmmaps and n_vmmaps must be consecutive */
	int n_vmmaps;
	int last_vmmap;
	VMMAP *vmmaps_b;	/* pointer to backup VMMAPs (NVMMAPS + 1 entries) */
	char malloc_recurse;

	char timer_available;

	char xcpt_available;
	IORQ xcpt_handler;
	void *xcpt_return;
	unsigned long xcpt_type;
	void *xcpt_address;
	long xcpt_error;

	IORQ timer_handler;
	XLIST_HEAD timer_list;

	void **heap_freelist;

	HANDLE_OPERATIONS *vspace;

	char **environ;
	XLIST_HEAD environ_callbacks;
	XLIST_HEAD environ_list;
	char *progname;
	void (*exit_func)(int);

	int errno;

	int repost_ast_spl;
	AST_STUB *repost_ast_fn[KERNEL_CALL_MAX];

	THREAD *current_thread;
	THREAD *init_thread;
	LIST_HEAD thread_ready;
	XLIST_HEAD all_threads;
	char blocked;
	char preempt_ast_pending;  /* 0 no, 1 wakeup preempt, 2 timer */
	char preempt_timer_pending;

	char uiorq_overflow;

	TIMER preempt_timer;
	AST preempt_ast;

	int isthreaded;

	struct multiopen *multiopen;
	struct subproc_ctl *subproc_ctl;

	WQ logical_wait;

	XLIST_HEAD dl_modules;
	MTX dl_mtx;
	void *dl_exe;

	XLIST_HEAD intr_keys;
	char *cwd;
	char exiting;

	char signal_available;
	AST signal_ast;
	sigset_t sigblock;
	sigset_t sigpending;
	sigset_t thread_sigpending;
	struct sigaction sigaction[NSIG];

	unsigned repost_time;
	unsigned last_repost_time;

	__u8 kernel_dll_data[KERNEL_DLL_DATA_SIZE];
	__u8 rel_digest[REL_DIGEST_LENGTH];
} UDATA;

#define UDATA_ZERO_EXEC_OFFSET		__offsetof(UDATA, malloc_recurse)
#define UDATA_ZERO_EXEC_END_OFFSET	__offsetof(UDATA, kernel_dll_data)

#endif
