#ifndef AT
#define op	open
#define at_arg
#else
#define op	openat
#define at_arg	int dirfd,
#endif

int op(at_arg __const__ char *path, int oflags, ...)
{
	OPENRQ o;
#ifdef AT
	CWD cwd;
	CWDE cwde;
	char *p;
#endif
	__cancel_test();
#ifdef AT
	if (__unlikely(!path)) {
		if (__unlikely(dirfd == AT_FDCWD)) {
			errno = EINVAL;
			return -1;
		}
		path = "";
		goto do_at;
	}
#endif
	if (__unlikely(!path[0])) {
		errno = ENOENT;
		return -1;
	}
	if (__unlikely(path[0] == '/') && __unlikely(path[1] == 'd') && __likely(path[2] == 'e') && __likely(path[3] == 'v') && __likely(path[4] == '/')) {
		path = translate_unx(path);
	}
#ifdef AT
	if (dirfd != AT_FDCWD) {
		do_at:
		p = KERNEL$HANDLE_PATH(dirfd);
		if (__unlikely(!p)) {
			errno = EBADF;
			return -1;
		}
		make_cwd(cwd, cwde, p);
	}
#endif
	if (__unlikely(oflags & (O_NONBLOCK | O_DIRECT | _O_RENAME))) {
		va_list va;
		if (__likely(!(oflags & _O_RENAME))) {
#ifdef AT
			if (dirfd != AT_FDCWD) {
				return open_special(&cwd, path, oflags);
			} else
#endif
			{
				return open_special(KERNEL$CWD(), path, oflags);
			}
		}
		va_start(va, oflags);
		o.rename_handle = va_arg(va, int);
		va_end(va);
	}
	o.flags = oflags;
	o.path = path;
#ifdef AT
	if (dirfd != AT_FDCWD) {
		o.cwd = &cwd;
	} else
#endif
	{
		o.cwd = KERNEL$CWD();
	}
	SYNC_IO(&o, KERNEL$OPEN);
	if (__unlikely(o.status < 0)) {
		errno = -o.status;
		return -1;
	}
	return o.status;
}

#undef op
#undef at_arg

#ifdef AT
#undef AT
#endif
