#include <KERNEL/DEV.H>
#include <SPAD/AC.H>
#include <SYS/TYPES.H>
#include <SPAD/VM.H>
#include <STRING.H>
#include <SPAD/LIBC.H>

#if __DEBUG >= 1
#define SPLVSPACEASSERT(s)	\
do {				\
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_VSPACE))) KERNEL$SUICIDE("%s AT SPL %08X", (s), KERNEL$SPL);\
} while(0)
#else
#define SPLVSPACEASSERT(s)
#endif

__const__ HANDLE_OPERATIONS VIRTUAL_OPERATIONS = {
	0,
	VIRTUAL_GET,
	VIRTUAL_PUT,
	VIRTUAL_MAP,
	VIRTUAL_DMALOCK,
	VIRTUAL_DMA64LOCK,
	VIRTUAL_PHYSLOCK,
	VIRTUAL_GET_PAGEIN_RQ,
};

unsigned long VIRTUAL_GET(VDESC *desc, __const__ VBUF *buf)
{
	unsigned long s;
	SPLVSPACEASSERT("VIRTUAL_GET");
	LOWER_SPLX(buf->spl);
	s = buf->len;
	if (s > desc->len) s = desc->len;
	memcpy(buf->ptr, (void *)(unsigned long)desc->ptr, s);
	*__VOFF2U32(&desc->ptr) += s;
	desc->len -= s;
	return s;
}

unsigned long VIRTUAL_PUT(VDESC *desc, __const__ VBUF *buf)
{
	unsigned long s;
	/*__asm__ volatile ("movl %%cr3, %%eax; movl %%eax, %%cr3":::"ax");*/
	SPLVSPACEASSERT("VIRTUAL_PUT");
	LOWER_SPLX(buf->spl);
	s = buf->len;
	if (s > desc->len) s = desc->len;
	memcpy((void *)(unsigned long)desc->ptr, buf->ptr, s);
	*__VOFF2U32(&desc->ptr) += s;
	desc->len -= s;
	return s;
}

IORQ *VIRTUAL_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int rw)
{
	/*PGIN p;
	SPLVSPACEASSERT("VIRTUAL_GET_PAGEIN_RQ");
	p.rq = rq;
	p.io = (IO_STUB *)rq->tmp1;
	return p;*/
	KERNEL$SUICIDE("VIRTUAL_GET_PAGEIN_RQ CALLED");
	return NULL;
}

unsigned long KERNEL$NO_VSPACE_GET(VDESC *desc, __const__ VBUF *buf)
{
	LOWER_SPLX(buf->spl);
	return 0;
}

unsigned long KERNEL$NO_VSPACE_PUT(VDESC *desc, __const__ VBUF *buf)
{
	LOWER_SPLX(buf->spl);
	return 0;
}

void *KERNEL$NO_VSPACE_MAP(VDESC *desc, int rw, vspace_unmap_t **unmap)
{
	return NULL;
}

VDMA KERNEL$NO_VSPACE_DMALOCK(VDESC *desc, int rw, vspace_dmaunlock_t **unlock)
{
	VDMA dma;
	dma.ptr = 0;
	dma.len = 0;
	return dma;
}

void KERNEL$NO_VSPACE_DMA64LOCK(VDESC *desc, int rw, VDMA64 *dma, vspace_dma64unlock_t **unlock)
{
	dma->ptr = 0;
	dma->len = 0;
}

void KERNEL$NO_VSPACE_PHYSLOCK(VDESC *desc, int rw, VPHYS *p, vspace_physunlock_t **unlock)
{
	p->ptr = 0;
	p->len = 0;
}

IORQ *KERNEL$NO_VSPACE_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int wr)
{
	rq->status = -ENOVSPACE;
	CALL_AST(rq);
	return NULL;
}

PAGE *KERNEL$NO_VSPACE_GET_PAGE(HANDLE *h, __v_off idx, int wr)
{
	return __ERR_PTR(-ENOVSPACE);
}

int KERNEL$NO_VSPACE_SWAP_OP(HANDLE *h, int op, ...)
{
	return 0;
}

