#include <KERNEL/DEV.H>
#include <SPAD/AC.H>
#include <SYS/TYPES.H>
#include <SPAD/VM.H>
#include <STRING.H>
#include <SPAD/LIBC.H>

#if __DEBUG >= 1
#define SPLVSPACEASSERT(s)	\
do {				\
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_VSPACE))) KERNEL$SUICIDE("%s AT SPL %08X", (s), KERNEL$SPL);\
} while(0)
#else
#define SPLVSPACEASSERT(s)
#endif

unsigned long PHYSICAL_GET(VDESC *desc, __const__ VBUF *buf);
unsigned long PHYSICAL_PUT(VDESC *desc, __const__ VBUF *buf);
void *PHYSICAL_MAP(VDESC *desc, int rw, vspace_unmap_t **unmap);
void PHYSICAL_UNMAP(void *ptr);
VDMA PHYSICAL_DMALOCK(VDESC *desc, int rw, vspace_dmaunlock_t **unlock);
void PHYSICAL_DMA64LOCK(VDESC *desc, int rw, VDMA64 *dma, vspace_dma64unlock_t **unlock);
void PHYSICAL_PHYSLOCK(VDESC *desc, int rw, VPHYS *dma, vspace_physunlock_t **unlock);
IORQ *PHYSICAL_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int rw);

__const__ HANDLE_OPERATIONS PHYSICAL_OPERATIONS = {
	0,
	PHYSICAL_GET,
	PHYSICAL_PUT,
	PHYSICAL_MAP,
	PHYSICAL_DMALOCK,
	PHYSICAL_DMA64LOCK,
	PHYSICAL_PHYSLOCK,
	PHYSICAL_GET_PAGEIN_RQ,
};

HANDLE KERNEL$PHYSICAL = { &PHYSICAL_OPERATIONS };
HANDLE KERNEL$VIRTUAL = { &VIRTUAL_OPERATIONS };

void *PHYSICAL_MAP(VDESC *desc, int rw, void (**unmap)(void *))
{
	SPLVSPACEASSERT("PHYSICAL_MAP");
	*unmap = PHYSICAL_UNMAP;
	return KERNEL$MAP_PHYSICAL_BANK(desc->ptr);
}

void PHYSICAL_UNMAP(void *ptr)
{
	SPLVSPACEASSERT("PHYSICAL_UNMAP");
	KERNEL$UNMAP_PHYSICAL_BANK(ptr);
}

unsigned long PHYSICAL_GET(VDESC *desc, __const__ VBUF *buf)
{
	void *p;
	unsigned long s;
	SPLVSPACEASSERT("PHYSICAL_GET");
	LOWER_SPLX(buf->spl);
	s = buf->len;
	if (s > desc->len) s = desc->len;
	p = KERNEL$MAP_PHYSICAL_BANK(desc->ptr);
	memcpy(buf->ptr, p, s);
	KERNEL$UNMAP_PHYSICAL_BANK(p);
	*__VOFF2U32(&desc->ptr) += s;
	desc->len -= s;
	return s;
}

unsigned long PHYSICAL_PUT(VDESC *desc, __const__ VBUF *buf)
{
	void *p;
	unsigned long s;
	SPLVSPACEASSERT("PHYSICAL_PUT");
	LOWER_SPLX(buf->spl);
	s = buf->len;
	if (s > desc->len) s = desc->len;
	p = KERNEL$MAP_PHYSICAL_BANK(desc->ptr);
	memcpy(p, buf->ptr, s);
	KERNEL$UNMAP_PHYSICAL_BANK(p);
	*__VOFF2U32(&desc->ptr) += s;
	desc->len -= s;
	return s;
}

IORQ *PHYSICAL_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int rw)
{
	/*PGIN p;
	SPLVSPACEASSERT("PHYSICAL_GET_PAGEIN_RQ");
	p.rq = rq;
	p.io = (IO_STUB *)rq->tmp1;
	return p;*/
	KERNEL$SUICIDE("PHYSICAL_GET_PAGEIN_RQ CALLED");
	return NULL;
}

