static void UNL(UNL_TYPE ptr);
static void UNL_SPAGE(UNL_TYPE ptr);
#ifdef UNL_ZERO
static void UNL_ZERO(UNL_TYPE ptr);
#endif

FN
{
	DECL
	PROC *p;
	PAGE *pg;
	unsigned off;
	unsigned long l;
	SPLVSPACEASSERT(FN_NAME);
	p = GET_STRUCT(desc->vspace, PROC, vspace);
	pg = VM_ARCH_GET_PAGE(p, (unsigned long)desc->ptr, rw & PF_WRITE);
	if (__unlikely(!pg)) {
		ret0:
		RET_ZERO;
	}
	*unlock = UNL;
	if (__unlikely(!IS_PAGE_POINTER(pg))) {
#define sp	((SPAGE *)pg)
		*unlock = UNL_SPAGE;
		off = (unsigned long)desc->ptr & (PAGE_CLUSTER_SIZE - 1);
		if (__unlikely(off >= sp->n_pages << PG_SIZE_BITS)) {
#ifdef UNL_ZERO
			*unlock = UNL_ZERO;
#else
			*unlock = KERNEL$NULL_VSPACE_PHYSUNLOCK;
#endif
			off &= PG_SIZE - 1;
			l = desc->len;
			if (l > PG_SIZE - off) l = PG_SIZE - off;
			RET_MAP(PHYS_2_PAGE_ALIGNED(ZERO_PAD_PHYS), 0, l);
		}
		if (__unlikely(sp->lockdown(sp, 0) != NULL)) {
			goto ret0;
		}
		l = desc->len;
		if (__unlikely(l > (sp->n_pages << PG_SIZE_BITS) - off))
			l = (sp->n_pages << PG_SIZE_BITS) - off;
		RET_MAP(sp->page, sp->offset + off, l);
#undef sp
	}
	if (__unlikely(pg->lockdown(pg, 0) != NULL)) {
		goto ret0;
	}
	off = (unsigned long)desc->ptr & (PAGE_CLUSTER_SIZE - 1);
	l = desc->len;
	if (l > PAGE_CLUSTER_SIZE - off) l = PAGE_CLUSTER_SIZE - off;
	RET_MAP(pg, off, l);
}

static void UNL(UNL_TYPE ptr)
{
	PAGE *p;
	SPLVSPACEASSERT(__stringify(UNL));
	p = DO_UNMAP(ptr);
	p->lockdown(p, 1);
}

static void UNL_SPAGE(UNL_TYPE ptr)
{
	PAGE *p;
	unsigned pos;
	SPAGE *s;
	SPLVSPACEASSERT(__stringify(UNL_SPAGE));
	p = DO_UNMAP(ptr);
	pos = ((unsigned)ptr & (PAGE_CLUSTER_SIZE - 1)) >> PG_SIZE_BITS;
	s = (SPAGE *)((SPAGES *)p->fnode)->s[pos + 1].freelist.next;
	s->lockdown(s, 1);
}

#ifdef UNL_ZERO
static void UNL_ZERO(UNL_TYPE ptr)
{
	SPLVSPACEASSERT(__stringify(UNL_ZERO));
	DO_UNMAP(ptr);
}
#endif

#undef FN
#undef FN_NAME
#undef UNL
#undef UNL_SPAGE
#undef UNL_TYPE
#ifdef UNL_ZERO
#undef UNL_ZERO
#endif
#undef DECL
#undef RET_ZERO
#undef RET_MAP
#undef DO_UNMAP
