#include <UNISTD.H>
#include <STRING.H>
#include <STDLIB.H>
#include <ERRNO.H>
#include <SYS/TYPES.H>
#include <ENDIAN.H>
#include <SPAD/LIBC.H>

#include "CHRCACHE.H"

#include <SPAD/CHARSET.H>

#define HASH_SIZE	1024
#define UNI_HASH(u)	((((u) & 255) << 2) | (((u) >> 8) & 3))

struct __charset_8b {
	CHRCACHE_HEAD;
	__s32 chr2uni[256];
	unsigned char uni2chr[HASH_SIZE];
};

static int insert_hash(CHARSET_8B *conv, unsigned char c)
{
	unsigned hash;
	__s32 u = conv->chr2uni[c];
	if (__unlikely(u == -1)) return 0;
	hash = UNI_HASH(u);
	while (1) {
		unsigned char ch = conv->uni2chr[hash];;
		if (__likely(!ch)) {
			conv->uni2chr[hash] = c;
			return 0;
		}
		if (__unlikely(ch == c)) KERNEL$SUICIDE("insert_hash: INSERTING %d TWICE", ch);
		if (__unlikely(conv->chr2uni[ch] == u)) {
			/*
				two characters map to the same unicode
				this happens twice in cp850 and once in cp852
			errno = EFTYPE;
			return -1;
			*/
			return 0;
		}
		hash = (hash + 1) & (HASH_SIZE - 1);
	}
}

static int INIT_8B(CHRCACHE *chr, unsigned long h)
{
	CHARSET_8B *conv = (CHARSET_8B *)chr;
	int i, r;
	errno = EFTYPE;
	r = read(h, &conv->chr2uni, sizeof conv->chr2uni);
	if (__unlikely(r != sizeof conv->chr2uni / 2) && __unlikely(r != sizeof conv->chr2uni)) return -1;
	if (__unlikely(read(h, (char *)&KERNEL$LIST_END, 1) != 0)) return -1;
	if (__likely(r == sizeof conv->chr2uni / 2)) {
		for (i = 255; i >= 0; i--) {
			__u32 val = (__u16)(__16LE2CPU(((__u16 *)conv->chr2uni)[i]) + 1);
			conv->chr2uni[i] = val - 1;
			__barrier();	/* C does not allow aliasing of 16 and 32-bit types */
		}
	}
#ifdef __BIG_ENDIAN
	else {
		for (i = 0; i < 256; i++) conv->chr2uni[i] = __32LE2CPU(conv->chr2uni[i]);
	}
#endif
	memset(&conv->uni2chr, 0, sizeof conv->uni2chr);
	for (i = 32; i < 256; i++) if (__unlikely(insert_hash(conv, i))) return -1;
	for (i = 1; i < 32; i++) if (__unlikely(insert_hash(conv, i))) return -1;
	if (__unlikely(insert_hash(conv, 0))) return -1;	/* this must be last */
	return 0;
}

CHARSET_8B *CHARSET$OPEN_8B(__const__ char *name)
{
	return (CHARSET_8B *)CHRCACHE_OPEN(name, TYPE_8B, "CH8", sizeof(CHARSET_8B), INIT_8B);
}

void CHARSET$CLOSE_8B(CHARSET_8B *conv, int keep)
{
	CHRCACHE_CLOSE((CHRCACHE *)conv, keep, TYPE_8B);
}

__s32 CHARSET$8B2UNI(CHARSET_8B *conv, unsigned char chr)
{
	return conv->chr2uni[chr];
}

int CHARSET$UNI28B(CHARSET_8B *conv, __s32 uni)
{
	unsigned hash;
	if (__unlikely(uni == -1)) return -1;
	hash = UNI_HASH(uni);
	while (1) {
		unsigned char ch = conv->uni2chr[hash];
		if (__likely(conv->chr2uni[ch] == uni)) return ch;
		if (__likely(!ch)) return -1;
		hash = (hash + 1) & (HASH_SIZE - 1);
	}
}
