#include <STRING.H>
#include <STDLIB.H>
#include <UNISTD.H>
#include <SYS/TYPES.H>
#include <ERRNO.H>
#include <SPAD/LIBC.H>

#include "CHRCACHE.H"

#include <SPAD/CHARSET.H>

typedef struct __chr_alias CHR_ALIAS;

static CHR_ALIAS *CHARSET_OPEN_ALIAS(__const__ char *name);
static void CHARSET_CLOSE_ALIAS(CHR_ALIAS *ali, int keep);
static __const__ char *CHARSET_ALIAS_NAME(CHR_ALIAS *ali);

struct __chr_alias {
	CHRCACHE_HEAD;
	char *alias;
};

static void DESTROY_ALIAS(CHRCACHE *chr);
static int READ_LINE(CHRCACHE *chr, char *p, size_t l);

static int INIT_ALIAS(CHRCACHE *chr, unsigned long h)
{
	CHR_ALIAS *ali = (CHR_ALIAS *)chr;
	ali->alias = NULL;
	ali->destructor = DESTROY_ALIAS;
	if (__unlikely(READ_BY_LINES((CHRCACHE *)ali, h, READ_LINE))) return -1;
	return 0;
}

static int READ_LINE(CHRCACHE *chr, char *p, size_t l)
{
	CHR_ALIAS *ali = (CHR_ALIAS *)chr;
	if (__unlikely(!l) || __unlikely(p[0] == ';')) return 0;
	if (__unlikely(ali->alias != NULL)) {
		errno = EFTYPE;
		return -1;
	}
	if (__unlikely(!(ali->alias = __sync_malloc(l + 1)))) return -1;
	memcpy(ali->alias, p, l);
	ali->alias[l] = 0;
	return 0;
}

static void DESTROY_ALIAS(CHRCACHE *chr)
{
	CHR_ALIAS *ali = (CHR_ALIAS *)chr;
	free(ali->alias);
}

static CHR_ALIAS *CHARSET_OPEN_ALIAS(__const__ char *name)
{
	return (CHR_ALIAS *)CHRCACHE_OPEN(name, TYPE_ALIAS, "ALI", sizeof(CHR_ALIAS), INIT_ALIAS);
}

static void CHARSET_CLOSE_ALIAS(CHR_ALIAS *ali, int keep)
{
	CHRCACHE_CLOSE((CHRCACHE *)ali, keep, TYPE_ALIAS);
}

static __const__ char *CHARSET_ALIAS_NAME(CHR_ALIAS *ali)
{
	return ali->alias;
}

char *CHARSET$RESOLVE_ALIAS(__const__ char *name)
{
	char *ret;
	__const__ char *a;
	CHR_ALIAS *al = CHARSET_OPEN_ALIAS(name);
	if (!al) {
		if (errno != ENOENT) return NULL;
		a = name;
	} else {
		a = CHARSET_ALIAS_NAME(al);
	}
	ret = __sync_malloc(strlen(a) + 1);
	if (__likely(ret != NULL)) strcpy(ret, a), __upcase(ret);
	if (al) CHARSET_CLOSE_ALIAS(al, 1);
	return ret;
}

