#include <STRING.H>
#include <STDLIB.H>
#include <UNISTD.H>
#include <SYS/TYPES.H>
#include <ERRNO.H>
#include <SPAD/LIBC.H>
#include <VALUES.H>

#include "CHRCACHE.H"

#include <SPAD/CHARSET.H>

#define HASH_SIZE	1024
#define HASH_UNI(u)	((u) & (HASH_SIZE - 1))

struct __fallback {
	CHRCACHE_HEAD;
	XLIST_HEAD *hash;
};

typedef struct {
	LIST_ENTRY list;
	__s32 uni;
	unsigned n_fallback;
	__s32 *fallback[1];
} FALLBACK_ENTRY;

static void DESTROY_FALLBACK(CHRCACHE *chr);
static int READ_LINE(CHRCACHE *chr, char *p, size_t l);
static __s32 *GET_STR(char **ptr);

#define FIND_FALLBACK_ENTRY(found)					\
{									\
	XLIST_FOR_EACH(fe, &fb->hash[HASH_UNI(uni)], FALLBACK_ENTRY, list)\
		if (__likely(fe->uni == uni)) { found; }		\
}

static int INIT_FALLBACK(CHRCACHE *chr, unsigned long h)
{
	FALLBACK *fb = (FALLBACK *)chr;
	int i;
	if (__unlikely(!(fb->hash = __sync_malloc(HASH_SIZE * sizeof(XLIST_HEAD))))) return -1;
	for (i = 0; i < HASH_SIZE; i++) INIT_XLIST(&fb->hash[i]);
	fb->destructor = DESTROY_FALLBACK;
	if (__unlikely(READ_BY_LINES((CHRCACHE *)fb, h, READ_LINE))) return -1;
	return 0;
}

static int READ_LINE(CHRCACHE *chr, char *p, size_t l)
{
	FALLBACK *fb = (FALLBACK *)chr;
	FALLBACK_ENTRY *fe, *new_fe;
	__s32 *s1, uni;
	char *e;
	if (__unlikely(!l) || __unlikely(p[0] == ';')) return 0;
	e = p + l;
	if (__unlikely(!(s1 = GET_STR(&p)))) return -1;
	if (__unlikely(s1[0] == -1) || __unlikely(s1[1] != -1)) {
		__slow_free(s1);
		return -1;
	}
	uni = s1[0];
	free(s1);
	FIND_FALLBACK_ENTRY(goto found;);
	if (__unlikely(!(fe = __sync_malloc(sizeof(FALLBACK_ENTRY))))) return -1;
	fe->uni = uni;
	fe->n_fallback = 0;
	ADD_TO_XLIST(&fb->hash[HASH_UNI(fe->uni)], &fe->list);
	found:
	do {
		int j;
		if (__unlikely(!(s1 = GET_STR(&p)))) {
			free_ret_err:
			DEL_FROM_LIST(&fe->list);
			free_ret_err_nohash:
			for (j = 0; j < fe->n_fallback; j++) __slow_free(fe->fallback[j]);
			__slow_free(fe);
			return -1;
		}
		for (j = 0; j < fe->n_fallback; j++) {
			__s32 *c1 = s1, *c2 = fe->fallback[j];
			do if (__likely(*c1 != *c2)) goto no_match;
			while (c1++, *c2++ != -1);
			free(s1);
			goto match;
			no_match:;
		}
		DEL_FROM_LIST(&fe->list);
		if (__unlikely(!(new_fe = __sync_realloc(fe, sizeof(FALLBACK_ENTRY) + fe->n_fallback * sizeof(__s32 *))))) {
			__slow_free(s1);
			goto free_ret_err_nohash;
		}
		fe = new_fe;
		ADD_TO_XLIST(&fb->hash[HASH_UNI(fe->uni)], &fe->list);
		fe->fallback[fe->n_fallback++] = s1;
		if (__unlikely(fe->n_fallback > MAXINT)) goto free_ret_err;
		match:;
	} while (p != e);
	return 0;
}

static __s32 *GET_STR(char **ptr)
{
	char *e;
	unsigned long u;
	unsigned n = 0;
	__s32 *string = NULL;
	while (__unlikely(**ptr == ' ') || __unlikely(**ptr == '\t')) (*ptr)++;
	if (**ptr == '"') {
		e = *ptr + 1;
		while (1) {
			if (__unlikely(!(string = __sync_reallocf(string, (n + 1) * sizeof(__s32))))) return NULL;
			if (__unlikely(*e == '\n') || __unlikely(*e == '\r')) goto free_ret_eftype;
			if (*e == '"') {
				e++;
				goto ret;
			}
			string[n++] = *e++;
		}
	}
	next_char:
	if (__unlikely(!(string = __sync_reallocf(string, (n + 2) * sizeof(__s32))))) return NULL;
	e = *ptr;
	while (*e != ' ' && *e != '\t' && *e != '\n' && *e != '\r' && *e != ',') e++;
	if (__unlikely(__get_number(*ptr, e, 0, &u))) {
		free_ret_eftype:
		__slow_free(string);
		errno = EFTYPE;
		return NULL;
	}
	if (__unlikely(u >= 0x80000000UL)) goto free_ret_eftype;
	string[n++] = u;
	if (*e == ',') {
		*ptr = e + 1;
		goto next_char;
	}
	ret:
	*ptr = e;
	string[n] = -1;
	while (__unlikely(**ptr == ' ') || __unlikely(**ptr == '\t')) (*ptr)++;
	return string;
}

static void DESTROY_FALLBACK(CHRCACHE *chr)
{
	FALLBACK *fb = (FALLBACK *)chr;
	int i;
	for (i = 0; i < HASH_SIZE; i++) while (__unlikely(!XLIST_EMPTY(&fb->hash[i]))) {
		int j;
		FALLBACK_ENTRY *fe = LIST_STRUCT(fb->hash[i].next, FALLBACK_ENTRY, list);
		for (j = 0; j < fe->n_fallback; j++) free(fe->fallback[j]);
		DEL_FROM_LIST(&fe->list);
		free(fe);
	}
	free(fb->hash);
}

FALLBACK *CHARSET$OPEN_FALLBACK(__const__ char *filename)
{
	return (FALLBACK *)CHRCACHE_OPEN(__likely(!filename) ? "FALLBACK.UNI" : filename, TYPE_FALLBACK, NULL, sizeof(FALLBACK), INIT_FALLBACK);
}

void CHARSET$CLOSE_FALLBACK(FALLBACK *fb, int keep)
{
	if (__unlikely(!fb)) return;
	CHRCACHE_CLOSE((CHRCACHE *)fb, keep, TYPE_FALLBACK);
}

__s32 *CHARSET$GET_FALLBACK(FALLBACK *fb, __s32 uni, unsigned order)
{
	FALLBACK_ENTRY *fe;
	if (__unlikely(!fb)) return NULL;
	FIND_FALLBACK_ENTRY({
		if (__unlikely(order >= fe->n_fallback)) return NULL;
		return fe->fallback[order];
	});
	return NULL;
}

