#!awk -f
BEGIN {
	for (i = 0; i < 256; i++) array[i] = 0xffffffff;
}
/^[0-9]/ {
	if (substr($2,1,1) < 0 || substr($2,1,1) > 9) next;
	if (array[strtonum($1)] != 0xffffffff) {
		print "DUPLICATE CHATACTER "$1 >"/dev/stderr"
		exiting = 1
		exit
	}
	if (0 && uniarray[strtonum($2)]) {
		print "DUPLICATE UNICODE CHATACTER "$2 >"/dev/stderr"
		exiting = 1
		exit
	}
	uniarray[strtonum($2)] = 1;
	array[strtonum($1)] = strtonum($2);
}
END {
	if (exiting) exit exiting
	bits = 16;
	for (i = 0; i < 256; i++) if (array[i] != 0xffffffff && array[i] >= 0xffff) bits = 32;
	if (bits == 32) {
		for (i = 0; i < 256; i++) printf "%c%c%c%c", array[i], array[i] / 0x100, array[i] / 0x10000, array[i] / 0x1000000;
	} else {
		for (i = 0; i < 256; i++) printf "%c%c", array[i], array[i] / 0x100;
	}
}
