#include <SPAD/DL.H>
#include <STDLIB.H>
#include <LIB/KERNEL/UASM.H>
#include <LIB/KERNEL/UTHREAD.H>
#include <LIB/KERNEL/UIO.H>
#include <LIB/KERNEL/USIGNAL.H>
#include <UNISTD.H>
#include <KERNEL/TIMER.H>
#include <KERNEL/ENV.H>

void KERNEL$BOOT(char **env);

extern char *__progname;
extern void (*__exit_func)(int);

void KERNEL$BOOT(char **env)
{
	START_ARG start;
	long ret;
	KERNEL$PHYSICAL.op = &VIRTUAL_OPERATIONS;
	__DL_USER_INIT(1);
	ENV_INIT();
	UIO_RST_INIT();	/* must be before timer */
	KTIMER_INIT();
	UIO_INIT();
	THREAD_INIT();
	UIO_DUPSTD();
	SIGNAL_INIT();
	environ = env;
	start.env = env;
	while (*env++) ;
	start.argv = env;
	__progname = start.argv[0];

	ret = __DL_USER_LOAD_EXE(start.argv[0], &start, &udata.dl_exe);
	if (__likely(__exit_func != NULL)) __exit_func(ret);
	KERNEL$DL_CALL_DTORS();
	_exit(ret);
}
