#include <KERNEL/KSPAWN.H>
#include <KERNEL/SYSCALL.H>
#include <KERNEL/DEV.H>
#include <VALUES.H>

DECL_IOCALL(KERNEL_KSPAWN, SPL_TOP, KSPAWNRQ)
{
	long r;
	IO_ENABLE_KERNEL_CANCEL(RQ, RETURN);
	/*__debug_printf("do spawn (%d) (%p)\n", SYSCALL1(SYS_DEPTH), RQ);*/
	r = SYSCALL2(SYS_SPAWN, (unsigned long)RQ);
	/*__debug_printf("spawn (%d) ... %d\n", SYSCALL1(SYS_DEPTH), r);*/
	if (__unlikely(r < 0)) {
		/*__debug_printf("spawn error: %s\n", strerror(-r));*/
		RQ->status = r;
		RETURN_AST(RQ);
	}
	RETURN;
}

int KERNEL_FORK(KSPAWNRQ *RQ)
{
	long r;
	RQ->status = RQS_PROCESSING;
	IO_ENABLE_KERNEL_CANCEL(RQ, return 0);
	/*__debug_printf("do fork (%d) (%p)\n", SYSCALL1(SYS_DEPTH), RQ);*/
	r = SYSCALL2(SYS_FORK, (unsigned long)RQ);
	if (__unlikely(r < 0)) return r;
	/*__debug_printf("fork (%d) ... %d\n", SYSCALL1(SYS_DEPTH), r);*/
	return r != SYSCALL1(SYS_DEPTH);
}

void DO_BREAK(PROC *r, KSPAWNRQ *rq, unsigned recursive)
{
	SYSCALL2(SYS_BREAK | recursive, (unsigned long)rq);
}

void CLEAR_SUBPROC_LN_CACHE(void)
{
	SYSCALL1(SYS_FLUSH_LN_CACHE);
}
