#include <ARCH/IO.H>
#include <ARCH/IRQ.H>
#include <SPAD/CONSOLE.H>
#include <KERNEL/DEV.H>
#include <SPAD/PROC.H>
#include <SPAD/WQ.H>
#include <KERNEL/SYSLOG.H>
#include <ARCH/CPU.H>
#include <SPAD/SCHED.H>

void KERNEL$DI(void) { }

void KERNEL$EI(void) { }

int KERNEL$SAVE_INT_STATE(void) { return 0; }

void KERNEL$RESTORE_INT_STATE(int state) { }

void KERNEL$DI_HW(void) { }

void KERNEL$EI_HW(void) { }

long KERNEL$FPU_ENABLED = 1;

void KERNEL$ENABLE_FPU(void) { }

char *KERNEL$REQUEST_IRQ(int irq, int flags, IRQ_STUB *call, void *data, IRQ_CONTROL *ctrl, __const__ char *desc) { return "CAN'T REQUEST IRQ IN USERSPACE"; }

void KERNEL$RELEASE_IRQ(IRQ_CONTROL *ctrl, int flags) { KERNEL$SUICIDE("KERNEL$RELEASE_IRQ: NOT SUPPORTED IN USERSPACE"); }

int KERNEL$REGISTER_IO_RANGE(IO_RANGE *io)
{
	return -EUSER;
}

void KERNEL$UNREGISTER_IO_RANGE(IO_RANGE *io)
{
	KERNEL$SUICIDE("KERNEL$UNREGISTER_IO_RANGE: NOT SUPPORTED IN USERSPACE");
}

int KERNEL$RESERVE_BOUNCE(char *device, unsigned requests, unsigned long size) { return 0; }
void KERNEL$UNRESERVE_BOUNCE(char *device, unsigned requests, unsigned long size) { return; }

/* these will be implemented when drivers-in-userspace will be allowed */

HANDLE *GET_HANDLE(PROC *proc, int handle_num, int open_flags, IORQ *rq)
{
	return __ERR_PTR(-EUSER);
}

void KERNEL$PAGEIN(IORQ *rq, VDESC *vd, int wr)
{
	KERNEL$SUICIDE("KERNEL$PAGEIN CALLED");
}

DECL_IOCALL(KERNEL$DCTL, SPL_DEV, DCTLRQ)
{
	_snprintf(RQ->error, __MAX_STR_LEN, "%s AVAILABLE ONLY IN KERNEL MODE", !RQ->unload ? "DCTL" : "UNLOAD");
	RQ->status = -EUSER;
	RETURN_AST(RQ);
}

int KERNEL$DCALL(__const__ char *name, __const__ char *devtype, int cmd, void *param)
{
	return -EUSER;
}

DECL_IOCALL(KERNEL$REGISTER_DEVICE, SPL_DEV, DEVICE_REQUEST)
{
	RQ->status = -EUSER;
	RETURN_AST(RQ);
}

int KERNEL$UNREGISTER_DEVICE(void *lnte_, int flags)
{
	return -EUSER;
}

int KERNEL$DEVICE_UNLOAD(void *lnte_, char **argv)
{
	return -EUSER;
}

FFILE *KERNEL$MAP_FILE_STRUCT(HANDLE *h, IORQ *rq, vspace_unmap_t **unmap)
{
	*unmap = KERNEL$NULL_VSPACE_UNMAP;
	return h->file;
}

FBLOB *KERNEL$FIND_FILE_BLOB(HANDLE *h, IORQ *rq, __u32 type, size_t *size)
{
	return (void *)1;	/* unimplemented */
}

HANDLE *KERNEL$PROC_VSPACE(PROC *p)
{
	return &KERNEL$VIRTUAL;
}

unsigned KERNEL$PROC_DEPTH(PROC *p)
{
	return 1;
}

char *KERNEL$PROC_PATH(PROC *proc, unsigned *val)
{
	return NULL;
}

PROC *KERNEL$PROC_ACCOUNT = &KERNEL$PROC_KERNEL;

void KERNEL$SWITCH_PROC_ACCOUNT(PROC *p)
{
}

void KERNEL$SWITCH_PROC_ACCOUNT_TICKS(PROC *p, sched_unsigned t)
{
}

unsigned char KERNEL$LOCKUP_LEVEL = 0;
WQ_DECL(KERNEL$LOCKUP_EVENTS, "KERNEL$LOCKUP_EVENTS");

int KERNEL$LOCKUP_WAIT_ENTRY(IORQ *rq, HANDLE *h)
{
	CALL_IORQ_LSTAT_EXPR(rq, (IO_STUB *)rq->tmp1);
	return 1;
}

int KERNEL$LOCKUP_WAIT_LOOP(IORQ *rq, HANDLE *h)
{
	CALL_IORQ_LSTAT_EXPR(rq, (IO_STUB *)rq->tmp1);
	return 1;
}

void KERNEL$DETACH_HANDLE(HANDLE *h)
{
}

int KERNEL$CACHE_REGISTER_VM_TYPE(int *entity, __const__ VMENTITY_T *t)
{
	return 0;
}

void KERNEL$CACHE_UNREGISTER_VM_TYPE(int entity)
{
}

void KERNEL$CACHE_INSERT_VM_ENTITY(VMENTITY *e, PROC *wire, int flags)
{
}

void KERNEL$CACHE_TOUCH_VM_ENTITY(VMENTITY *e, PROC *wire)
{
}

void KERNEL$CACHE_REMOVE_VM_ENTITY(VMENTITY *e)
{
}

void KERNEL$CACHE_TRANSFER_QUEUE_STATE(VMENTITY *to, VMENTITY *from)
{
}

WQ *KERNEL$MAY_ALLOC(PROC *p, unsigned size)
{
	return NULL;
}

void KERNEL$NOTIFY_FREE(PROC *p, unsigned size)
{
}

void KERNEL$NOTIFY_ALLOC(PROC *p, unsigned size)
{
}

WQ *KERNEL$MAY_DIRTY(PROC *p, unsigned mode)
{
	return NULL;
}

void KERNEL$MEMSTAT_DUMP(void)
{
}

WQ *KERNEL$ACQUIRE_IO_TAG(PROC_TAG *tag, PROC *proc)
{
	tag->proc = proc;
	return NULL;
}

void KERNEL$RELEASE_IO_TAG(PROC_TAG *tag)
{
}

void KERNEL$ACQUIRE_PREFETCH_TAG(PREFETCH_TAG *tag, PROC *proc)
{
	VOID_LIST_ENTRY(&tag->list);
}

void KERNEL$ACQUIRE_WRITEBACK_TAG(PROC *proc)
{
}

void KERNEL$RELEASE_WRITEBACK_TAG(PROC *proc)
{
}

int KERNEL$ALLOC_IOSCHED(void)
{
	return 0;
}

void KERNEL$FREE_IOSCHED(int i)
{
	if (__unlikely(i)) KERNEL$SUICIDE("KERNEL$FREE_IOSCHED: INVALID IOSCHED %d", i);
}

void KERNEL$ACCOUNT_IOSCHED(PROC *p, int sched, sched_unsigned start, sched_unsigned now)
{
}

sched_signed KERNEL$COMPARE_IOSCHED(PROC *p1, int s1, PROC *p2, int s2)
{
	return 0;
}

char log_buffer[1];
volatile unsigned log_buffer_start, log_buffer_end;
int log_buffer_overflow;
WQ_DECL(log_wait, "KERNEL$LOG_WAIT");

