/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <phk@login.dknet.dk> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.   Poul-Henning Kamp
 * ----------------------------------------------------------------------------
 *
 * $FreeBSD: src/lib/libcrypt/crypt-md5.c,v 1.5.2.1 2001/05/24 12:20:02 markm Exp $
 *
 */

#if defined(LIBC_SCCS) && !defined(lint)
static const char rcsid[] = \
"$FreeBSD: src/lib/libcrypt/crypt-md5.c,v 1.5.2.1 2001/05/24 12:20:02 markm Exp $";
#endif /* LIBC_SCCS and not lint */

#include <UNISTD.H>
#include <STDIO.H>
#include <STRING.H>
#include <MD5.H>
#include <ERR.H>
#include <DLFCN.H>
#include "CRYPT.H"

/*
 * UNIX password
 */

char *
crypt_md5(pw, salt)
	const char *pw;
	const char *salt;
{
	static char	*magic = "$1$";	/*
					 * This string is magic for
					 * this algorithm.  Having
					 * it this way, we can get
					 * get better later on
					 */
	static char     passwd[120], *p;
	static const char *sp,*ep;
	unsigned char	final[MD5_SIZE];
	int sl,pl,i;
	MD5_CTX	ctx,ctx1;
	unsigned long l;

	void *libc;
	void   (*xMD5Init)(MD5_CTX *context);
	void   (*xMD5Update)(MD5_CTX *context, unsigned char const *buf, unsigned len);
	void   (*xMD5Final)(unsigned char digest[MD5_HASHBYTES], MD5_CTX *context);

	if (__unlikely(!(libc = dlopen("MD.DLL", RTLD_NOW))))
		return NULL;
	
	if (__unlikely(!(xMD5Init = dlsym(libc, "MD5Init")))) {
		dlclose(libc);
		return NULL;
	}
	if (__unlikely(!(xMD5Update = dlsym(libc, "MD5Update")))) {
		dlclose(libc);
		return NULL;
	}
	if (__unlikely(!(xMD5Final = dlsym(libc, "MD5Final")))) {
		dlclose(libc);
		return NULL;
	}

	/* Refine the Salt first */
	sp = salt;

	/* If it starts with the magic string, then skip that */
	if(!strncmp(sp,magic,strlen(magic)))
		sp += strlen(magic);

	/* It stops at the first '$', max 8 chars */
	for(ep=sp;*ep && *ep != '$' && ep < (sp+8);ep++)
		continue;

	/* get the length of the true salt */
	sl = ep - sp;

	xMD5Init(&ctx);

	/* The password first, since that is what is most unknown */
	xMD5Update(&ctx,pw,strlen(pw));

	/* Then our magic string */
	xMD5Update(&ctx,magic,strlen(magic));

	/* Then the raw salt */
	xMD5Update(&ctx,sp,sl);

	/* Then just as many characters of the MD5(pw,salt,pw) */
	xMD5Init(&ctx1);
	xMD5Update(&ctx1,pw,strlen(pw));
	xMD5Update(&ctx1,sp,sl);
	xMD5Update(&ctx1,pw,strlen(pw));
	xMD5Final(final,&ctx1);
	for(pl = strlen(pw); pl > 0; pl -= MD5_SIZE)
		xMD5Update(&ctx,final,pl>MD5_SIZE ? MD5_SIZE : pl);

	/* Don't leave anything around in vm they could use. */
	memset(final,0,sizeof final);

	/* Then something really weird... */
	for (i = strlen(pw); i ; i >>= 1)
		if(i&1)
		    xMD5Update(&ctx, final, 1);
		else
		    xMD5Update(&ctx, pw, 1);

	/* Now make the output string */
	strcpy(passwd,magic);
	strncat(passwd,sp,sl);
	strcat(passwd,"$");

	xMD5Final(final,&ctx);

	/*
	 * and now, just to make sure things don't run too fast
	 * On a 60 Mhz Pentium this takes 34 msec, so you would
	 * need 30 seconds to build a 1000 entry dictionary...
	 */
	for(i=0;i<1000;i++) {
		xMD5Init(&ctx1);
		if(i & 1)
			xMD5Update(&ctx1,pw,strlen(pw));
		else
			xMD5Update(&ctx1,final,MD5_SIZE);

		if(i % 3)
			xMD5Update(&ctx1,sp,sl);

		if(i % 7)
			xMD5Update(&ctx1,pw,strlen(pw));

		if(i & 1)
			xMD5Update(&ctx1,final,MD5_SIZE);
		else
			xMD5Update(&ctx1,pw,strlen(pw));
		xMD5Final(final,&ctx1);
	}

	p = passwd + strlen(passwd);

	l = (final[ 0]<<16) | (final[ 6]<<8) | final[12];
	_crypt_to64(p,l,4); p += 4;
	l = (final[ 1]<<16) | (final[ 7]<<8) | final[13];
	_crypt_to64(p,l,4); p += 4;
	l = (final[ 2]<<16) | (final[ 8]<<8) | final[14];
	_crypt_to64(p,l,4); p += 4;
	l = (final[ 3]<<16) | (final[ 9]<<8) | final[15];
	_crypt_to64(p,l,4); p += 4;
	l = (final[ 4]<<16) | (final[10]<<8) | final[ 5];
	_crypt_to64(p,l,4); p += 4;
	l =                    final[11]                ;
	_crypt_to64(p,l,2); p += 2;
	*p = '\0';

	/* Don't leave anything around in vm they could use. */
	memset(final,0,sizeof final);

	dlclose(libc);

	return passwd;
}

