#include <SPAD/DEV.H>
#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <UNISTD.H>
#include <VALUES.H>
#include <PATHS.H>

#include <STDLIB.H>

static char *__const__ inithandles[3] = { "STDIN", "STDOUT", "STDERR" };

int daemon(int nochdir, int noclose)
{
	if (__unlikely(KERNEL$KERNEL)) return 0;
	if (__likely(!nochdir)) chdir("HOME:/"), chdir("/");
	if (__likely(!noclose)) {
		int i;
		for (i = 0; i < 2; i++) {
			LOGICAL_REQUEST lrq;
			lrq.name = inithandles[i];
			lrq.alias = _PATH_DEVNULL;
			lrq.flags = LNTE_PUBLIC | LNTE_FILE_SHARE;
			lrq.cwd = KERNEL$CWD();
			lrq.chh_option = NULL;
			lrq.blob = NULL;
			SYNC_IO(&lrq, KERNEL$CREATE_LOGICAL);
		}
	}
	_background(NULL);
	return 0;
}
