#include <STRING.H>
#include <SPAD/LIST.H>
#include <SPAD/LIBC.H>

#include <FNMATCH.H>

/* BSD libc contains a lame recursive algorithm for this.
   It couldn't be used in kernel. So I reimplemented it */

#define FNM_FIRST	0x80000000

static int find_first_match(__const__ char **ps, __const__ char **pp, __const__ char **start_string_match, int flags, __const__ char *beginning);
static int match_list(__const__ char *s, __const__ char **pp, int flags, __const__ char *beginning);

#define TEST_WILD_SKIP(c)						\
do {									\
	if (flags & FNM_PATHNAME && (__unlikely((c)[0] == '/') || __unlikely((c)[0] == ':')))								\
		return FNM_NOMATCH;					\
	if (flags & FNM_PERIOD && __unlikely((c)[0] == '.') && (__unlikely((c) == beginning) || __unlikely((c)[-1] == '/') || __unlikely((c)[-1] == ':')))\
		return FNM_NOMATCH;					\
} while (0)

#define END_OF_STRING(c)						\
	(__likely(!(c)) || (__unlikely(flags & FNM_LEADING_DIR) && (c) == '/'))

#define END_OF_PATTERN(c)						\
	(!(c) || (__likely(flags & _FNM_GLOB_INTERNAL) && ((c) == '/' || (c) == ':')))

int fnmatch(__const__ char *pattern, __const__ char *string, int flags)
{
	int r;
	__const__ char *prev_pattern, *prev_string, *start_string_match, *beginning = string;
	if ((r = find_first_match(&string, &pattern, (__const__ char **)(void *)&KERNEL$LIST_END, flags | FNM_FIRST, beginning))) return r;
	if (END_OF_PATTERN(*pattern)) return !END_OF_STRING(*string);
	while (1) {
		pattern++;
		prev_pattern = pattern;
		match_end:
		prev_string = string;
		if ((r = find_first_match(&string, &pattern, &start_string_match, flags, beginning))) return r;
		if (__unlikely(flags & (FNM_PATHNAME | FNM_PERIOD))) {
			__const__ char *q;
			for (q = prev_string; q < string; q++) TEST_WILD_SKIP(q);
		}
		if (__likely(END_OF_PATTERN(*pattern))) {
			if (__likely(END_OF_STRING(*string))) return 0;
			if (__unlikely(flags & (FNM_PATHNAME | FNM_PERIOD))) {
				TEST_WILD_SKIP(prev_string);
			}
			pattern = prev_pattern;
			string = start_string_match + 1;
			goto match_end;
		}
	}
}

static int find_first_match(__const__ char **ps, __const__ char **pp, __const__ char **start_string_match, int flags, __const__ char *beginning)
{
	__const__ char *s;
	__const__ char *p;
	try_again:
	s = *start_string_match = *ps;
	p = *pp;
	while (!END_OF_PATTERN(*p) && *p != '*') {
		if (__unlikely(*p == '\\') && __likely(!(flags & FNM_NOESCAPE))) {
			p++;
			if (__unlikely(END_OF_PATTERN(*p))) break;
			goto test_eq;
		}
		if (__unlikely(*p == '?')) {
			if (__unlikely(!*s)) return FNM_NOMATCH;
			TEST_WILD_SKIP(s);
			goto increment_both;
		}
		if (__unlikely(*p == '[')) {
			__const__ char *np = p;
			int r = match_list(s, &np, flags, beginning);
			p = np;
			if (__unlikely(r < 0)) goto test_eq;
			if (__likely(!r)) goto increment_both;
			goto no_match;
		}
		test_eq:
		if (__likely(!(flags & FNM_CASEFOLD))) {
			if (*s == *p) {
				increment_both:
				p++;
				s++;
				continue;
			}
		} else {
			if (__upcasechr(*s) == __upcasechr(*p)) goto increment_both;
		}
		no_match:
		if (*s) {
			if (__unlikely(!**ps)) KERNEL$SUICIDE("find_first_match: ZERO STRING TERMINATOR SKIPPED SOMEHOW");
			if (flags & FNM_FIRST) return FNM_NOMATCH;
			(*ps)++;
			goto try_again;
		}
		return FNM_NOMATCH;
	}
	*ps = s;
	*pp = p;
	return 0;
}

static int match_list(__const__ char *s, __const__ char **pp, int flags, __const__ char *beginning)
{
	__const__ char *p = *pp;
	char matched = 0;
	char want_matched = 1;
	unsigned char c = *s;
	if (__unlikely(p[1] == '!') || __unlikely(p[1] == '^')) {
		p++;
		want_matched = 0;
	}
	if (__unlikely(flags & FNM_CASEFOLD)) c = __locasechr(c);
	while (*++p != ']') {
		if (__unlikely(END_OF_PATTERN(*p))) return -1;
		if (__unlikely(*p == '\\') && __likely(!(flags & FNM_NOESCAPE))) {
			p++;
			if (__unlikely(END_OF_PATTERN(*p))) return -1;
		}
		if (__unlikely(p[1] == '-')) {
			unsigned char c1 = p[0];
			unsigned char c2 = p[2];
			if (__unlikely(!c2) || __unlikely(c2 == ']')) goto no_range;
			if (__unlikely(c2 == '\\') && __likely(!(flags & FNM_NOESCAPE))) {
				c2 = p++[3];
				if (__unlikely(!c2)) goto no_range;
			}
			if (__unlikely(flags & FNM_CASEFOLD)) {
				c1 = __locasechr(c1);
				c2 = __locasechr(c2);
			}
			matched |= c1 <= c && c <= c2;
			p += 2;
		} else {
			no_range:
			if (__likely(!(flags & FNM_CASEFOLD))) matched |= c == *p;
			else matched |= c == __locasechr(*p);
		}
	}
	*pp = p;
	if (__unlikely(!*s)) return FNM_NOMATCH;
	TEST_WILD_SKIP(s);
	return matched != want_matched;
}
