#include <SYS/UTSNAME.H>
#include <SYS/TYPES.H>
#include <STRING.H>
#include <ERRNO.H>

#include <UNISTD.H>

int gethostname(char *name, size_t len)
{
	struct utsname buf;
	if (__unlikely(uname(&buf))) return -1;
	if (__unlikely(strlen(buf.nodename) + 1 > len)) {
		errno = ERANGE;
		return -1;
	}
	strcpy(name, buf.nodename);
	return 0;
}
