#include <STRING.H>
#include <UNISTD.H>
#include <STDLIB.H>
#include <PATHS.H>

#include <PWD.H>

static struct passwd p = { NULL, "", 0, 0, 0, "", "", "HOME:/", NULL, 0, 0 };
static struct passwd r = { "root", "", 0, 0, 0, "", "", "MFS:/", _PATH_BSHELL, 0, 0 };

static void fillpasswd(void)
{
	char *s;
	if (__unlikely(!(s = getenv("USER")))) s = "USER";
	p.pw_name = s;
	p.pw_uid = getuid();
	p.pw_gid = getgid();
	if (__likely(!(s = getenv("SHELL")))) s = _PATH_BSHELL;
	p.pw_shell = s;
}

struct passwd *getpwnam(__const__ char *name)
{
	fillpasswd();
	if (!strcasecmp(name, p.pw_name)) return &p;
	if (!strcasecmp(name, r.pw_name)) return &r;
	return NULL;
}

int getpwnam_r(const char *name, struct passwd *pwd, char *buffer, size_t bufsize, struct passwd **result)
{
	*result = getpwnam(name);
	return 0;
}

struct passwd *getpwuid(uid_t u)
{
	if (__likely(u == getuid())) {
		fillpasswd();
		return &p;
	}
	if (__likely(!u)) return &r;
	return NULL;
}

int getpwuid_r(uid_t uid, struct passwd *pwd, char *buffer, size_t bufsize, struct passwd **result)
{
	*result = getpwuid(uid);
	return 0;
}

static int pwentry = 0;

struct passwd *getpwent(void)
{
	if (!pwentry) {
		pwentry++;
		fillpasswd();
		return &p;
	}
	if (pwentry == 1) {
		pwentry++;
		return &r;
	}
	return NULL;
}

int setpassent(int stayopen)
{
	pwentry = 0;
	return 1;
}

void setpwent(void)
{
	pwentry = 0;
}

void endpwent(void)
{
	pwentry = 0;
}
