#include <SPAD/LIST.H>
#include <DIRENT.H>
#include <SPAD/DEV.H>
#include <SPAD/SYNC.H>
#include <SYS/STAT.H>
#include <STDLIB.H>
#include <VALUES.H>
#include <ERRNO.H>
#include <STRING.H>
#include <FNMATCH.H>

#include <GLOB.H>

/* Another recursive algorith in BSD libc --- it is even worse than fnmatch,
   because it does alloca(MAXPATHLEN) in recursive functions.
   They probably think that their stack is l33t.
   Rewritten to be usable in kernel */

typedef struct {
	LIST_ENTRY list;
	__const__ char *pattern_ptr;
	char path[1];
} GLOBRQ;

static char *deescape_cpy(char *dest, __const__ char *src, size_t len, unsigned long noesc);
static int globadd(glob_t *g, char *path, unsigned limit);
static int glob_brace(glob_t *g, __const__ char *pattern, unsigned limit);

static void *g_opendir(__const__ char *name)
{
	return opendir(name);
}

static struct dirent *g_readdir(void *dir)
{
	return readdir(dir);
}

static void g_closedir(void *dir)
{
	closedir(dir);
}

static int fn_compare(__const__ void *a1, __const__ void *a2)
{
	__const__ unsigned char *s1 = *(__const__ unsigned char **)a1;
	__const__ unsigned char *s2 = *(__const__ unsigned char **)a2;
	while (1) {
		int c1 = *s1, c2 = *s2;
		if (__unlikely(!c1)) goto ret_diff;
		if (__unlikely(c1 != c2)) {
			if (__unlikely(c2 == '/') || __unlikely(!c2)) return 1;
			if (__unlikely(c1 == '/')) return -1;
			ret_diff:
			return c1 - c2;
		}
		s1++, s2++;
	}
}

#define IS_ALTDIR(g)	((g)->gl_opendir != g_opendir)

int glob(__const__ char *pattern, int flags, int (*errfunc)(__const__ char *path, int erno), glob_t *g)
{
#define fnmflags	((g->gl_flags & GLOB_NOESCAPE ? FNM_NOESCAPE : 0) | (g->gl_flags & GLOB_PERIOD ? 0 : FNM_PERIOD) | FNM_PATHNAME | FNM_CASEFOLD | _FNM_GLOB_INTERNAL)
	int r;
	unsigned limit;
	GLOBRQ *globrq;
	DECL_XLIST(globlist);
	int oldpathc;
	LOGICAL_LIST_REQUEST ll;
	char dira;
	char last_pattern_slash;
	int ll_idx;
	if (__likely(!(flags & GLOB_APPEND))) {
		g->gl_pathc = 0;
		g->gl_pathv = NULL;
		if (__likely(!(flags & GLOB_DOOFFS))) g->gl_offs = 0;
	}
	if (__unlikely(flags & GLOB_LIMIT)) {
		if (__unlikely(!(limit = g->gl_matchc))) limit = _GLOB_DEFAULT_LIMIT;
	} else {
		limit = MAXINT;
	}
	if (__likely(!(flags & GLOB_ALTDIRFUNC))) {
		g->gl_opendir = g_opendir;
		g->gl_readdir = g_readdir;
		g->gl_closedir = g_closedir;
		g->gl_lstat = lstat;
		g->gl_stat = stat;
	}
	g->gl_flags = flags & ~GLOB_MAGCHAR;
	g->gl_errfunc = errfunc;
	g->gl_matchc = 0;
	if (__unlikely(flags & GLOB_BRACE) && strchr(pattern, '{') && (pattern[0] != '{' || __likely(pattern[1] != '}') || pattern[2])) {
		return glob_brace(g, pattern, limit);
	}
	globrq = __sync_malloc(sizeof(GLOBRQ) + 6);
	if (__unlikely(!globrq)) {
		return GLOB_NOSPACE;
	}
	last_pattern_slash = __likely(pattern[0]) && __unlikely(pattern[strlen(pattern) - 1] == '/');
	if (__unlikely(pattern[0] == '~') && __likely(g->gl_flags & GLOB_TILDE)) {
		if (__likely(pattern[1] == '/')) {
			globrq->pattern_ptr = pattern + 2;
		} else if (__likely(!pattern[1])) {
			globrq->pattern_ptr = pattern + 1;
			last_pattern_slash = 1;
		} else {
			goto no_tilde;
		}
		strcpy(globrq->path, "HOME:/");
	} else {
		no_tilde:
		globrq->pattern_ptr = pattern;
		globrq->path[0] = 0;
	}
	ADD_TO_XLIST(&globlist, &globrq->list);
	oldpathc = g->gl_pathc;
	ll_idx = 0;		/* warning, go away */
	while (!XLIST_EMPTY(&globlist)) {
		__const__ char *str;
		size_t str_len;
		size_t pat_len;
		void *dir;
		struct dirent *de;
		globrq = LIST_STRUCT(globlist.next, GLOBRQ, list);
		DEL_FROM_LIST(&globrq->list);
		pat_len = strcspn(globrq->pattern_ptr, "/:*?[");
		if (__likely(globrq->pattern_ptr[pat_len] == '/') || __unlikely(globrq->pattern_ptr[pat_len] == ':') || __likely(!globrq->pattern_ptr[pat_len])) {
			struct stat st;
			no_magic:
			dir = NULL;
			str = globrq->pattern_ptr;
			str_len = pat_len;
			dira = 0;
			examine_entry:
			if (globrq->pattern_ptr[pat_len] || __unlikely(dira == 2)) {
				char *e;
				GLOBRQ *newrq = __sync_malloc(sizeof(GLOBRQ) + strlen(globrq->path) + str_len + 1);
				if (__unlikely(!newrq)) {
					nospace_closedir_free_globrq_abort:
					r = GLOB_NOSPACE;
					goto closedir_free_globrq_abort;
				}
				e = deescape_cpy(stpcpy(newrq->path, globrq->path), str, str_len, ((unsigned long)dir | (g->gl_flags & GLOB_NOESCAPE)));
				if (__likely(dira != 2)) {
					newrq->pattern_ptr = globrq->pattern_ptr + pat_len + 1;
					e[0] = globrq->pattern_ptr[pat_len];
					e[1] = 0;
				} else {
					newrq->pattern_ptr = globrq->pattern_ptr;
					e[0] = 0;
					if (__unlikely(g->gl_stat(newrq->path, &st))) {
						free_dont_add_this:
						__slow_free(newrq);
						goto dont_add_this;
					}
					if (__unlikely(S_ISLNK(st.st_mode))) g->gl_stat(newrq->path, &st);
					if (__unlikely(S_ISDIR(st.st_mode))) {
						e[0] = '/';
						e[1] = 0;
					} else if (__unlikely(globrq->pattern_ptr[pat_len])) {
						goto free_dont_add_this;
					}
				}
				ADD_TO_XLIST(&globlist, &newrq->list);
				dont_add_this:;
			} else {
				int last_slash;
				char *e;
				char *path = __sync_malloc(strlen(globrq->path) + str_len + 2);
				if (__unlikely(!path)) goto nospace_closedir_free_globrq_abort;
				e = deescape_cpy(stpcpy(path, globrq->path), str, str_len, ((unsigned long)dir | (g->gl_flags & GLOB_NOESCAPE)));
				e[0] = 0;
				if (__unlikely(g->gl_stat(path, &st))) {
					free_path_skip_entry:
					__slow_free(path);
					goto skip_this_entry;
				}
				last_slash = 0;
				if (__likely(e != path) && __unlikely(e[-1] == '/')) last_slash = GLOB_ONLYDIR;
				if (__unlikely((g->gl_flags | last_slash) & (GLOB_MARK | GLOB_ONLYDIR))) {
					if (__unlikely(S_ISLNK(st.st_mode))) g->gl_stat(path, &st);
					if (__unlikely(S_ISDIR(st.st_mode))) {
						if (!last_slash) {
							if (__likely(g->gl_flags & GLOB_MARK)) {
								e[0] = '/';
								e[1] = 0;
							}
						} else {
							if (__unlikely(!last_pattern_slash)) e[-1] = 0;
						}
					} else if (__unlikely((g->gl_flags | last_slash) & GLOB_ONLYDIR)) {
						goto free_path_skip_entry;
					}
				}
				g->gl_matchc++;
				r = globadd(g, path, limit);
				if (__unlikely(r)) {
					closedir_free_globrq_abort:
					if (dir) {
						if (__likely(dira)) g->gl_closedir(dir);
						else __slow_free(ll.prefix), KERNEL$FREE_LOGICAL_LIST(&ll);
					}
					goto free_globrq_abort;
				}
			}
			skip_this_entry:
			if (dir) goto cont_dir_scan;
		} else {
			pat_len = strcspn(globrq->pattern_ptr, "/:");
			if (!(g->gl_flags & GLOB_NOESCAPE)) {
				size_t l;
				for (l = 0; l < pat_len; l++) {
					char c = globrq->pattern_ptr[l];
					if (__unlikely(c == '\\')) {
						l++;
						continue;
					}
					if (c == '*' || __unlikely(c == '?') || __unlikely(c == '[')) goto have_magic;
				}
				goto no_magic;
				have_magic:;
			}
			g->gl_flags |= GLOB_MAGCHAR;
			dira = 1;
			if (__unlikely(globrq->pattern_ptr[pat_len] == ':')) {
				if (__likely(!IS_ALTDIR(g))) {
					size_t prefix_len;
					if (__unlikely(globrq->path[0])) goto cont;
					prefix_len = strcspn(globrq->pattern_ptr, ":*?[");
					ll.prefix = __sync_malloc(prefix_len + 1);
					if (__unlikely(!ll.prefix)) {
						goto do_err;
					}
					*(char *)mempcpy(ll.prefix, globrq->pattern_ptr, prefix_len) = 0;
					SYNC_IO(&ll, KERNEL$LIST_LOGICALS);
					if (__unlikely(ll.status < 0)) {
						free(ll.prefix);
						errno = -ll.status;
						goto do_err;
					}
					dira = 0;
					ll_idx = 0;
					dir = (void *)1;
					goto cont_dir_scan;
				}
			} else if (__unlikely(pat_len == 2) && __likely(globrq->pattern_ptr[0] == '^') && __likely(globrq->pattern_ptr[1] == '*')) {
				GLOBRQ *newrq = __sync_malloc(sizeof(GLOBRQ) + strlen(globrq->path));
				if (__unlikely(!newrq)) {
					r = GLOB_NOSPACE;
					goto free_globrq_abort;
				}
				newrq->pattern_ptr = globrq->pattern_ptr + 2 + (globrq->pattern_ptr[2] != 0);
				strcpy(newrq->path, globrq->path);
				ADD_TO_XLIST(&globlist, &newrq->list);
				dira = 2;
			}
			dir = g->gl_opendir(globrq->path[0] ? globrq->path : ".");
			if (__unlikely(!dir)) {
				int a;
				do_err:
				a = 0;
				if (__unlikely(g->gl_errfunc != NULL)) {
					a = g->gl_errfunc(globrq->path, errno);
				}
				if (__unlikely(a | (g->gl_flags & GLOB_ERR))) {
					r = GLOB_ABORTED;
					free_globrq_abort:
					__slow_free(globrq);
					while (!XLIST_EMPTY(&globlist)) {
						globrq = LIST_STRUCT(globlist.next, GLOBRQ, list);
						DEL_FROM_LIST(&globrq->list);
						__slow_free(globrq);
					}
					return r;
				}
				goto cont;
			}
			cont_dir_scan:
			if (__likely(dira)) {
				while ((de = g->gl_readdir(dir))) {
/* If the user supplied his own readdir, we must ignore d_type and d_namelen
   --- fixes GNU make */
					if (__unlikely(globrq->pattern_ptr[pat_len]) && __unlikely(de->d_type != DT_DIR) && __likely(de->d_type != DT_UNKNOWN) && __likely(!IS_ALTDIR(g))) continue;
					if (__unlikely(dira == 2)) {
						if (__unlikely(de->d_name[0] == '.') && (!de->d_name[1] || (__likely(de->d_name[1] == '.') && __likely(!de->d_name[2])))) {
							continue;
						}
						goto match_this;
					}
					if (!fnmatch(globrq->pattern_ptr, de->d_name, fnmflags)) {
						match_this:
						str = de->d_name;
						if (__unlikely(IS_ALTDIR(g))) str_len = strlen(de->d_name);
						else str_len = de->d_namlen;
						goto examine_entry;
					}
				}
				g->gl_closedir(dir);
			} else {
				while (ll_idx < ll.n_entries) {
					str = ll.entries[ll_idx++]->name;
					if (!fnmatch(globrq->pattern_ptr, str, fnmflags)) {
						str_len = strlen(str);
						goto examine_entry;
					}
				}
				free(ll.prefix), KERNEL$FREE_LOGICAL_LIST(&ll);
			}
		}
		cont:
		free(globrq);
	}
	if (__unlikely(g->gl_pathc == oldpathc)) {
		if (__unlikely(g->gl_flags & GLOB_NOCHECK) ||
		   (__unlikely((g->gl_flags & (GLOB_NOMAGIC | GLOB_MAGCHAR)) == GLOB_NOMAGIC))) {
			size_t sl;
			char *p = __sync_malloc((sl = strlen(pattern)) + 1);
			if (__unlikely(!p)) return GLOB_NOSPACE;
			*deescape_cpy(p, pattern, sl, g->gl_flags & GLOB_NOESCAPE) = 0;
			return globadd(g, p, limit);
		} else {
			return GLOB_NOMATCH;
		}
	}
	if (__likely(!(g->gl_flags & GLOB_NOSORT))) {
		qsort(g->gl_pathv + g->gl_offs + oldpathc, g->gl_pathc - oldpathc, sizeof(char *), fn_compare);
	}
	return 0;
#undef fnmflags
}

static char *deescape_cpy(char *dest, __const__ char *src, size_t len, unsigned long noesc)
{
	if (noesc) return mempcpy(dest, src, len);
	while (len--) {
		if (__unlikely(*src == '\\')) {
			src++;
			if (!len--) break;
		}
		*dest++ = *src++;
	}
	return dest;
}

static int globadd(glob_t *g, char *path, unsigned limit)
{
	char **pathv;
	if (__unlikely(g->gl_pathc >= limit)) {
		errno = 0;
		free_ret_nospace:
		__slow_free(path);
		return GLOB_NOSPACE;
	}
	pathv = __sync_realloc(g->gl_pathv, sizeof(char *) * (g->gl_pathc + g->gl_offs + 2));
	if (__unlikely(!pathv)) {
		goto free_ret_nospace;
	}
	if (__unlikely(g->gl_offs > 0) && !g->gl_pathv) {
		int i;
		for (i = 0; i < g->gl_offs; i++) pathv[i] = NULL;
	}
	g->gl_pathv = pathv;
	pathv += g->gl_offs + g->gl_pathc++;
	pathv[0] = path;
	pathv[1] = NULL;
	return 0;
}

void globfree(glob_t *g)
{
	if (__likely(g->gl_pathv != NULL)) {
		char **p;
		for (p = g->gl_pathv + g->gl_offs; *p; p++) free(*p);
		free(g->gl_pathv);
		g->gl_pathv = NULL;
		g->gl_pathc = 0;
	}
}

struct brace_desc {
	int next;
	int stack;
};

static int glob_brace(glob_t *g, __const__ char *pattern, unsigned limit)
{
	int oldpathc;
	int flags;
	int r;

	size_t len = strlen(pattern);
	struct brace_desc *d;
	char *result;
	int i, j, k;
	int depth;
	int bracket;
#define s ((char *)(d + len))
#if __DEBUG < 2
#define CHECK(x)	(x)
#else
#define CHECK(x)	(__unlikely((size_t)(x) >= len) ? KERNEL$SUICIDE("glob_brace: BAD ACCESS TO %d AT %d, PATTERN \"%s\"", (x), __LINE__, pattern), 0 : (x))
#endif
#define NEXT(x)		(d[CHECK(x)].next)
#define STACK(x)	(d[CHECK(x)].stack)
#define MARK		((int)(__INT_SGN_BIT >> 1))
#define VAL		(MARK - 1)
	if (__unlikely(len >= MAXUINT / (sizeof(struct brace_desc) + 1))) {
		errno = EOVERFLOW;
		return GLOB_NOSPACE;
	}
	d = __sync_malloc(len * (sizeof(struct brace_desc) + 1) + 1);
	if (__unlikely(!d)) return GLOB_NOSPACE;

	/* preprocess the pattern */

	depth = -1;
	bracket = 0;
	for (i = 0; pattern[i]; i++) {
		NEXT(i) = -1;
		if (__unlikely(pattern[i] == '\\') && __likely(pattern[i + 1]) && __likely(!(g->gl_flags & GLOB_NOESCAPE))) {
			i++;
			NEXT(i) = -1;
		} if (pattern[i] == '{' && __likely(!bracket)) {
			depth++;
			STACK(depth) = i;
		} else if (pattern[i] == ',' && __likely(!bracket) && __likely(depth >= 0)) {
			NEXT(STACK(depth)) = i;
			STACK(depth) = i;
		} else if (pattern[i] == '}' && __likely(!bracket) && __likely(depth >= 0)) {
			NEXT(STACK(depth)) = i;
			depth--;
		} else if (__unlikely(pattern[i] == '[')) {
			bracket = 1;
		} else if (__unlikely(pattern[i] == ']')) {
			bracket = 0;
		}
	}

	/* preprocess 2: remove unclosed braces and make cycles */

	for (i = 0; pattern[i]; i++) if (pattern[i] == '{' && __likely(NEXT(i) >= 0)) {
		j = i;
		do {
			j = NEXT(j);
			if (__unlikely(j < 0)) {
				for (j = i; j >= 0; k = NEXT(j), NEXT(j) = -1, j = k) ;
				goto brk;
			}
		} while (pattern[j] != '}');
		NEXT(j) = i;
		NEXT(i) |= MARK;
		brk:;
	}

	oldpathc = g->gl_pathc;
	flags = g->gl_flags;

	/* process it: construct pattern */

	next:
	depth = 0;
	result = s;
	for (i = 0; pattern[i]; i++) {
		again:
		if (__likely(NEXT(i) < 0)) {
			*result++ = pattern[i];
		} else if (NEXT(i) & MARK) {
			STACK(depth) = i;
			depth++;
		} else {
			if (__likely(NEXT(i) >= i)) {
				i = NEXT(i);
				goto again;
			}
		}
	}
	*result = 0;

	/* process it: glob pattern */

	/*__debug_printf("%s\n", s);*/
	g->gl_matchc = limit;
	r = glob(s, (flags & ~GLOB_BRACE) | GLOB_APPEND | GLOB_DOOFFS | GLOB_ALTDIRFUNC | GLOB_LIMIT, g->gl_errfunc, g);
	flags |= g->gl_flags & GLOB_MAGCHAR;
	if (r != GLOB_NOMATCH && __unlikely(r)) goto ret;

	/* process it: make next alternative */

	while (depth--) {
		j = NEXT(STACK(depth)) &= ~MARK;
		if (NEXT(j) >= j) {
			NEXT(j) |= MARK;
			goto next;
		}
		j = NEXT(j);
		NEXT(j) |= MARK;
	}

	/* end */

	r = __unlikely(g->gl_pathc == oldpathc) ? GLOB_NOMATCH : 0;

	ret:
	free(d);
	g->gl_flags = flags;
	return r;

#undef s
#undef CHECK
#undef NEXT
#undef STACK
#undef MARK
#undef VAL
}
