#include <SYS/PARAM.H>
#include <ERRNO.H>
#include <VALUES.H>
#include <TIME.H>
#include <ARCH/PAGE.H>

#include <UNISTD.H>

long sysconf(int name)
{
	switch (name) {
		case _SC_ARG_MAX:
			return ARG_MAX;
		case _SC_CHILD_MAX:
			return CHILD_MAX;
		case _SC_CLK_TCK:
			return CLK_TCK;
		case _SC_JOB_CONTROL:
			return -1;
		case _SC_NGROUPS_MAX:
			return NGROUPS_MAX;
		case _SC_OPEN_MAX:
			return OPEN_MAX;
		case _SC_STREAM_MAX:
			return STREAMS_MAX;
		case _SC_TZNAME_MAX:
			return _POSIX_TZNAME_MAX;
		case _SC_SAVED_IDS:
			return -1;
		case _SC_VERSION:
			return 199309L;
		case _SC_BC_BASE_MAX:
			return _POSIX2_BC_BASE_MAX;
		case _SC_BC_DIM_MAX:
			return _POSIX2_BC_DIM_MAX;
		case _SC_BC_SCALE_MAX:
			return _POSIX2_BC_SCALE_MAX;
		case _SC_BC_STRING_MAX:
			return _POSIX2_BC_STRING_MAX;
		case _SC_COLL_WEIGHTS_MAX:
			return _POSIX2_EQUIV_CLASS_MAX;
		case _SC_EXPR_NEST_MAX:
			return _POSIX2_EXPR_NEST_MAX;
		case _SC_LINE_MAX:
			return _POSIX2_LINE_MAX;
		case _SC_RE_DUP_MAX:
			return _POSIX2_RE_DUP_MAX;
		case _SC_2_VERSION:
			return 199309L;
		case _SC_2_C_BIND:
			return 1;
		case _SC_2_C_DEV:
			return 1;
		case _SC_2_CHAR_TERM:
			return 1;
		case _SC_2_FORT_DEV:
			return 1;
		case _SC_2_LOCALEDEF:
			return 1;
		case _SC_2_SW_DEV:
			return 1;
		case _SC_2_UPE:
			return 1;

			/* i have no docs on these ... guessing ... */
		case _SC_ASYNCHRONOUS_IO:
			return 1;
		case _SC_MAPPED_FILES:
			return 1;
		case _SC_MEMLOCK:
			return -1;
		case _SC_MEMLOCK_RANGE:
			return -1;
		case _SC_MEMORY_PROTECTION:
			return 1;
		case _SC_MESSAGE_PASSING:
			return 1;
		case _SC_PRIORITIZED_IO:
			return -1;
		case _SC_PRIORITY_SCHEDULING:
			return -1;
		case _SC_REALTIME_SIGNALS:
			return -1;
		case _SC_SEMAPHORES:
			return 1;
		case _SC_FSYNC:
			return 1;
		case _SC_SHARED_MEMORY_OBJECTS:
			return 1;
		case _SC_SYNCHRONIZED_IO:
			return -1;
		case _SC_TIMERS:
			return 1;
		case _SC_AIO_LISTIO_MAX:
			return MAXINT;
		case _SC_AIO_MAX:
			return MAXINT;
		case _SC_AIO_PRIO_DELTA_MAX:
			return MAXINT;
		case _SC_DELAYTIMER_MAX:
			return MAXINT;
		case _SC_MQ_OPEN_MAX:
			return MAXINT;
		case _SC_PAGESIZE:
			return __PAGE_CLUSTER_SIZE;
		case _SC_RTSIG_MAX:
			return -1;
		case _SC_SEM_NSEMS_MAX:
			return MAXINT;
		case _SC_SEM_VALUE_MAX:
			return MAXINT;
		case _SC_SIGQUEUE_MAX:
			return MAXINT;
		case _SC_TIMER_MAX:
			return MAXINT;
		case _SC_NPROCESSORS_CONF:
			return 1;
		case _SC_NPROCESSORS_ONLN:
			return 1;
		default:
			errno = EINVAL;
			return -1;
	}
}
