#include <SPAD/SYSLOG.H>

#include <SYSLOG.H>

extern char *__progname;
static __const__ char *logname = NULL;

void syslog(int pri, const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	vsyslog(pri, fmt, ap);
	va_end(ap);
}

void vsyslog(int pri, __const__ char *fmt, va_list ap)
{
	KERNEL$SYSLOGV(pri == LOG_EMERG || pri == LOG_ALERT || pri == LOG_CRIT || pri == LOG_ERR ? __SYSLOG_SW_ERROR : pri == LOG_WARNING ? __SYSLOG_SW_WARNING : __SYSLOG_SW_INFO, !logname ? __progname : logname, fmt, ap);
}

void openlog(__const__ char *name, int option, int facility)
{
	logname = name;
}

void closelog(void)
{
}

int setlogmask(int mask)
{
	return 0;
}
