/*
 * cabs() wrapper for hypot().
 *
 * Written by J.T. Conklin, <jtc@wimsey.com>
 * Placed into the Public Domain, 1994.
 */

#include <COMPLEX.H>
#include <MATH.H>

#ifdef __HAVE_COMPLEX
double
cabs(z)
	double complex z;
{
	return hypot(creal(z), cimag(z));
}

double
z_abs(z)
	double complex *z;
{
	return hypot(creal(*z), cimag(*z));
}
#else
#include <SPAD/LIBC.H>
void cabs(void);
void cabs(void)
{
	KERNEL$SUICIDE("LIBM NOT COMPILED WITH COMPLEX NUMBER SUPPORT");
}
void z_abs(void);
void z_abs(void)
{
	KERNEL$SUICIDE("LIBM NOT COMPILED WITH COMPLEX NUMBER SUPPORT");
}
#endif
