/*
 * cabsf() wrapper for hypotf().
 *
 * Written by J.T. Conklin, <jtc@wimsey.com>
 * Placed into the Public Domain, 1994.
 */

#include <COMPLEX.H>
#include <MATH.H>
#include "MATH_PRIVATE.H"

#ifdef __HAVE_COMPLEX
float
cabsf(z)
	float complex z;
{

	return hypotf(crealf(z), cimagf(z));
}
#else
#include <SPAD/LIBC.H>
void cabsf(void);
void cabsf(void)
{
	KERNEL$SUICIDE("LIBM NOT COMPILED WITH COMPLEX NUMBER SUPPORT");
}
#endif
