#include <STDLIB.H>
#include <ERRNO.H>
#include <SPAD/LIBC.H>

#include "PTHREAD.H"
#include <PTHREAD.H>

int pthread_attr_init(pthread_attr_t *a)
{
	struct __pthread_attr_s *as;
	if (__unlikely(!(as = malloc(sizeof(struct __pthread_attr_s))))) return ENOMEM;
	a->__p = as;
	as->detachstate = PTHREAD_CREATE_JOINABLE;
	as->stackaddr = NULL;
	as->stacksize = get_default_stack_size();
	return 0;
}

int pthread_attr_destroy(pthread_attr_t *a)
{
	if (__unlikely(!a->__p)) KERNEL$SUICIDE("pthread_attr_destroy: uninitialized attribute");
	free(a->__p);
	a->__p = NULL;
	return 0;
}

int pthread_attr_getdetachstate(const pthread_attr_t *a, int *d)
{
	*d = a->__p->detachstate;
	return 0;
}

int pthread_attr_setdetachstate(pthread_attr_t *a, int d)
{
	if (__unlikely((unsigned)d > PTHREAD_CREATE_DETACHED)) return EINVAL;
	a->__p->detachstate = d;
	return 0;
}

int pthread_attr_getguardsize(const pthread_attr_t *a, size_t *g)
{
	*g = 0;
	return 0;
}

int pthread_attr_setguardsize(pthread_attr_t *a, size_t g)
{
	return 0;
}

int pthread_attr_getinheritsched(const pthread_attr_t *a, int *s)
{
	return ENOSYS;
}

int pthread_attr_setinheritsched(pthread_attr_t *a, int s)
{
	return ENOSYS;
}

int pthread_attr_getschedparam(const pthread_attr_t *a, struct sched_param *s)
{
	return ENOSYS;
}

int pthread_attr_setschedparam(pthread_attr_t *a, const struct sched_param *s)
{
	return ENOSYS;
}

int pthread_attr_getschedpolicy(const pthread_attr_t *a, int *s)
{
	return ENOSYS;
}

int pthread_attr_setschedpolicy(pthread_attr_t *a, int s)
{
	return ENOSYS;
}

int pthread_attr_getscope(const pthread_attr_t *a, int *s)
{
	return ENOSYS;
}

int pthread_attr_setscope(pthread_attr_t *a, int s)
{
	return ENOSYS;
}

int pthread_attr_getstackaddr(const pthread_attr_t *a, void **s)
{
	*s = a->__p->stackaddr;
	return 0;
}

int pthread_attr_setstackaddr(pthread_attr_t *a, void *s)
{
	a->__p->stackaddr = s;
	return 0;
}

int pthread_attr_getstacksize(const pthread_attr_t *a, size_t *s)
{
	*s = a->__p->stacksize;
	return 0;
}

int pthread_attr_setstacksize(pthread_attr_t *a, size_t s)
{
	a->__p->stacksize = s;
	return 0;
}


