#ifndef __LIB_PTHREAD_PTHREAD_H
#define __LIB_PTHREAD_PTHREAD_H

#include <SYS/TYPES.H>
#include <SCHED.H>
#include <SPAD/WQ.H>
#include <TIME.H>
#include <SPAD/THREAD.H>
#include <SETJMP.H>
#include <STDLIB.H>

struct __pthread_attr_s {
	int detachstate;
	void *stackaddr;
	size_t stacksize;
};

struct __pthread_cond_s {
	WQ wq;
};

struct __pthread_condattr_s {
	int pshared;
};

struct __pthread_mutex_s {
	MTX mtx;
};

struct __pthread_mutexattr_s {
	int pshared;
	int mtype;
};

struct __pthread_rwlock_s {
	WQ wq;
};

struct __pthread_rwlockattr_s {
	int pshared;
};

struct __pthread_s {
	THREAD_RQ rq;
	char cancel_enable;
	char cancelstate;
	char canceltype;
	char cancel_pending;
	void *(*fn)(void *);
	void *data;
	void *exit_value;
	jmp_buf terminate;
	int detached;
	int finished;
	WQ joinwait;
	struct cleanup_entry *cleanup_stack;
	struct specific *specific;
	pthread_key_t n_specific;
	__u32 id[__PTHREAD_ID_ENTRIES];
	sigset_t init_sigmask;
};

struct cleanup_entry {
	struct cleanup_entry *next;
	void (*fn)(void *);
	void *data;
};

size_t get_default_stack_size(void);
void destroy_specific(pthread_t);

static __finline__ void set_uniq_id(struct __pthread_s *p)
{
	if (__unlikely(!p->id[0])) {
		int i;
		for (i = 0; i < __PTHREAD_ID_ENTRIES; i++) p->id[i] = arc4random();
		if (__unlikely(!p->id[0])) p->id[0] = 1;
	}
}

__u64 gettime(void);

void setup_cancel(void);

#endif
