#include <ERRNO.H>
#include <ARCH/BITOPS.H>

#include <PTHREAD.H>
#include "PTHREAD.H"

struct key {
	void (*dest)(void *);
	int active;
	long generation;
	long dummy_pad;		/* so that size is power of 2 */
};

struct specific {
	void *value;
	long generation;
};

static struct key *keys = NULL;
static pthread_key_t n_keys = 0;
static pthread_key_t test_key = 0;

int pthread_key_create(pthread_key_t *kp, void (*dest)(void *))
{
	pthread_key_t k;
	struct key *xkeys;
	RAISE_SPL(SPL_DEV);
	for (k = test_key; k < n_keys; k++) {
		if (__likely(!keys[k].active)) {
			key_ok:
			test_key = k + 1;
			keys[k].active = 1;
			keys[k].dest = dest;
			LOWER_SPL(SPL_ZERO);
			*kp = k;
			return 0;
		}
	}
	for (k = 0; k < test_key; k++) {
		if (__likely(!keys[k].active)) goto key_ok;
	}
	if (__unlikely(!(xkeys = realloc(keys, ((n_keys << 1) + 1) * sizeof(struct key))))) {
		LOWER_SPL(SPL_ZERO);
		return ENOMEM;
	}
	keys = xkeys;
	k = n_keys;
	n_keys = __alloc_size(keys) / sizeof(struct key);
	memset(keys + k, 0, (n_keys - k) * sizeof(struct key));
	goto key_ok;
}

int pthread_key_delete(pthread_key_t k)
{
	RAISE_SPL(SPL_DEV);
	if (__unlikely(k >= n_keys) || __unlikely(!keys[k].active)) {
		LOWER_SPL(SPL_ZERO);
		return EINVAL;
	}
	keys[k].active = 0;
	keys[k].generation++;
	LOWER_SPL(SPL_ZERO);
	return 0;
}

void *pthread_getspecific(pthread_key_t k)
{
	pthread_t p = pthread_self();
	if (__unlikely(k >= p->n_specific)) return NULL;
	if (__unlikely(p->specific[k].generation != keys[k].generation)) return NULL;
	return p->specific[k].value;
}

int pthread_setspecific(pthread_key_t k, const void *v)
{
	pthread_t p = pthread_self();
	if (__unlikely(k >= p->n_specific)) {
		struct specific *spec;
		pthread_key_t nk = n_keys;
		if (__unlikely(k >= nk)) return EINVAL;
		if (__unlikely(!(spec = realloc(p->specific, nk * sizeof(struct specific))))) return ENOMEM;
		p->specific = spec;
		memset(p->specific + p->n_specific, 0, (nk - p->n_specific) * sizeof(struct specific));
		p->n_specific = nk;
	}
	RAISE_SPL(SPL_DEV);
	p->specific[k].value = (void *)v;
	p->specific[k].generation = keys[k].generation;
	LOWER_SPL(SPL_ZERO);
	return 0;
}

void destroy_specific(pthread_t p)
{
	int i;
	for (i = 0; i < PTHREAD_DESTRUCTOR_ITERATIONS; i++) {
		int dcall = 0;
		pthread_key_t k;
		void *v;
		void (*dest)(void *);
		for (k = 0; k < p->n_specific; k++) if ((v = p->specific[k].value)) {
			RAISE_SPL(SPL_DEV);
			if (__likely(p->specific[k].generation == keys[k].generation) && (dest = keys[k].dest)) {
				LOWER_SPL(SPL_ZERO);
				p->specific[k].value = 0;
				dest(v);
				dcall = 1;
			} else {
				LOWER_SPL(SPL_ZERO);
			}
		}
		if (!dcall) break;
	}
}

