#include <SPAD/LIBC.H>
#include <SPAD/DL.H>
#include <SPAD/LIST.H>
#include <SPAD/ALLOC.H>
#include <SPAD/VM.H>
#include <SPAD/HASH.H>
#include <SPAD/DEV.H>
#include <SPAD/READDIR.H>
#include <DIRENT.H>
#include <SYS/STAT.H>
#include <SYS/PARAM.H>
#include <SPAD/IOCTL.H>
#include <STDLIB.H>
#include <SPAD/SYNC.H>
#include <SPAD/THREAD.H>
#include <DLFCN.H>
#include <GLOB.H>

#include <SPAD/SHELLM.H>
#include "SHELL.H"

extern AST_STUB SHELL_CONTEXT_ALLOCATED;
extern AST_STUB SHELL_COMMAND_BUFFER_ALLOCATED;
extern AST_STUB SHELL_ARGV_BUFFER_ALLOCATED;
static long SHELL_COMMAND_THREAD(void *ctx_);
extern AST_STUB SHELL_DONE_THREAD;
extern AST_STUB SHELL_ERROR_MSG_WRITTEN;
extern AST_STUB SHELL_EXIT;
static __const__ CMD unknown_command;

__const__ char tokgroups[256] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  
0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
};

void SHELL$ESC_COPY(char *dest, __const__ char *src)
{
	unsigned char c;
	if (__unlikely(!*src)) {
		dest[1] = dest[0] = '"';
		dest[2] = 0;
		return;
	}
	next:
	c = *src++;
	if (__unlikely(!c)) {
		*dest = 0;
		return;
	}
	if (__likely(c > ' ') && __likely(c != '\'') && __likely(c != '"') && __likely(c != '%') && __likely(c != ';') && __likely(!GLOBCHAR(c))) {
		*dest++ = c;
		goto next;
	}
	if (__unlikely(c == '"')) {
		*dest++ = '\'';
		*dest++ = '"';
		*dest++ = '\'';
		goto next;
	}
	*dest++ = '"';
	*dest++ = c;
	*dest++ = '"';
	goto next;
}

__finline__ struct var *find_var(CTX *ctx, __const__ char *n, __const__ char *e, int only_this)
{
	struct var *v;
	int hash = 0;
	__const__ char *x = n;
	quickcasehash(x, x != e, hash);
	hash &= VAR_HASH_SIZE - 1;
	again:
	XLIST_FOR_EACH(v, &ctx->var_hash[hash], struct var, hash) {
		if (v->namel == e - n && !__memcasexcmp(v->name, n, e))
			return v;
	}
	if (only_this) return NULL;
	ctx = ctx->var_chain;
	if (!ctx) return NULL;
	goto again;
}

__finline__ void free_var(struct var *v)
{
	while (!XLIST_EMPTY(&v->for_values)) {
		struct for_value *f = LIST_STRUCT(v->for_values.next, struct for_value, list);
		DEL_FROM_LIST(&f->list);
		free(f);
	}
	free(v);
}

__finline__ void del_var(struct var *v)
{
	DEL_FROM_LIST(&v->hash);
	free_var(v);
}

__finline__ void init_var(struct var *v)
{
	INIT_XLIST(&v->for_values);
	v->for_ptr = NULL;
}

__finline__ void add_var(CTX *ctx, struct var *v)
{
	char *n = v->name;
	int hash = 0;
	quickcasehash(n, (*n = __upcasechr(*n)) && *n != '=', hash);
	v->namel = n - v->name;
	hash &= VAR_HASH_SIZE - 1;
	ADD_TO_XLIST(&ctx->var_hash[hash], &v->hash);
}

int check_var_name(__const__ char *name, __const__ char *nameend)
{
	if (__unlikely(nameend < name)) KERNEL$SUICIDE("check_var_name: name %p, nameend %p", name, nameend);
	if (__unlikely(nameend == name)) return -EINVAL;
	if (__unlikely(nameend - name >= MIN(SCRATCH_1_LEN, __MAX_STR_LEN))) return -ENAMETOOLONG;
	if (__likely(*name >= '0') && __unlikely(*name <= '9')) return -EINVAL;
	do {
		if (__unlikely(!is_var_char(*name))) return -EINVAL;
	} while (++name < nameend);
	return 0;
}

char *find_var_name(CTX *ctx, __const__ char **pp, __const__ char *e, int sync, int *fr)
{
	char *ee;
	struct var *vv;
	char v[__MAX_STR_LEN];
	__const__ char *p = ++*pp;
	char c;
	*fr = 0;
	if (__unlikely(p >= e)) {
		m:
		if (__unlikely(*pp > e)) --*pp;
		return "";
	}
	c = *p;
	if (__likely(c == '@')) {
		++*pp;
		return NULL;
	}
	if (__likely(c >= '0') && __unlikely(c < '9')) {
		int n = c - '0';
		p++;
		while (__likely(p < e) && __likely(p < *pp + 9) && *p >= '0' && __unlikely(*p < '9')) {
			n = n * 10 + *p++ - '0';
		}
		*pp = p;
		if (n < ctx->rq->narg) return (char *)ctx->rq->arg[n];
		else return "";
	}
	if (__likely(is_var_char(c))) {
		while (*pp < e && is_var_char(**pp)) ++*pp;
		if (*pp - p >= __MAX_STR_LEN) return "";
		memcpy(v, p, *pp - p);
		v[*pp - p] = 0;
		if (__likely((vv = find_var(ctx, p, *pp, 0)) != NULL)) return vv->name + vv->namel + 1;
		if (__unlikely((ee = getenv(v)) != NULL)) return ee;
		return "";
	}
	if (__likely(c == '(')) {
		int level, u;
		if (!sync) return (void *)1;
		level = 1, u = 0;
		while (__likely(++*pp < e)) {
			char cc = **pp;
			if (__unlikely(cc == '"')) u = !u;
			else if (__unlikely(u)) continue;
			else if (__unlikely(cc == ';') || __unlikely(cc == '\n')) break;
			else if (__unlikely(cc == '(')) level++;
			else if (__unlikely(cc == ')')) {
				if (!--level) {
					++*pp;
					return EVAL_EXPRESSION(ctx, p, *pp, fr);
				}
			}
			else if (__unlikely(cc == '\'')) break;
		}
		*pp = p;
		goto m;
	}
	if (__unlikely(c == '^')) {
		++*pp;
		return ctx->return_msg;
	}
	if (__likely(c == '?')) {
		++*pp;
		_snprintf(ctx->scratch_1, SCRATCH_1_LEN, "%d", ctx->return_val);
		return ctx->scratch_1;
	}
	goto m;
}

__const__ char *find_var_env(CTX *ctx, __const__ char *e)
{
	struct var *v;
	if (__unlikely((v = find_var(ctx, e, e + strlen(e), 0)) != NULL)) return v->name + v->namel + 1;
	return getenv(e);
}

#define argv_allocated(p)	(__alloc_size(p) / sizeof(char *))

static void do_glob(CTX *ctx);

static void xtend_cb(CTX *ctx, char c, int sync)
{
	char *a;
	int i;
	if (!sync) {
		ctx->command_buffer_pos++;
		return;
	}
	if (__unlikely(ctx->command_buffer_pos > __alloc_size(ctx->command_buffer)) || __unlikely(!(a = __sync_realloc(ctx->command_buffer, (ctx->command_buffer_pos + 0x40))))) {
		ctx->command_buffer_pos++;
		return;
	}
	for (i = 0; i < ctx->argv_buffer_pos && i < argv_allocated(ctx->argv_buffer); i++) {
		ctx->argv_buffer[i] += a - ctx->command_buffer;
	}
	(ctx->command_buffer = a)[ctx->command_buffer_pos++] = c;
}

static void xtend_ab(CTX *ctx, int sync)
{
	char **a;
	if (!sync) {
		ctx->argv_buffer_pos++;
		return;
	}
	if (__unlikely(ctx->argv_buffer_pos > argv_allocated(ctx->argv_buffer)) || __unlikely(!(a = __sync_realloc(ctx->argv_buffer, (ctx->argv_buffer_pos + 0x08) * sizeof(char *))))) {
		ctx->argv_buffer_pos++;
		return;
	}
	(ctx->argv_buffer = a)[ctx->argv_buffer_pos++] = ctx->command_buffer + ctx->command_buffer_pos;
}

#define put_char(ctx, c, sync)						\
do {									\
	if (__likely((ctx)->command_buffer_pos < __alloc_size((ctx)->command_buffer)))\
		(ctx)->command_buffer[(ctx)->command_buffer_pos++] = (c);\
	else xtend_cb(ctx, c, sync);					\
} while (0)

#define new_arg(ctx, glob_last, sync)					\
do {									\
	if (__unlikely(glob_last)) {					\
		glob_last = 0;						\
		do_glob(ctx);						\
	}								\
	if (__likely((ctx)->argv_buffer_pos < argv_allocated((ctx)->argv_buffer)))\
		(ctx)->argv_buffer[(ctx)->argv_buffer_pos++] = (ctx)->command_buffer + (ctx)->command_buffer_pos;\
	else xtend_ab(ctx, sync);					\
} while (0)

#define nonempty_last(ctx) (__unlikely((ctx)->argv_buffer_pos > argv_allocated((ctx)->argv_buffer)) || (__likely((ctx)->argv_buffer_pos > 0) && (ctx)->argv_buffer[(ctx)->argv_buffer_pos - 1] != (ctx)->command_buffer + (ctx)->command_buffer_pos))

static char *get_arg(CTX *ctx, unsigned pos)
{
	if (__likely(ctx->command_buffer_pos <= __alloc_size(ctx->command_buffer)) && __likely(ctx->argv_buffer_pos <= argv_allocated(ctx->argv_buffer)) && __likely(pos + 1 < ctx->argv_buffer_pos)) return ctx->argv_buffer[pos];
	return NULL;
}

static int test_command(CTX *ctx, __const__ char *command, int pos)
{
	unsigned apos;
	char *a;
	if (__likely((unsigned)ctx->argv_buffer_pos - pos > 1) && pos != -1) return 0;
	apos = 0;
	a = get_arg(ctx, apos);
	if (__unlikely(!a)) return 0;
	if (__likely(a[0] >= '0') && __unlikely(a[0] <= '9')) {
		unsigned i;
		for (i = 1; a[i]; i++) if (__unlikely(!is_var_char(a[i]))) goto no_label;
		apos = 1;
		a = get_arg(ctx, apos);
		if (__unlikely(!a)) return 0;
	}
	no_label:
	if (__unlikely(ctx->argv_buffer_pos != pos + apos) && pos != -1) return 0;
	return !_strcasecmp(a, command);
}

static __const__ char *find_keyword(__const__ char *pos, __const__ char *end, __const__ char *keyword, int word)
{
	size_t len = keyword ? strlen(keyword) : 1;
	__const__ char *start = pos;
	int level = 0;
	if (__unlikely(!len)) KERNEL$SUICIDE("find_keyword: EMPTY KEYWORD");
	for (; pos < end - len + 1; pos++) {
		unsigned char c = *pos;
		if (__unlikely(c == '"'))
			do if (++pos >= end) goto ret_pos; while (*pos != c);
		else if (c == '(') level++;
		else if (c == ')') level--;
		else if (keyword && !level && __unlikely(!_memcasecmp(pos, keyword, len))) {
			if (__likely(word) && __likely(pos != start) && __unlikely(is_var_char(pos[-1]))) continue;
			if (__likely(word) && __likely(pos + len != end) && __unlikely(is_var_char(pos[len]))) continue;
			return pos;
		}
		if (__unlikely(tokgroups[c] == 2)) goto ret_pos;
	}
	ret_pos:
	return !keyword ? pos : NULL;
}

/* expect that void** has the same size as function** */
void *liblink(CTX *ctx, char *dll, ...)
{
	va_list args;
	void *lib;
	char *sym;

	{
		/* This block may be commented out to reduce speed and memory
		   consumption of the shell */
		char *p;
		DLLZRQ lz;
		lz.handle = NULL;
		lz.caller = liblink;
		p = stpcpy(lz.modname, dll);
		if (__likely(p - lz.modname > 4)) {
			p -= 4;
			if (__likely(!_memcasecmp(p, ".DLL", 4))) *p = 0;
		}
		SYNC_IO(&lz, KERNEL$DL_LOAD_LAZY);
	}

	LOWER_SPL(SPL_ZERO);
	lib = dlopen(dll, RTLD_NOW);
	RAISE_SPL(SPL_SHELL);
	if (__unlikely(!lib)) {
		if (ctx) _snprintf(ctx->return_msg, __MAX_STR_LEN, "CAN'T LINK %s", dll);
		err_ret:
		if (ctx) {
			ctx->return_val = -ENOENT;
			ctx->internal_flags |= SHELL_THREAD_ERROR;
		}
		return NULL;
	}
	va_start(args, dll);
	while ((sym = va_arg(args, char *))) {
		void **loc = va_arg(args, void **);
		if (__unlikely(!(*loc = dlsym(lib, sym)))) {
			if (ctx) _snprintf(ctx->return_msg, __MAX_STR_LEN, "CAN'T FIND %s IN %s", sym, dll);
			libclose(lib);
			va_end(args);
			goto err_ret;
		}
	}
	va_end(args);
	__barrier(); /* formally needed to prevent aliasing: void** is not the same as function** */
	return lib;
}

void libclose(void *lib)
{
	LOWER_SPL(SPL_ZERO);
	dlclose(lib);
	RAISE_SPL(SPL_SHELL);
}

static void do_glob(CTX *ctx)
{
	int i;
	char *c;
	glob_t g;
	void *libc;
	int (*pglob)(const char *, int, int(*)(const char *, int), glob_t *);
	void (*pglobfree)(glob_t *);
	if (__unlikely(!ctx->argv_buffer_pos)) return;
	if (__unlikely(ctx->argv_buffer_pos > argv_allocated(ctx->argv_buffer))) return;
	if (__unlikely(!(libc = liblink(NULL, "LIBC.DLL", "glob", &pglob, "globfree", &pglobfree, NULL)))) return;
	if (__unlikely(pglob(ctx->argv_buffer[ctx->argv_buffer_pos - 1], GLOB_NOESCAPE | GLOB_TILDE, NULL, &g))) {
		ctx->argv_buffer_pos--;
		if (__likely(!test_command(ctx, "FOR", -1))) ctx->argv_buffer_pos++;
		goto globfree_close_ret;
	}
	ctx->argv_buffer_pos--;
	for (i = 0; i < g.gl_pathc; i++) {
		int zero = 0;
		new_arg(ctx, zero, 1);
		for (c = g.gl_pathv[i]; *c; c++) put_char(ctx, *c, 1);
		put_char(ctx, 0, 1);
	}
	globfree_close_ret:
	pglobfree(&g);
	libclose(libc);
}

static void set_color(CTX *ctx, shell_color_t attr, shell_color_t mask, char *string)
{
	static __const__ char toansi[8] = "04152637";
	if (__unlikely(ctx->color == attr) && !mask) {
		goto ret;
	}
	*string++ = 27;
	*string++ = '[';
	if (__unlikely(((ctx->color ^ attr) | mask) & 0x81c0)) {
		*string++ = '0';
		*string++ = ';';
		if (__unlikely(attr & 0x100)) {
			*string++ = '7';
			*string++ = ';';
		}
		if (__unlikely(attr & 0x80)) {
			*string++ = '5';
			*string++ = ';';
		}
		if (__unlikely(attr & 0x40)) {
			*string++ = '1';
			*string++ = ';';
		}
		mask |= ctx->modified_color;
	}
	if (((ctx->color ^ attr) | mask) & 0x07) {
		*string++ = '3';
		*string++ = toansi[attr & 0x07];
		if (((ctx->color ^ attr) | mask) & 0x38) {
			*string++ = ';';
			goto set_bg;
		}
	}
	if (((ctx->color ^ attr) | mask) & 0x38) {
		set_bg:
		*string++ = '4';
		*string++ = toansi[(attr >> 3) & 0x07];
	}
	*string++ = 'm';
	ctx->color = attr;
	ctx->modified_color |= mask;
	ret:
	*string = 0;
}

static void set_color_print(CTX *ctx, shell_color_t attr, shell_color_t mask)
{
	char c[COLOR_STRING_LEN + 1], *x;
	set_color(ctx, attr, mask, c);
	if (__unlikely(strlen(c) > COLOR_STRING_LEN))
		KERNEL$SUICIDE("set_color_print: SHOT OUT OF STRING, LEN %ld", (long)strlen(c));
	for (x = c; *x; x++) put_char(ctx, *x, 1);

}

/* returns: 1 --- needs sync, 2 --- needs larger buffer, 0 --- ok, < 0 --- error */

static int parse_line(CTX *ctx, int sync)
{
	int glob_last = 0;
	int tokgroup;
	__const__ char *p;
	int fr;
	/*int stde;*/

	ctx->argv_buffer_pos = 0;
	ctx->command_buffer_pos = 0;
	p = ctx->pos;
	goto next_tok;

	for (; p < ctx->end; p++) {
		if (__likely(tokgroup != 0)) {
			unsigned char c;
			putchr:
			c = *p;
			if (__unlikely(c == '"') || __unlikely(c == '\'')) {
				next_u:
				p++;
				next_i:
				if (p >= ctx->end) break;
				if (__unlikely(*p == c)) continue;
				if (__unlikely(*p == '%') && __likely(c == '\'')) {
					char *v;
					v = find_var_name(ctx, &p, ctx->end, sync, &fr);
					if (__likely(!v)) {
						int i;
						for (i = 1; i < ctx->rq->narg; i++) {
							__const__ char *p;
							if (i != 1) {
								put_char(ctx, 0, sync);
								new_arg(ctx, glob_last, sync);
							}
							p = ctx->rq->arg[i];
							while (*p) {
								put_char(ctx, *p, sync);
								p++;
							}
						}
					} else if (__unlikely(v == (void *)1)) {
						return 1;
					} else {
						char *x;
						for (x = v; *x; x++) put_char(ctx, *x, sync);
						if (__unlikely(fr)) free(v);
					}
					goto next_i;
				}
				put_char(ctx, *p, sync);
				goto next_u;
			}
			if (__likely(tokgroup == tokgroups[c])) {
				if (__unlikely(c == '%')) {
					char *v;
					int newtok;
					v = find_var_name(ctx, &p, ctx->end, sync, &fr);
					newtok = 0;
					if (__unlikely(!v)) {
						int i;
						int sp = 0;
						for (i = 1; i < ctx->rq->narg; i++) {
							__const__ char *p;
							if (i != 1) {
								if (nonempty_last(ctx)) {
									newtok = 1;
								}
							}
							p = ctx->rq->arg[i];
							while (*p) {
								if ((unsigned char)*p > ' ') {
									sp = 1;
									if (__unlikely(newtok)) {
										put_char(ctx, 0, sync);
										new_arg(ctx, glob_last, sync);
										newtok = 0;
									}
									put_char(ctx, *p, sync);
								} else if (nonempty_last(ctx)) {
									newtok = 1;
								}
								p++;
							}
						}
						if (!sp && !nonempty_last(ctx) && !tokgroups[(unsigned char)*p]) ctx->argv_buffer_pos--;
					} else if (__unlikely(v == (void *)1)) {
						return 1;
					} else {
						char *x;
						int sp = 0;
						for (x = v; *x; ) {
							if ((unsigned char)*x > ' ') {
								sp = 1;
								if (__unlikely(newtok)) {
									put_char(ctx, 0, sync);
									new_arg(ctx, glob_last, sync);
									newtok = 0;
								}
								put_char(ctx, *x, sync);
							} else if (nonempty_last(ctx)) {
								newtok = 1;
							}
							x++;
						}
						if (!sp && !nonempty_last(ctx) && !tokgroups[(unsigned char)*p]) ctx->argv_buffer_pos--;
						if (fr) free(v);
					}
					if (__unlikely(newtok)) {
						put_char(ctx, 0, sync);
						tokgroup = 0;
					}
					p--;
					continue;
				}
				/*if (__unlikely(c == '>') || __unlikely(c == '<')) {
					char *s;
					stde = 0;
					redir:
					if (nonempty_last(ctx)) {
						put_char(ctx, 0, sync);
						new_arg(ctx, glob_last, sync);
					}
					if (__unlikely(c == '<')) s = "/MAP:STDIN=";
					else if (__likely(p < ctx->end - 1) && __unlikely(p[1] == '>')) {
						s = __likely(!stde) ? "/MAP:STDOUT=" : "/MAP:STDERR=";
						p++;
					} else {
						s = __likely(!stde) ? "/MAPOVERWRITE:STDOUT=" : "/MAPOVERWRITE:STDERR=";
					}
					for (; *s; s++) put_char(ctx, *s, sync);
					while (__likely(p < ctx->end - 1) && __unlikely(!tokgroups[(unsigned char)p[1]])) p++;
					continue;
				} else if (__unlikely(c == '2') && __likely(p < ctx->end - 1) && __unlikely(p[1] == '>')) {
					c = *++p;
					stde = 1;
					goto redir;
				}*/
				if (__unlikely(c == '=')) {
					__const__ char *e;
					char *v, *x;
					if (test_command(ctx, "LET", 2)) {
						if (!sync) return 1;
						put_char(ctx, '=', sync);
						p++;
						put_last_expr:
						e = find_keyword(p, ctx->end, NULL, 0);
						v = EVAL_EXPRESSION(ctx, p, e, &fr);
						for (x = v; *x; x++) put_char(ctx, *x, 1);
						if (__likely(fr)) free(v);
						glob_last = 0;
						p = e - 1;
						continue;
					}
					if (__unlikely(test_command(ctx, "FOR", 2))) {
						e = find_keyword(p, ctx->end, "TO", 1);
						if (__unlikely(!e)) goto no_special_parse;
						if (!sync) return 1;
						glob_last = 0;
						put_char(ctx, '=', sync);
						p++;
						v = EVAL_EXPRESSION(ctx, p, e, &fr);
						for (x = v; *x; x++) put_char(ctx, *x, 1);
						if (__likely(fr)) free(v);
						put_char(ctx, 0, 1);
						new_arg(ctx, glob_last, 1);
						put_char(ctx, 'T', 1);
						put_char(ctx, 'O', 1);
						put_char(ctx, 0, 1);
						new_arg(ctx, glob_last, 1);
						p = e + 2;
						e = find_keyword(p, ctx->end, "STEP", 1);
						if (e) {
							v = EVAL_EXPRESSION(ctx, p, e, &fr);
							for (x = v; *x; x++) put_char(ctx, *x, 1);
							if (__likely(fr)) free(v);
							put_char(ctx, 0, 1);
							new_arg(ctx, glob_last, 1);
							put_char(ctx, 'S', 1);
							put_char(ctx, 'T', 1);
							put_char(ctx, 'E', 1);
							put_char(ctx, 'P', 1);
							put_char(ctx, 0, 1);
							new_arg(ctx, glob_last, 1);
							p = e + 4;
						}
						goto put_last_expr;
					}
				}
				no_special_parse:
				put_char(ctx, c, sync);
				if (__unlikely(GLOBCHAR(c))) {
					if (!sync) return 1;
					glob_last = 1;
				}
				continue;
			}
			put_char(ctx, 0, sync);
		}
		next_tok:
		tokgroup = tokgroups[(unsigned char)*p];
		switch (tokgroup) {
			case 0:	continue;
			case 2: p++; goto ret0;
		}
		if (__likely(p + 3 < ctx->end) && p[0] == '\'' && p[1] == '%' && p[2] == '@' && p[3] == '\'' && ctx->rq->narg <= 1) {
			p += 3;
			continue;
		}
		new_arg(ctx, glob_last, sync);
		{
			__const__ char *e;
			char *v, *x;
			int col_shift, col_max, tn;
			long n;
			if (test_command(ctx, "IF", 2)) {
				if (!sync) return 1;
				e = find_keyword(p, ctx->end, "THEN", 1);
				if (__unlikely(!e)) {
					_snprintf(ctx->return_msg, __MAX_STR_LEN, "IF: WITHOUT THEN");
					ctx->return_val = -EBADSYN;
					ctx->internal_flags |= SHELL_THREAD_ERROR;
					goto ret0;
				}
				v = EVAL_EXPRESSION(ctx, p, e, &fr);
				for (x = v; *x; x++) put_char(ctx, *x, 1);
				if (__likely(fr)) free(v);
				p = e + 4;
				goto ret0;
			}
			if (__unlikely(test_command(ctx, "REM", 2))) {
				p = find_keyword(p, ctx->end, NULL, 0);
				goto ret0;
			}
			if (__unlikely(test_command(ctx, "PRINT", 2))) {
				char no_nl = 0;
				shell_color_t old_color = ctx->color;
				shell_color_t old_modified_color = ctx->modified_color;
				__const__ char *cmdend, *tok;
				if (!sync) return 1;
				cmdend = find_keyword(p, ctx->end, NULL, 0);
				parse_next:
				while (p < cmdend && !tokgroups[(unsigned char)*p]) p++;
				e = find_keyword(p, ctx->end, ",", 0);
				if (!e) e = cmdend;
				if (p == e) {
					if (e == cmdend) {
						no_nl = 1;
					}
					goto print_next;
				}
				tok = p;
				while (tok < e) {
					unsigned char ch = __upcasechr(*tok);
					if (__likely(ch < 'A') || __unlikely(ch > 'Z')) break;
					tok++;
				}
				if (tok - p == 2 && !_memcasecmp(p, "AT", 2)) {
					p += 2;
					put_char(ctx, 27, 1);
					put_char(ctx, '[', 1);
					if (__unlikely(e >= cmdend)) {
						print_bad_number:
						_snprintf(ctx->return_msg, __MAX_STR_LEN, "BAD NUMBER");
						ctx->return_val = -EBADSYN;
						ctx->internal_flags |= SHELL_THREAD_ERROR;
						goto ret0;
					}
					v = EVAL_EXPRESSION(ctx, p, e, &fr);

					for (x = v; *x; x++) put_char(ctx, *x, 1);
					tn = __get_number(v, strchr(v, 0), 0, (long *)(void *)&KERNEL$LIST_END);
					if (__likely(fr)) free(v);
					if (__unlikely(tn)) goto print_bad_number;
					put_char(ctx, ';', 1);
					p = e + 1;
					e = find_keyword(p, ctx->end, ",", 0);
					if (!e) e = cmdend;
					v = EVAL_EXPRESSION(ctx, p, e, &fr);

					for (x = v; *x; x++) put_char(ctx, *x, 1);
					tn = __get_number(v, strchr(v, 0), 0, (long *)(void *)&KERNEL$LIST_END);
					if (__likely(fr)) free(v);
					if (__unlikely(tn)) goto print_bad_number;
					put_char(ctx, 'H', 1);
					goto print_next;
				}
				if (tok - p == 3 && !_memcasecmp(p, "INK", 3)) {
					p += 3;
					col_shift = 0;
					col_max = 7;
					eval_color:
					v = EVAL_EXPRESSION(ctx, p, e, &fr);
					tn = __get_number(v, strchr(v, 0), 0, &n);
					if (__likely(fr)) free(v);
					if (__unlikely(tn) || __unlikely((unsigned long)n > col_max)) goto print_bad_number;
					set_color_print(ctx, (ctx->color & ~(col_max << col_shift)) | (n << col_shift), col_max << col_shift);
					goto print_next;
				}
				if (tok - p == 5 && !_memcasecmp(p, "PAPER", 5)) {
					p += 5;
					col_shift = 3;
					col_max = 7;
					goto eval_color;
				}
				if (tok - p == 6 && !_memcasecmp(p, "BRIGHT", 6)) {
					p += 6;
					col_shift = 6;
					col_max = 1;
					goto eval_color;
				}
				if (tok - p == 5 && !_memcasecmp(p, "FLASH", 5)) {
					p += 5;
					col_shift = 7;
					col_max = 1;
					goto eval_color;
				}
				if (tok - p == 7 && !_memcasecmp(p, "INVERSE", 7)) {
					p += 7;
					col_shift = 8;
					col_max = 1;
					goto eval_color;
				}
				v = EVAL_EXPRESSION(ctx, p, e, &fr);
				for (x = v; *x; x++) put_char(ctx, *x, 1);
				if (__likely(fr)) free(v);
				print_next:
				if (e < cmdend) {
					p = e + 1;
					goto parse_next;
				}
				if (old_modified_color == ctx->modified_color) {
					set_color_print(ctx, old_color, 0);
				} else {
					ctx->color = old_color;
					ctx->modified_color = old_modified_color;
					set_color_print(ctx, old_color, 0x8000);
				}
				if (!no_nl) put_char(ctx, '\n', 1);
				p = cmdend;
				goto ret0;
			}
			if (__unlikely(test_command(ctx, "INK", 2))) {
				col_shift = 0;
				col_max = 7;
				color_command:
				e = find_keyword(p, ctx->end, NULL, 0);
				v = EVAL_EXPRESSION(ctx, p, e, &fr);
				tn = __get_number(v, strchr(v, 0), 0, &n);
				if (__likely(fr)) free(v);
				if (__unlikely(tn) || (unsigned long)n > col_max) goto print_bad_number;
				set_color_print(ctx, (ctx->color & ~(col_max << col_shift)) | (n << col_shift), col_max << col_shift);
				p = e;
				goto ret0;
			}
			if (__unlikely(test_command(ctx, "PAPER", 2))) {
				col_shift = 3;
				col_max = 7;
				goto color_command;
			}
			if (__unlikely(test_command(ctx, "BRIGHT", 2))) {
				col_shift = 6;
				col_max = 1;
				goto color_command;
			}
			if (__unlikely(test_command(ctx, "FLASH", 2))) {
				col_shift = 7;
				col_max = 1;
				goto color_command;
			}
			if (__unlikely(test_command(ctx, "INVERSE", 2))) {
				col_shift = 8;
				col_max = 1;
				goto color_command;
			}
		}
		goto putchr;
	}
	ret0:
	put_char(ctx, 0, sync);
	new_arg(ctx, glob_last, sync);
	if (__likely(ctx->command_buffer_pos <= __alloc_size(ctx->command_buffer)) && __likely(ctx->argv_buffer_pos <= argv_allocated(ctx->argv_buffer))) {
		ctx->argv_buffer[ctx->argv_buffer_pos - 1] = NULL;
		ctx->argv = ctx->argv_buffer;
		ctx->pos = p;
		return 0;
	} else {
		if (sync) return -ENOMEM;
		else return 2;
	}
}

static long parse_thread_main(void *ctx_)
{
	CTX *ctx = ctx_;
	int r;
	RAISE_SPL(SPL_SHELL);
	r = parse_line(ctx, 1);
	if (__unlikely(r)) {
		if (__likely(r < 0)) {
			_snprintf(ctx->return_msg, __MAX_STR_LEN, "CAN'T PARSE: %s", strerror(-r));
			ctx->return_val = r;
			ctx->internal_flags |= SHELL_THREAD_ERROR;
			return 0;
		} else KERNEL$SUICIDE("parse_thread_main: parse_line RETURNED %d", r);
	}
	return 0;
}

DECL_IOCALL(SHELL$CREATE_CONTEXT, SPL_SHELL, SHCCRQ)
{
	RQ->mrq.fn = &SHELL_CONTEXT_ALLOCATED;
	RQ->mrq.size = sizeof(CTX);
	RETURN_IORQ_CANCELABLE(&RQ->mrq, &KERNEL$UNIVERSAL_MALLOC, RQ);
}

DECL_AST(SHELL_CONTEXT_ALLOCATED, SPL_SHELL, MALLOC_REQUEST)
{
	SHCCRQ *rq = GET_STRUCT(RQ, SHCCRQ, mrq);
	CTX *ctx;
	int i;
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, rq);
	if (RQ->status < 0) {
		rq->status = RQ->status;
		RETURN_AST(rq);
	}
	ctx = rq->ctx = RQ->ptr;
	memset(rq->ctx, 0, sizeof(CTX));

	ctx->ctty_in = -1;
	ctx->ctty_out = -1;
	ctx->ctty_err = -1;
	ctx->ctty_in_t = 0;
	ctx->ctty_out_t = 0;
	ctx->ctty_err_t = 0;
	ctx->color = 7;
	ctx->modified_color = 0;
	ctx->ctty_in_orig = -1;
	ctx->ctty_out_orig = -1;
	ctx->ctty_err_orig = -1;

	for (i = 0; i < VAR_HASH_SIZE; i++) INIT_XLIST(&ctx->var_hash[i]);

	rq->status = 0;
	RETURN_AST(rq);
}

void SHELL$DESTROY_CONTEXT(CTX *ctx)
{
	int i;
	for (i = 0; i < VAR_HASH_SIZE; i++) while (!XLIST_EMPTY(&ctx->var_hash[i])) {
		struct var *v = LIST_STRUCT(ctx->var_hash[i].next, struct var, hash);
		del_var(v);
	}
	SHELL$SET_TTY(ctx, -1, -1, -1, 0, 0, 0, 0);
	SHELL$SET_CWD(ctx, NULL, 0);
	KERNEL$UNIVERSAL_FREE(ctx->command_buffer);
	KERNEL$UNIVERSAL_FREE(ctx->argv_buffer);
	for (i = 0; i < N_DIRECT_HISTORY; i++) KERNEL$UNIVERSAL_FREE(ctx->history[i]);
	KERNEL$UNIVERSAL_FREE(ctx);
}

void SHELL$SET_TTY(CTX *ctx, int std_in, int std_out, int std_err, char std_in_tty, char std_out_tty, char std_err_tty, char no_close)
{
	if (ctx->ctty_in != -1 && ctx->ctty_in != ctx->ctty_in_orig) KERNEL$FAST_CLOSE(ctx->ctty_in);
	if (ctx->ctty_out != -1 && ctx->ctty_out != ctx->ctty_out_orig) KERNEL$FAST_CLOSE(ctx->ctty_out);
	if (ctx->ctty_err != -1 && ctx->ctty_err != ctx->ctty_err_orig) KERNEL$FAST_CLOSE(ctx->ctty_err);
	ctx->ctty_in = std_in;
	ctx->ctty_out = std_out;
	ctx->ctty_err = std_err;
	ctx->ctty_in_t = std_in_tty;
	ctx->ctty_out_t = std_out_tty;
	ctx->ctty_err_t = std_err_tty;
	if (no_close) {
		ctx->ctty_in_orig = std_in;
		ctx->ctty_out_orig = std_out;
		ctx->ctty_err_orig = std_err;
	} else {
		ctx->ctty_in_orig = -1;
		ctx->ctty_out_orig = -1;
		ctx->ctty_err_orig = -1;
	}
}

void SHELL$SET_CWD(CTX *ctx, CWD *cwd, int no_free)
{
	if (ctx->cwd != NULL && ctx->cwd != ctx->cwd_orig) KERNEL$FREE_CWD(ctx->cwd);
	ctx->cwd = cwd;
	if (no_free) ctx->cwd_orig = cwd;
	else ctx->cwd_orig = NULL;
}

DECL_IOCALL(SHELL$RUN_COMMANDS, SPL_SHELL, SHRCRQ)
{
	CTX *ctx = RQ->ctx;
	/* int x;
	for (x = 0; x < 100000000; x++) ; */
	if ((RQ->link = ctx->rq)) {
		RQ->link->pos = ctx->pos;
		memcpy(RQ->link->stack, ctx->stack, sizeof ctx->stack);
	} else {
		*ctx->return_msg = 0;
		ctx->return_val = 0;
		ctx->return_ignore_err = 0;
	}
	INIT_XLIST(&RQ->local);
	ctx->rq = RQ;
	memset(ctx->stack, 0, sizeof ctx->stack);
	ctx->pos = ctx->beg = RQ->ptr;
	ctx->end = RQ->ptr + RQ->len;
	ctx->internal_flags = 0;
	RETURN_TO_SHELL(ctx);
}

/* This will take next shell command and try to execute it */

extern AST_STUB CONT_EXEC;

DECL_AST(SHELL$CONT_EXEC, SPL_SHELL, CTX)
{
	RQ->u.rq.fn = CONT_EXEC;
	if (__unlikely(KERNEL$LOCKUP_LEVEL >= LOCKUP_LEVEL_ALL_IORQS)) {
		RQ->u.rq.status = RQS_PROCESSING;
		WQ_WAIT(&KERNEL$LOCKUP_EVENTS, &RQ->u.rq, KERNEL$SUCCESS);
		RETURN;
	}
	RETURN_AST(&RQ->u.rq);
}

DECL_AST(CONT_EXEC, SPL_SHELL, CTX)
{
	int r;
	if (__unlikely(RQ->internal_flags & SHELL_IN_THREAD)) {
		RQ->internal_flags &= ~SHELL_IN_THREAD;
		if (RQ->internal_flags & SHELL_THREAD_ERROR) {
			RQ->internal_flags &= ~SHELL_THREAD_ERROR;
			RQ->internal_flags |= SHELL_DO_EXIT;
			goto print_error;
		}
		goto done_parse;
	}
	if (__unlikely(RQ->return_val < 0) && __unlikely(*RQ->return_msg) && __unlikely(!RQ->return_ignore_err)) goto print_error;
	no_print_error:
	if (__unlikely(RQ->internal_flags & SHELL_DO_EXIT)) {
		RQ->internal_flags &= ~SHELL_DO_EXIT;
		goto exit_command_procedure;
	}
	if (__unlikely(RQ->pos >= RQ->end)) goto exit_command_procedure;

	r = parse_line(RQ, 0);
	if (__unlikely(r)) {
		if (__unlikely(r < 0)) {
			_snprintf(RQ->return_msg, __MAX_STR_LEN, "CAN'T PARSE: %s", strerror(-r));
			RQ->return_val = r;
			CALL_SHELL_FN(RQ, &SHELL_EXIT);
		} else if (r == 2) {
			goto alloc_more;
		} else if (__likely(r == 1)) {
			RQ->rq->trq.fn = SHELL_DONE_THREAD;
			RQ->rq->trq.thread_main = parse_thread_main;
			RQ->rq->trq.p = RQ;
			RQ->rq->trq.error = NULL;
			RQ->rq->trq.cwd = RQ->cwd;
			RQ->rq->trq.std_in = RQ->ctty_in;
			RQ->rq->trq.std_out = RQ->ctty_out;
			RQ->rq->trq.std_err = RQ->ctty_err;
			RQ->rq->trq.dlrq = NULL;
			RQ->rq->trq.thread = NULL;
			RQ->rq->trq.spawned = 0;
			RQ->internal_flags |= SHELL_IN_THREAD;
			RETURN_IORQ_CANCELABLE(&RQ->rq->trq, KERNEL$THREAD, RQ->rq);
		} else KERNEL$SUICIDE("SHELL$CONT_EXEC: parse_line RETURNED %d", r);
	}

	done_parse:
	CALL_SHELL_FN(RQ, &SHELL$DO_PARSED_COMMAND);

	alloc_more:
	if (__likely(RQ->command_buffer_pos > __alloc_size(RQ->command_buffer))) {
		RQ->u.mrq.size = RQ->command_buffer_pos;
		RQ->u.mrq.fn = &SHELL_COMMAND_BUFFER_ALLOCATED;
		KERNEL$UNIVERSAL_FREE(RQ->command_buffer);
		RQ->command_buffer = NULL;
		RETURN_IORQ_CANCELABLE(&RQ->u.mrq, &KERNEL$UNIVERSAL_MALLOC, RQ->rq);
	}
	if (__likely(RQ->argv_buffer_pos > argv_allocated(RQ->argv_buffer))) {
		RQ->u.mrq.size = RQ->argv_buffer_pos * sizeof(char *);
		RQ->u.mrq.fn = &SHELL_ARGV_BUFFER_ALLOCATED;
		KERNEL$UNIVERSAL_FREE(RQ->argv_buffer);
		RQ->argv_buffer = NULL;
		RETURN_IORQ_CANCELABLE(&RQ->u.mrq, &KERNEL$UNIVERSAL_MALLOC, RQ->rq);
	}
	KERNEL$SUICIDE("SHELL$CONT_EXEC: UNEXPECTED 2 FROM parse_line");

	print_error:
	{
		struct var *v;
		__const__ char *s = "@SHELL$REPORT_ERROR";
		if ((v = find_var(RQ, s, s + strlen(s), 0)) && __likely(v->name[v->namel + 1] == '0') && __likely(!v->name[v->namel + 2])) {
			RQ->return_ignore_err = 1;
			goto no_print_error;
		}
	}
	if (__unlikely(RQ->ctty_err < 0)) {
		__critical_printf("%s\n", RQ->return_msg);
		RQ->return_ignore_err = 2;
		RETURN_TO_SHELL(RQ);
	}
	RQ->return_msg[RQ->itmp1 = strlen(RQ->return_msg)] = '\n';
	if (__unlikely(RQ->itmp1 >= __MAX_STR_LEN))
		KERNEL$SUICIDE("SHELL$CONT_EXEC: UNTERMINATED RETURN CODE, LEN %d", RQ->itmp1);
	memmove(RQ->return_msg + ERR_PREFIX_LEN + COLOR_STRING_LEN + 1, RQ->return_msg, RQ->itmp1 + 1);
	memcpy(&RQ->return_msg[0], ERR_PREFIX, ERR_PREFIX_LEN);
	set_color(RQ, RQ->color, 0x8000, &RQ->return_msg[ERR_PREFIX_LEN]);
	RQ->itmp2 = strlen(RQ->return_msg);
	memmove(&RQ->return_msg[RQ->itmp2], RQ->return_msg + ERR_PREFIX_LEN + COLOR_STRING_LEN + 1, RQ->itmp1 + 1);
	RQ->u.siorq.fn = &SHELL_ERROR_MSG_WRITTEN;
	RQ->u.siorq.h = RQ->ctty_err;
	RQ->u.siorq.v.ptr = (unsigned long)RQ->return_msg;
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.v.len = RQ->itmp2 + RQ->itmp1 + 1;
	if (__unlikely(RQ->u.siorq.v.len >= sizeof(RQ->return_msg)))
		KERNEL$SUICIDE("SHELL$CONT_EXEC: TOO LONG ERROR STRING: %ld", RQ->u.siorq.v.len);
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, &KERNEL$WRITE, RQ->rq);

	exit_command_procedure:
	CALL_SHELL_FN(RQ, &SHELL_EXIT);
}

DECL_AST(SHELL$DO_PARSED_COMMAND, SPL_SHELL, CTX)
{
	unsigned hash;
	__const__ char *q;
	__const__ CMD *cmd;

	if (__unlikely(!RQ->argv[0])) RETURN_TO_SHELL(RQ);

	if (__likely(RQ->argv[0][0] >= '0') && __unlikely(RQ->argv[0][0] <= '9')) {
		unsigned i;
		for (i = 1; RQ->argv[0][i]; i++) if (__unlikely(!is_var_char(RQ->argv[0][i]))) goto no_label;
		RQ->argv++;
		if (__unlikely(!RQ->argv[0])) RETURN_TO_SHELL(RQ);
	}
	no_label:

	if (__unlikely(RQ->argv[0][0] == '#')) RETURN_TO_SHELL(RQ);

	hash = 0;
	q = RQ->argv[0];
	quickcasehash(q, *q, hash);
	if (__likely((cmd = FIND_CMD(RQ->argv[0])) != NULL)) {
		process_cmd:
		if (__likely(!(cmd->flags & CMDF_DONT_CLEAR_STATUS))) {
			*RQ->return_msg = 0;
			RQ->return_val = 0;
			RQ->return_ignore_err = 0;
		}
		if (__likely(!(cmd->flags & CMDF_SYNC_COMMAND))) {
			CALL_SHELL_FN(RQ, cmd->u.command);
		} else {
			RQ->vtmp1 = cmd->u.thread;
			RQ->rq->trq.fn = SHELL_DONE_THREAD;
			RQ->rq->trq.thread_main = SHELL_COMMAND_THREAD;
			RQ->rq->trq.p = RQ;
			RQ->rq->trq.error = NULL;
			RQ->rq->trq.cwd = RQ->cwd;
			RQ->rq->trq.std_in = RQ->ctty_in;
			RQ->rq->trq.std_out = RQ->ctty_out;
			RQ->rq->trq.std_err = RQ->ctty_err;
			RQ->rq->trq.dlrq = NULL;
			RQ->rq->trq.thread = NULL;
			RQ->rq->trq.spawned = 0;
			RETURN_IORQ_CANCELABLE(&RQ->rq->trq, KERNEL$THREAD, RQ->rq);
		}
	}
	cmd = &unknown_command;
	goto process_cmd;
}

static long SHELL_COMMAND_THREAD(void *ctx_)
{
	CTX *ctx = ctx_;
	RAISE_SPL(SPL_SHELL);
	((cmdthread_t)ctx->vtmp1)(ctx);
	return 0;
}

DECL_AST(SHELL_DONE_THREAD, SPL_SHELL, THREAD_RQ)
{
	SHRCRQ *r = GET_STRUCT(RQ, SHRCRQ, trq);
	CTX *ctx = r->ctx;
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, ctx->rq);
	if (__unlikely(RQ->status != 0)) {
		if (RQ->status != -EINTR) _snprintf(ctx->return_msg, __MAX_STR_LEN, "CAN'T SPAWN %s THREAD: %s", ctx->internal_flags & SHELL_IN_THREAD ? "PARSE" : "COMMAND", strerror(-RQ->status));
		ctx->return_val = RQ->status;
		ctx->internal_flags |= SHELL_THREAD_ERROR;
	}
	RETURN_TO_SHELL(r->ctx);
}

DECL_AST(SHELL_ERROR_MSG_WRITTEN, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
	if (RQ->u.siorq.v.len && RQ->u.siorq.status > 0) {
		RQ->u.siorq.progress = 0;
		RETURN_IORQ_CANCELABLE(&RQ->u.siorq, &KERNEL$WRITE, RQ->rq);
	}
	memmove(RQ->return_msg, RQ->return_msg + RQ->itmp2, RQ->itmp1 + 1);
	RQ->return_msg[RQ->itmp1] = 0;
	if (RQ->u.siorq.status <= 0) {
		__critical_printf("%s\n", RQ->return_msg);
		if (!(RQ->return_val = RQ->u.siorq.status)) RQ->return_val = -EIO, _snprintf(RQ->return_msg, __MAX_STR_LEN, "TTY WRITE FAILED: 0 BYTES WROTE");
		else _snprintf(RQ->return_msg, __MAX_STR_LEN, "TTY WRITE FAILED: %s (%s)", strerror(-RQ->return_val), KERNEL$HANDLE_PATH(RQ->ctty_err));
		CALL_SHELL_FN(RQ, &SHELL_EXIT);
	}
	RQ->return_ignore_err = 2;
	RETURN_TO_SHELL(RQ);
}

DECL_AST(SHELL_EXIT, SPL_SHELL, CTX)
{
	SHRCRQ *rq = RQ->rq;
	struct var *v, *vv;
	unsigned i;
	while (!XLIST_EMPTY(&rq->local)) {
		v = LIST_STRUCT(rq->local.next, struct var, hash);
		vv = find_var(RQ, v->name, v->name + v->namel, 1);
		if (vv) del_var(vv);
		DEL_FROM_LIST(&v->hash);
		if (v->name[v->namel]) add_var(RQ, v);
		else free_var(v);
	}
	for (i = 0; i < VAR_HASH_SIZE; i++) XLIST_FOR_EACH(v, &RQ->var_hash[i], struct var, hash) {
		if (v->for_ptr > RQ->beg && v->for_ptr <= RQ->end) v->for_ptr = NULL;
	}
	if (RQ->return_ignore_err == 1) RQ->return_ignore_err = 0;
	rq->status = RQ->return_val;
	rq->error_msg = RQ->return_msg;
	RQ->rq = NULL;
	if (rq->link) {
		RQ->rq = rq->link;
		RQ->beg = rq->link->ptr;
		RQ->end = rq->link->ptr + rq->link->len;
		RQ->pos = rq->link->pos;
		memcpy(RQ->stack, rq->link->stack, sizeof RQ->stack);
	}
	RETURN_AST(rq);
}

DECL_AST(SHELL_COMMAND_BUFFER_ALLOCATED, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
	if (RQ->u.mrq.status < 0) {
		if (RQ->u.mrq.status != -EINTR) _snprintf(RQ->return_msg, __MAX_STR_LEN, "CAN'T ALLOCATE COMMAND BUFFER: %s", strerror(-RQ->u.mrq.status));
		RQ->return_val = RQ->u.mrq.status;
		CALL_SHELL_FN(RQ, SHELL_EXIT);
	}
	RQ->command_buffer = RQ->u.mrq.ptr;
	RETURN_TO_SHELL(RQ);
}

DECL_AST(SHELL_ARGV_BUFFER_ALLOCATED, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
	if (RQ->u.mrq.status < 0) {
		if (RQ->u.mrq.status != -EINTR) _snprintf(RQ->return_msg, __MAX_STR_LEN, "CAN'T ALLOCATE ARGV BUFFER: %s", strerror(-RQ->u.mrq.status));
		RQ->return_val = RQ->u.mrq.status;
		CALL_SHELL_FN(RQ, SHELL_EXIT);
	}
	RQ->argv_buffer = RQ->u.mrq.ptr;
	RETURN_TO_SHELL(RQ);
}

__const__ char *FIND_LABEL(int brk, __const__ char *start, __const__ char *end, __const__ char *label)
{
	unsigned char c;
	for (; start < end; start++) {
		c = *start;
		if (__unlikely(!tokgroups[c])) continue;
		if (__unlikely(c == '"') || __unlikely(c =='\'')) do if (++start >= end) return NULL; while (*start != c);
		else if (__unlikely(brk) && __likely(c >= '0') && __unlikely(c <= '9')) {
			__const__ char *l;
			for (l = start + 1; l < end && is_var_char(*l); l++) ;
			if (__likely(l < end) && __unlikely(tokgroups[(unsigned char)*l] == 1)) goto no_label;
			if (strlen(label) == l - start && !_memcasecmp(start, label, l - start)) return start;
			no_label:
			start = l - 1;
		}
		brk = tokgroups[c] == 2;
	}
	return NULL;
}

__const__ char *FIND_COMMAND(int brk, __const__ char *start, __const__ char *end, __const__ char *cmd, __const__ char *arg)
{
	unsigned char c;
	size_t str_len_cmd = strlen(cmd);
	for (; start < end; start++) {
		c = *start;
		if (__unlikely(!tokgroups[c])) continue;
		if (__unlikely(c == '"') || __unlikely(c =='\'')) {
			do if (++start >= end) return NULL; while (*start != c);
			goto cont;
		}
		if (__unlikely(brk) && __likely(c >= '0') && __unlikely(c <= '9')) {
			for (start++; start < end && is_var_char(*start); start++) ;
			if (__likely(start < end) && tokgroups[(unsigned char)*start] == 1) brk = 0;
			while (start < end && !tokgroups[(unsigned char)*start]) start++;
			if (__unlikely(start >= end)) return NULL;
			c = *start;
		}
		if (__unlikely(brk)) {
			if (__likely(end - start >= str_len_cmd) && __unlikely(!_memcasecmp(start, cmd, str_len_cmd)) && (__unlikely(start + str_len_cmd == end) || __likely(tokgroups[(unsigned char)start[str_len_cmd]] != 1))) {
				if (__likely(arg != NULL)) {
					size_t str_len_arg = strlen(arg);
					__const__ char *a = start + str_len_cmd;
					while (a < end && !tokgroups[(unsigned char)*a]) a++;
					if (__likely(end - a >= str_len_arg) && __unlikely(!_memcasecmp(a, arg, str_len_arg)) && (__unlikely(a + str_len_arg == end) || __likely(tokgroups[(unsigned char)a[str_len_arg]] != 1))) goto ok_arg;
					goto cont;
				}
				ok_arg:
				return start;
			}
		}
		cont:
		brk = tokgroups[c] == 2;
	}
	return NULL;
}

__const__ char *NEXT_LINE(__const__ char *start, __const__ char *pos, __const__ char *end, int line)
{
	if (__likely(pos > start) && (pos[-1] == '\n' || pos[-1] == '\r' || (__unlikely(!line) && __unlikely(pos[-1] == ';')))) return pos;
	for (; pos < end; pos++) {
		unsigned char c = *pos;
		if (__unlikely(c == '"') || __unlikely(c =='\'')) do if (++pos >= end) return end; while (*pos != c);
		if (__unlikely(c == '\n') || __unlikely(c == '\r') || (__unlikely(!line) && __unlikely(c == ';'))) return pos + 1;
	}
	return end;
}

extern AST_STUB SHELL_UNKNOWN_OPEN_1;
extern AST_STUB SHELL_UNKNOWN_OPEN_2;
extern AST_STUB SHELL_REALLY_UNKNOWN_COMMAND;
extern AST_STUB SHELL_SPAWN_COMMAND;
extern AST_STUB SHELL_CALL_COMMAND;

DECL_AST(SHELL_UNKNOWN_COMMAND, SPL_SHELL, CTX)
{
	int l = strlen(RQ->argv[0]);
	RQ->itmp1 = !strchr(RQ->argv[0], ':') && !strchr(RQ->argv[0], '/');
	RQ->itmp2 = l < 4 || RQ->argv[0][l - 4] != '.' || __upcasechr(RQ->argv[0][l - 3]) != 'C' || __upcasechr(RQ->argv[0][l - 2]) != 'M' || __upcasechr(RQ->argv[0][l - 1]) != 'D';
	RQ->itmp3 = l < 4 || RQ->argv[0][l - 4] != '.' || __upcasechr(RQ->argv[0][l - 3]) != 'E' || __upcasechr(RQ->argv[0][l - 2]) != 'X' || __upcasechr(RQ->argv[0][l - 1]) != 'E';
	_snprintf(RQ->scratch_2, SCRATCH_2_LEN, "%s%s%s", RQ->itmp1 ? "PATH.:/" : "", RQ->argv[0], RQ->itmp2 ? ".CMD" : "");
	RQ->u.openrq.fn = SHELL_UNKNOWN_OPEN_1;
	RQ->u.openrq.path = RQ->scratch_2;
	RQ->u.openrq.flags = O_RDONLY | _O_CLOSE;
	RQ->u.openrq.cwd = RQ->cwd;
	RETURN_IORQ_CANCELABLE(&RQ->u.openrq, KERNEL$OPEN, RQ->rq);
}

DECL_AST(SHELL_UNKNOWN_OPEN_1, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
	if (__unlikely(RQ->u.openrq.status < 0)) {
		if (__unlikely(RQ->u.openrq.status == -EINTR)) {
			RQ->return_val = RQ->u.openrq.status;
			RETURN_TO_SHELL(RQ);
		}
		_snprintf(RQ->scratch_2, SCRATCH_2_LEN, "%s%s%s", RQ->itmp1 ? "PATH.:/" : "", RQ->argv[0], RQ->itmp3 ? ".EXE" : "");
		RQ->u.openrq.fn = SHELL_UNKNOWN_OPEN_2;
		RQ->u.openrq.path = RQ->scratch_2;
		RQ->u.openrq.flags = O_RDONLY | _O_CLOSE;
		RQ->u.openrq.cwd = RQ->cwd;
		RETURN_IORQ_CANCELABLE(&RQ->u.openrq, KERNEL$OPEN, RQ->rq);
	}
	RQ->argv[0] = RQ->scratch_2;
	RQ->argv--;
	CALL_SHELL_FN(RQ, SHELL_CALL_COMMAND);
}

DECL_AST(SHELL_UNKNOWN_OPEN_2, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
	if (__unlikely(RQ->u.openrq.status < 0)) {
		if (__unlikely(RQ->u.openrq.status == -EINTR)) {
			RQ->return_val = RQ->u.openrq.status;
			RETURN_TO_SHELL(RQ);
		}
		CALL_SHELL_FN(RQ, SHELL_REALLY_UNKNOWN_COMMAND);
	}
	RQ->argv[0] = RQ->scratch_2;
	RQ->argv--;
	CALL_SHELL_FN(RQ, SHELL_SPAWN_COMMAND);
}

DECL_AST(SHELL_REALLY_UNKNOWN_COMMAND, SPL_SHELL, CTX)
{
	_snprintf(RQ->return_msg, __MAX_STR_LEN, "UNKNOWN COMMAND \"%s\"", RQ->argv[0]);
	RQ->return_val = -ENOENT;
	RETURN_TO_SHELL(RQ);
}

static __const__ CMD unknown_command = {
	NULL, 0, &SHELL_UNKNOWN_COMMAND,
};

DECL_IOCALL(DLL$LOAD, SPL_SHELL, DLINITRQ)
{
	CTX *ctx = NULL;
	if (__unlikely(&ctx->u.rq != NULL) || __unlikely(&ctx->u.mrq != NULL)) goto bads;
	RQ->status = 0;
	RETURN_AST(RQ);
	bads:
	KERNEL$SUICIDE("SHELL: BAD POSITION OF FIELDS IN STRUCT - REQUEST HAS NOT OFFSET 0");
	RETURN;
}

