#ifndef __SHELL_SHELL_H
#define __SHELL_SHELL_H

#include <SPAD/SHELLM.H>
#include <SPAD/LIST.H>

/* SHELL.C */

#define GLOBCHAR(c)	(__unlikely((c) == '*') || __unlikely((c) == '?') || __unlikely((c) == '[') || __unlikely((c) == '~'))

struct var {
	LIST_ENTRY hash;
	XLIST_HEAD for_values;
	__const__ char *for_ptr;
	__s64 for_to;
	__s64 for_step;
	int namel;
	char name[1];
};

struct for_value {
	LIST_ENTRY list;
	char value[1];
};

#define var_reusable(v)		(!(v)->for_ptr)

struct var *find_var(CTX *ctx, __const__ char *n, __const__ char *e, int only_this);
char *find_var_name(CTX *ctx, __const__ char **pp, __const__ char *e, int sync, int *fr);
void del_var(struct var *v);
void free_var(struct var *v);
void init_var(struct var *v);
void add_var(CTX *ctx, struct var *v);
int check_var_name(__const__ char *name, __const__ char *nameend);
__const__ char *find_var_env(CTX *ctx, __const__ char *e);

static __finline__ int is_var_char(char c)
{
	return (c >= '0' && c <= '9') || (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || c == '@' || c == '$' || c == '_';
}

__const__ char *FIND_LABEL(int brk, __const__ char *start, __const__ char *end, __const__ char *label);
__const__ char *FIND_COMMAND(int brk, __const__ char *start, __const__ char *end, __const__ char *cmd, __const__ char *arg);
__const__ char *NEXT_LINE(__const__ char *start, __const__ char *pos, __const__ char *end, int line);

void *liblink(CTX *ctx, char *dll, ...);
void libclose(void *lib);

/* SHELLCMD.C */

CMD *FIND_CMD(__const__ char *name);

/* SHELLSYN.C */

void SHELL_DIR_COMMAND(CTX *ctx);

/* SHELLJOB.C */

extern AST_STUB SHELL_SPAWN_COMMAND;
extern AST_STUB SHELL_FG_COMMAND;
extern AST_STUB SHELL_REMAP_COMMAND;
extern AST_STUB SHELL_JOBS_COMMAND;
extern AST_STUB SHELL_PROC_CTRL_COMMAND;

/* SHELLINT.C */

extern AST_STUB SHELL_INT_COMMAND;

/* SHELLEXP.C */

char *EVAL_EXPRESSION(CTX *ctx, __const__ char *s, __const__ char *e, int *fr);

/* SHELLFN.C */

char *subchr(CTX *ctx, char *str, char *pos);
char *substr(CTX *ctx, char *str, char *from, char *to);
FUNCTION *FIND_FUNCTION(__const__ char *name);
FUNCTION *FIND_OPERATOR(__const__ char *name);
int OPERATOR_LENGTH(__const__ char *s, __const__ char *e);

#endif
