#include <SPAD/SHELL.H>
#include <SPAD/DEV.H>
#include <SPAD/IOCTL.H>
#include <SPAD/SYNC.H>
#include <STDLIB.H>
#include <UNISTD.H>
#include <FCNTL.H>
#include <SIGNAL.H>
#include <PATHS.H>

int main(int argc, char *argv[])
{
	CTX *ctx;
	union {
		SHCCRQ shccrq;
		SHRCRQ shrcrq;
		IOCTLRQ ioctlrq;
	} u;
	int l, i;
	char *a, *aa;
	int noesc = 0;
	int ttys[3];
	char tty_flags[3];
	int null = -1;
	int r;
	while (__likely(argc > 1)) {
		if (!_strcasecmp(argv[1], "/NOESC")) noesc = 1;
		else break;
		argv++;
		argc--;
	}
	for (i = 0; i < 3; i++) {
		tty_flags[i] = 0;
		u.ioctlrq.h = ttys[i] = !i ? KERNEL$STDIN() : i == 1 ? KERNEL$STDOUT() : KERNEL$STDERR();
		if (__unlikely(u.ioctlrq.h < 0)) continue;
		u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
		u.ioctlrq.v.ptr = 0;
		u.ioctlrq.v.len = 0;
		u.ioctlrq.ioctl = IOCTL_TTY_GET_TERM_FLAGS;
		u.ioctlrq.param = 0;
		SYNC_IO(&u.ioctlrq, KERNEL$IOCTL);
		if (__unlikely(u.ioctlrq.status == -EBADF)) {
			if (null < 0) {
				null = open(_PATH_DEVNULL, (!i ? O_RDONLY : O_WRONLY) | _O_NOPOSIX);
			}
			ttys[i] = null;
			tty_flags[0] = 0;
		} else {
			tty_flags[i] = u.ioctlrq.status >= 0;
		}
	}
	if (__likely(KERNEL$IS_INIT_THREAD())) {
		signal(SIGPIPE, SIG_IGN);
		signal(SIGHUP, SIG_IGN);
		signal(SIGINT, SIG_IGN);
		signal(SIGQUIT, SIG_IGN);
	}
	SYNC_IO_CANCELABLE(&u.shccrq, SHELL$CREATE_CONTEXT);
	if (__unlikely(u.shccrq.status < 0)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SHELL: UNABLE TO ALLOCATE SHELL CONTEXT: %s", strerror(-u.shccrq.status));
		r = u.shccrq.status;
		goto ret1;
	}
	u.shrcrq.ctx = ctx = u.shccrq.ctx;
	SHELL$SET_TTY(ctx, ttys[0], ttys[1], ttys[2], tty_flags[0], tty_flags[1], tty_flags[2], 1);
	SHELL$SET_CWD(ctx, KERNEL$CWD(), 1);
	a = NULL;
	if (argc > 1) {
		l = 0;
		for (i = 1; i < argc; i++) l += strlen(argv[i]) * 3 + 1;
		a = __sync_malloc(l);
		if (__unlikely(!a)) {
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "SHELL: CAN'T ALLOCATE MEMORY FOR PARAMETERS");
			r = -ENOMEM;
			goto ret2;
		}
		aa = a;
		for (i = 1; i < argc; i++) {
			if (aa != a) *aa++ = ' ';
			if (__likely(!noesc)) SHELL$ESC_COPY(aa, argv[i]);
			else strcpy(aa, argv[i]);
			aa += strlen(aa);
		}
		u.shrcrq.ptr = a;
		u.shrcrq.len = aa - a;
		if (__unlikely(aa - a > l))
			KERNEL$SUICIDE("SHELL.EXE: SHOT OUT OF MEMORY WHEN ESCAPING: %d > %d", (int)(aa - a), l);
	} else {
		u.shrcrq.ptr = "INT";
		u.shrcrq.len = 3;
	}
	u.shrcrq.arg = NULL;
	u.shrcrq.narg = 0;
	SYNC_IO_CANCELABLE(&u.shrcrq, SHELL$RUN_COMMANDS);
	_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "%s", u.shrcrq.error_msg);
	r = u.shrcrq.status;
	free(a);
	ret2:
	SHELL$DESTROY_CONTEXT(u.shrcrq.ctx);
	ret1:
	if (__unlikely(null >= 0)) close(null);
	return r;
}
