#include <SYS/TYPES.H>
#include <PATHS.H>
#include <SPAD/DEV.H>
#include <SYS/IOCTL.H>
#include <SPAD/IOCTL.H>

#include <SPAD/SHELLM.H>
#include "SHELL.H"

/*
/FG	wait for end (default)
/BG	run in bg
/BGBLOCK
/BGLOSE
/BGOUT
*/

extern AST_STUB SHELL_SPAWN_INCREASED_DETACH_SEQ;
extern AST_STUB SHELL_SPAWN_SPAWNED;
extern AST_STUB SHELL_SPAWN_RETURNED;
extern AST_STUB SHELL_SPAWN_INTR_GOTRESPONSE;
extern AST_STUB SHELL_SPAWN_INTR_WAITED;
extern AST_STUB SHELL_SPAWN_ERASE_TTY;
extern AST_STUB SHELL_SPAWN_RETURN;
extern AST_STUB SHELL_SPAWN_BG;

#define JOB_SUSPEND_MASK	0x003f
#define JOB_SUSPEND_ACTIVE	0x0040

#define JOB_BGFG_MASK		0x0080
#define JOB_FG			0x0000
#define JOB_BG			0x0080

#define JOB_BGMODE_MASK		0x0300
#define JOB_BG_BLOCK		0x0000
#define JOB_BG_LOSE		0x0100
#define JOB_BG_OUT		0x0200
#define JOB_BG_STOP		0x0300

static char *printh(char str[12], int h)
{
	/*
	  this breaks bash -c "(echo aaaaa|cat;echo b)>file"
	  it is not needed at all, because LIBPROC dups the handle, so there
	  will be no leaked handle in case of CTTY or shell exit
	int f = KERNEL$HANDLE_FLAGS(h);
	if (__likely(!(f & _O_PIPE))) {
		char *n = KERNEL$HANDLE_PATH(h);
		if (__likely(n != NULL)) return n;
	}
	*/
	_snprintf(str, 12, ":%u", h);
	return str;
}

static int SET_MAPEXTRA(CTX *ctx, int *jobflags)
{
	char h1[12], h2[12], h3[12];
	*jobflags &= ~PROC_INFO_AUTO_EXIT;
	if (__likely((*jobflags & JOB_BGFG_MASK) == JOB_FG)) {
		if (__unlikely(ctx->ctty_in == -1) || __unlikely(ctx->ctty_out == -1) || __unlikely(ctx->ctty_err == -1)) {
			notty:
			ctx->return_val = -EINVAL;
			_snprintf(ctx->return_msg, __MAX_STR_LEN, "SHELL HAS NO CONTROL TERMINAL");
			return -1;
		}
		if (__unlikely(_snprintf(ctx->scratch_1, SCRATCH_1_LEN, "%sSTDIN=%s%c%sSTDOUT=%s%c%sSTDERR=%s%c", ctx->ctty_in_t ? "=" : "", printh(h1, ctx->ctty_in), 0, ctx->ctty_out_t ? "=" : "", printh(h2, ctx->ctty_out), 0, ctx->ctty_err_t ? "=" : "", printh(h3, ctx->ctty_err), 0) == -1)) {
			longg:
			ctx->return_val = -ENAMETOOLONG;
			_snprintf(ctx->return_msg, __MAX_STR_LEN, "TOO LONG CTTY HANDLE STRING");
			return -1;
		}
		return 0;
	}
	if (__unlikely(!(ctx->ctty_in_t | ctx->ctty_out_t | ctx->ctty_err_t))) *jobflags |= PROC_INFO_AUTO_EXIT;
	if ((*jobflags & JOB_BGMODE_MASK) == JOB_BG_BLOCK || (*jobflags & JOB_BGMODE_MASK) == JOB_BG_STOP) {
		if (__unlikely(_snprintf(ctx->scratch_1, SCRATCH_1_LEN, "STDIN%s%cSTDOUT%s%cSTDERR%s%c", ctx->ctty_in_t ? "="_PATH_DEVBLOCK : "", 0, ctx->ctty_out_t ? "="_PATH_DEVBLOCK : "", 0, ctx->ctty_err_t ? "="_PATH_DEVBLOCK : "", 0) == -1)) goto longg;
		return 0;
	}
	if ((*jobflags & JOB_BGMODE_MASK) == JOB_BG_LOSE) {
		if (__unlikely(_snprintf(ctx->scratch_1, SCRATCH_1_LEN, "STDIN%s%cSTDOUT%s%cSTDERR%s%c", ctx->ctty_in_t ? "="_PATH_DEVBLOCK : "", 0, ctx->ctty_out_t ? "="_PATH_DEVNULLTTY : "", 0, ctx->ctty_err_t ? "="_PATH_DEVNULLTTY : "", 0) == -1)) goto longg;
		return 0;
	}
	if (__likely((*jobflags & JOB_BGMODE_MASK) == JOB_BG_OUT)) {
		if (__unlikely(ctx->ctty_out == -1) || __unlikely(ctx->ctty_err == -1)) goto notty;
		if (__unlikely(_snprintf(ctx->scratch_1, SCRATCH_1_LEN, "STDIN%s%cSTDOUT%s%s%cSTDERR%s%s%c", ctx->ctty_in_t ? "="_PATH_DEVBLOCK : "", 0, ctx->ctty_out_t ? "=" : "", ctx->ctty_out_t ? printh(h2, ctx->ctty_out) : "", 0, ctx->ctty_err_t ? "=" : "", ctx->ctty_err_t ? printh(h3, ctx->ctty_err) : "", 0) == -1)) goto longg;
		return 0;
	}
	KERNEL$SUICIDE("SET_MAPEXTRA: INVALID FLAGS: %X", *jobflags);
	return -1;
}

static int GET_SUSPEND(__const__ char *p)
{
	unsigned long n;
	if (p[0] == '^') {
		n = p[1] - '@';
		if (n >= 32) n -= 32;
		if (__unlikely(n >= 32)) return -1;
		if (__unlikely(p[2])) return -1;
	} else if (p[0] == '!') {
		n = p[1] - '@';
		if (n >= 32) n -= 32;
		if (__unlikely(n >= 32)) return -1;
		n += 32;
		if (__unlikely(p[2])) return -1;
	} else {
		if (__unlikely(__get_number(p, p + strlen(p), 0, (long *)&n))) return -1;
		if (__unlikely(n >= 64)) return -1;
	}
	return n;
}

static void GET_DEFAULT_JOBFLAGS(CTX *ctx, int *jobflags)
{
	__const__ char *c;
	*jobflags = JOB_FG | JOB_BG_BLOCK;
	if ((c = find_var_env(ctx, "@SHELL$DEFAULT_BG"))) {
		if (!_strcasecmp(c, "BGBLOCK")) *jobflags = (*jobflags & ~JOB_BGMODE_MASK) | JOB_BG_BLOCK;
		else if (!_strcasecmp(c, "BGLOSE")) *jobflags = (*jobflags & ~JOB_BGMODE_MASK) | JOB_BG_LOSE;
		else if (!_strcasecmp(c, "BGOUT")) *jobflags = (*jobflags & ~JOB_BGMODE_MASK) | JOB_BG_OUT;
		else if (!_strcasecmp(c, "BGSTOP")) *jobflags = (*jobflags & ~JOB_BGMODE_MASK) | JOB_BG_STOP;
	}
	if (__likely((c = find_var_env(ctx, "@SHELL$DEFAULT_SUSPEND")) != NULL)) {
		int n;
		if (__likely((n = GET_SUSPEND(c)) >= 0)) {
			*jobflags = (*jobflags & ~JOB_SUSPEND_MASK) | n | JOB_SUSPEND_ACTIVE;
		}
	}
}

static int GET_JOBFLAGS(CTX *ctx, char **argv, int *jobflags, int fgbg)
{
	int i, j;
	int noopt = 0;
	for (i = 1, j = 1; argv[i]; i++) {
		if (__unlikely(!_strcasecmp(argv[i], "/-"))) noopt = 1;
		if (__unlikely(noopt)) goto copy_opt;
		if (__unlikely(!_strcasecmp(argv[i], "/BG")) && __likely(fgbg)) *jobflags = (*jobflags & ~JOB_BGFG_MASK) | JOB_BG;
		else if (__unlikely(!_strcasecmp(argv[i], "/FG")) && __likely(fgbg)) *jobflags = (*jobflags & ~JOB_BGFG_MASK) | JOB_FG;
		else if (__unlikely(!_strcasecmp(argv[i], "/BGBLOCK"))) *jobflags = (*jobflags & ~JOB_BGMODE_MASK) | JOB_BG_BLOCK;
		else if (__unlikely(!_strcasecmp(argv[i], "/BGLOSE"))) *jobflags = (*jobflags & ~JOB_BGMODE_MASK) | JOB_BG_LOSE;
		else if (__unlikely(!_strcasecmp(argv[i], "/BGOUT"))) *jobflags = (*jobflags & ~JOB_BGMODE_MASK) | JOB_BG_OUT;
		else if (__unlikely(!_strcasecmp(argv[i], "/BGSTOP"))) *jobflags = (*jobflags & ~JOB_BGMODE_MASK) | JOB_BG_STOP;
		else if (__unlikely(!_memcasecmp(argv[i], "/SUSPEND=", 9))) {
			int n = GET_SUSPEND(argv[i] + 9);
			if (__unlikely(n < 0)) goto bads;
			*jobflags = (*jobflags & ~JOB_SUSPEND_MASK) | n | JOB_SUSPEND_ACTIVE;
		} else if (__unlikely(!_strcasecmp(argv[i], "/NOSUSPEND"))) *jobflags &= ~(JOB_SUSPEND_ACTIVE | JOB_SUSPEND_MASK);
		else {
			copy_opt:
			argv[j++] = argv[i];
		}
	}
	argv[j] = NULL;
	return 0;

	bads:
	ctx->return_val = -EBADSYN;
	_snprintf(ctx->return_msg, __MAX_STR_LEN, "%s: SYNTAX ERROR", fgbg ? "SPAWN" : "REMAP");
	return -1;
}

DECL_AST(SHELL_SPAWN_COMMAND, SPL_SHELL, CTX)
{
	RQ->u.ioctlrq.fn = SHELL_SPAWN_INCREASED_DETACH_SEQ;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_INCREASE_DETACH_SEQ;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = 0;
	RQ->u.ioctlrq.v.len = 0;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	if (__likely(RQ->ctty_in != -1)) {
		RETURN_IORQ(&RQ->u.ioctlrq, KERNEL$IOCTL);
	} else {
		RQ->u.ioctlrq.status = 0;
		RETURN_AST(&RQ->u.ioctlrq);
	}
}

DECL_AST(SHELL_SPAWN_INCREASED_DETACH_SEQ, SPL_SHELL, CTX)
{
#define jobflags	(RQ->itmp1)
	__const__ char *c;
	GET_DEFAULT_JOBFLAGS(RQ, &jobflags);
	if (__unlikely(GET_JOBFLAGS(RQ, RQ->argv, &jobflags, 1))) {
		RETURN_TO_SHELL(RQ);
	}
	if (__unlikely(SET_MAPEXTRA(RQ, &jobflags))) {
		RETURN_TO_SHELL(RQ);
	}
	RQ->u.psr.fn = SHELL_SPAWN_SPAWNED;
	RQ->u.psr.default_lnm = LN_PUBLIC;
	if ((c = find_var_env(RQ, "@SHELL$DEFAULT_LN"))) {
		if (!_strcasecmp(c, "MAPNONE")) RQ->u.psr.default_lnm = LN_NONE;
		else if (!_strcasecmp(c, "MAPPUBLIC")) RQ->u.psr.default_lnm = LN_PUBLIC;
		else if (!_strcasecmp(c, "MAPALL")) RQ->u.psr.default_lnm = LN_ALL;
	}
	RQ->u.psr.mapextra = RQ->scratch_1;
	RQ->u.psr.params = &RQ->argv[1];
	RQ->u.psr.env = NULL;
	RQ->u.psr.cwd = RQ->cwd;
	RQ->u.psr.info = jobflags;
	RQ->u.psr.session_change = __likely((jobflags & JOB_BGFG_MASK) == JOB_FG) ? RQ : NO_SESSION;
	RETURN_IORQ_CANCELABLE(&RQ->u.psr, KERNEL$PROC_SPAWN, RQ->rq);
#undef jobflags
}

DECL_AST(SHELL_SPAWN_SPAWNED, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
	if (__unlikely(RQ->u.psr.status < 0)) {
		RQ->return_val = RQ->u.psr.status;
		_snprintf(RQ->return_msg, __MAX_STR_LEN, "SPAWN: %s", strerror(-RQ->u.psr.status));
		RETURN_TO_SHELL(RQ);
	}
	if (__unlikely((RQ->itmp1 & JOB_BGFG_MASK) == JOB_BG)) {
		strlcpy(RQ->return_msg, RQ->u.psr.jobname, __MAX_STR_LEN);
		RETURN_TO_SHELL(RQ);
	}

	if (__likely(RQ->ctty_in_t) && __likely(RQ->ctty_in >= 0)) {
		RQ->u2.w.wio.h = RQ->ctty_in;
	} else if (__likely(RQ->ctty_out_t) && __likely(RQ->ctty_out >= 0)) {
		RQ->u2.w.wio.h = RQ->ctty_out;
	} else if (__likely(RQ->ctty_err_t) && __likely(RQ->ctty_err >= 0)) {
		RQ->u2.w.wio.h = RQ->ctty_err;
	} else {
		RQ->itmp2 = 1;
		goto no_suspend;
	}
	RQ->itmp2 = 2;
	RQ->u2.w.wio.fn = SHELL_SPAWN_INTR_GOTRESPONSE;
	RQ->u2.w.wio.ioctl = IOCTL_TTY_GET_CONTROL;
	RQ->u2.w.wio.param = __likely(RQ->itmp1 & JOB_SUSPEND_ACTIVE) ? RQ->itmp1 & JOB_SUSPEND_MASK : -1;
	RQ->u2.w.wio.v.ptr = (unsigned long)&RQ->u2.w.tcs;
	RQ->u2.w.wio.v.len = sizeof RQ->u2.w.tcs;
	RQ->u2.w.wio.v.vspace = &KERNEL$VIRTUAL;
	CALL_IORQ(&RQ->u2.w.wio, KERNEL$IOCTL);

	no_suspend:

	memmove(RQ->u.pcr.jobname, RQ->u.psr.jobname, 9);
	RQ->u.pcr.fn = SHELL_SPAWN_RETURNED;
	RQ->u.pcr.op = PROC_CTRL_WAIT;
	RQ->u.pcr.session = RQ;
	RQ->u.pcr.msg = RQ->return_msg;
	RETURN_IORQ_CANCELABLE(&RQ->u.pcr, KERNEL$PROC_CTRL, RQ->rq);
}

DECL_AST(SHELL_SPAWN_INTR_GOTRESPONSE, SPL_SHELL, IOCTLRQ)
{
	CTX *ctx = GET_STRUCT(RQ, CTX, u2.w.wio);
	if (__unlikely(RQ->status < 0) || __unlikely(ctx->itmp2 < 2)) {
		if (!--ctx->itmp2) RETURN_AST(&ctx->u.pcr);
		else if (RQ->status != -ENOOP) KERNEL$CIO((IORQ *)&ctx->u.pcr);
		RETURN;
	}
	RQ->fn = SHELL_SPAWN_INTR_WAITED;
	RQ->ioctl = IOCTL_TTY_WAIT_CONTROL;
	RETURN_IORQ(RQ, KERNEL$IOCTL);
}

DECL_AST(SHELL_SPAWN_INTR_WAITED, SPL_SHELL, IOCTLRQ)
{
	CTX *ctx = GET_STRUCT(RQ, CTX, u2.w.wio);
	if (__unlikely(ctx->itmp2 < 2)) goto r;
	if (__unlikely(RQ->status == -ETTYCHG)) {
		RQ->fn = SHELL_SPAWN_INTR_GOTRESPONSE;
		RQ->ioctl = IOCTL_TTY_GET_CONTROL;
		RETURN_IORQ(RQ, KERNEL$IOCTL);
	}
	r:
	if (!--ctx->itmp2) RETURN_AST(&ctx->u.pcr);
	else if (RQ->status != -ENOOP) KERNEL$CIO((IORQ *)&ctx->u.pcr);
	RETURN;
}

DECL_AST(SHELL_SPAWN_RETURNED, SPL_SHELL, CTX)
{
	int jobflags;
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
	if (__unlikely(--RQ->itmp2 > 0)) {
		KERNEL$CIO((IORQ *)&RQ->u2.w.wio);
		RETURN;
	}
	if (__unlikely(RQ->u.pcr.status < -1)) {
		strlcpy(RQ->scratch_1, RQ->return_msg, SCRATCH_1_LEN);
		if (RQ->u.pcr.status == -EINTR && __unlikely(!*RQ->scratch_1)) _snprintf(RQ->return_msg, __MAX_STR_LEN, "%s SUSPENDED", RQ->u.pcr.jobname);
		else if (RQ->u.pcr.status == -ESTOPPED) _snprintf(RQ->return_msg, __MAX_STR_LEN, "%s STOPPED%s%s", RQ->u.pcr.jobname, *RQ->scratch_1 ? ": " : "", RQ->scratch_1);
		else if (RQ->u.pcr.status == -EBACKGROUND) _snprintf(RQ->return_msg, __MAX_STR_LEN, "%s WENT TO BACKGROUND%s%s", RQ->u.pcr.jobname, *RQ->scratch_1 ? ": " : "", RQ->scratch_1);
		else if (RQ->u.pcr.status == -ETTYCHG && __unlikely(!*RQ->scratch_1)) _snprintf(RQ->return_msg, __MAX_STR_LEN, "%s ATTACHED TO ANOTHER TERMINAL", RQ->u.pcr.jobname);
		else if (RQ->u.pcr.status == -ESRCH && __unlikely(!*RQ->scratch_1)) _snprintf(RQ->return_msg, __MAX_STR_LEN, "%s TERMINATED FROM ANOTHER TERMINAL", RQ->u.pcr.jobname);
		else if (!*RQ->scratch_1) _snprintf(RQ->return_msg, __MAX_STR_LEN, "RETURNED: %s", strerror(-RQ->u.pcr.status));
	}
	RQ->itmp3 = RQ->u.pcr.status == -ESTOPPED || RQ->u.pcr.status == -ETTYCHG || RQ->u.pcr.status == -ESRCH ? FREAD : _FPUTBACK;
	RQ->return_val = RQ->u.pcr.status;
	if (__likely(RQ->u.pcr.status != -ESTOPPED) && __likely(RQ->u.pcr.status != -ETTYCHG) && __likely(RQ->u.pcr.status != -EBACKGROUND) && __likely(RQ->u.pcr.status != -EINTR) && __likely(RQ->u.pcr.status != -ESRCH)) {
		if (__unlikely(!strcmp(RQ->u.pcr.jobname, RQ->last_job))) RQ->last_job[0] = 0;
		RQ->u.pcr.fn = SHELL_SPAWN_ERASE_TTY;
		RQ->u.pcr.op = PROC_CTRL_ZAP;
		RQ->u.pcr.session = RQ;
		RQ->u.pcr.msg = (char *)&KERNEL$LIST_END;
		RETURN_IORQ(&RQ->u.pcr, KERNEL$PROC_CTRL);
	}
	if (__likely(RQ->u.pcr.status != -ESRCH)) strcpy(RQ->last_job, RQ->u.pcr.jobname);
	if (__unlikely(RQ->u.pcr.status == -ETTYCHG) || __unlikely(RQ->u.pcr.status == -ESRCH)) {
		CALL_SHELL_FN(RQ, SHELL_SPAWN_ERASE_TTY);
	}

	jobflags = KERNEL$PROC_GET_FLAGS(RQ->u.psr.jobname, RQ, (void **)(void *)&KERNEL$LIST_END);
	if (__unlikely(jobflags < 0)) CALL_SHELL_FN(RQ, SHELL_SPAWN_ERASE_TTY);
	RQ->u.pcr.fn = SHELL_SPAWN_BG;
	if (((jobflags & JOB_BGMODE_MASK) != JOB_BG_STOP) && __likely(RQ->return_val != -ESTOPPED)) RQ->u.pcr.op = PROC_CTRL_RESUME;
	else RQ->u.pcr.op = PROC_CTRL_STOP;
	RQ->u.pcr.session = RQ;
	RQ->u.pcr.msg = (char *)&KERNEL$LIST_END;
	RETURN_IORQ(&RQ->u.pcr, KERNEL$PROC_CTRL);
}

DECL_AST(SHELL_SPAWN_ERASE_TTY, SPL_SHELL, CTX)
{
	if (__unlikely(RQ->ctty_in == -1)) RETURN_TO_SHELL(RQ);
	RQ->u.ioctlrq.fn = SHELL_SPAWN_RETURN;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_FLUSH;
	RQ->u.ioctlrq.param = RQ->itmp3;
	RQ->u.ioctlrq.v.ptr = 0;
	RQ->u.ioctlrq.v.len = 0;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ(&RQ->u.ioctlrq, KERNEL$IOCTL);
}

DECL_AST(SHELL_SPAWN_RETURN, SPL_SHELL, CTX)
{
	RETURN_TO_SHELL(RQ);
}

DECL_AST(SHELL_SPAWN_BG, SPL_SHELL, CTX)
{
	int jobflags;
	memmove(RQ->u.psr.jobname, RQ->u.pcr.jobname, 9);
	jobflags = KERNEL$PROC_GET_FLAGS(RQ->u.psr.jobname, RQ, (void **)(void *)&KERNEL$LIST_END);
	if (__unlikely(jobflags < 0)) CALL_SHELL_FN(RQ, SHELL_SPAWN_ERASE_TTY);
	jobflags = (jobflags & ~JOB_BGFG_MASK) | JOB_BG;
	if (__unlikely(SET_MAPEXTRA(RQ, &jobflags))) {
		CALL_SHELL_FN(RQ, SHELL_SPAWN_ERASE_TTY);
	}
	RQ->u.psr.fn = SHELL_SPAWN_ERASE_TTY;
	RQ->u.psr.mapextra = RQ->scratch_1;
	RQ->u.psr.params = NULL;
	RQ->u.psr.env = NULL;
	RQ->u.psr.cwd = RQ->cwd;
	RQ->u.psr.session = RQ;
	RQ->u.psr.session_change = NO_SESSION;
	RQ->u.psr.info = jobflags;
	RETURN_IORQ(&RQ->u.psr, KERNEL$PROC_REMAP);
}

extern AST_STUB SHELL_FG_INCREASED_DETACH_SEQ;
extern AST_STUB SHELL_FG_SESSION_ATTACHED;
extern AST_STUB SHELL_FG_RESUME_DONE;

DECL_AST(SHELL_FG_COMMAND, SPL_SHELL, CTX)
{
	if (!RQ->argv[1]) {
		if (__unlikely(!*RQ->last_job)) {
			_snprintf(RQ->return_msg, __MAX_STR_LEN, "FG: NO LAST JOB");
			RQ->return_val = -ESRCH;
			RETURN_TO_SHELL(RQ);
		}
		RQ->ctmp1 = RQ->last_job;
	} else {
		if (__unlikely(RQ->argv[2] != NULL) || __unlikely(strlen(RQ->argv[1]) > 8)) {
			_snprintf(RQ->return_msg, __MAX_STR_LEN, "FG: SYNTAX ERROR");
			RQ->return_val = -EBADSYN;
			RETURN_TO_SHELL(RQ);
		}
		RQ->ctmp1 = RQ->argv[1];
	}
	RQ->u.ioctlrq.fn = SHELL_FG_INCREASED_DETACH_SEQ;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_INCREASE_DETACH_SEQ;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = 0;
	RQ->u.ioctlrq.v.len = 0;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	if (__likely(RQ->ctty_in != -1)) {
		RETURN_IORQ(&RQ->u.ioctlrq, KERNEL$IOCTL);
	} else {
		RQ->u.ioctlrq.status = 0;
		RETURN_AST(&RQ->u.ioctlrq);
	}
}

DECL_AST(SHELL_FG_INCREASED_DETACH_SEQ, SPL_SHELL, CTX)
{
#define jobflags	(RQ->itmp1)
	strcpy(RQ->u.psr.jobname, RQ->ctmp1);
	__upcase(RQ->u.psr.jobname);
	jobflags = KERNEL$PROC_GET_FLAGS(RQ->ctmp1, NULL, (void **)(void *)&KERNEL$LIST_END);
	if (__unlikely(jobflags < 0)) {
		_snprintf(RQ->return_msg, __MAX_STR_LEN, "FG: %s (%s)", strerror(-jobflags), RQ->u.psr.jobname);
		RQ->return_val = jobflags;
		RETURN_TO_SHELL(RQ);
	}
	jobflags = (jobflags & ~JOB_BGFG_MASK) | JOB_FG;
	if (__unlikely(SET_MAPEXTRA(RQ, &jobflags))) {
		RETURN_TO_SHELL(RQ);
	}
	RQ->u.psr.fn = SHELL_FG_SESSION_ATTACHED;
	RQ->u.psr.mapextra = RQ->scratch_1;
	RQ->u.psr.params = NULL;
	RQ->u.psr.env = NULL;
	RQ->u.psr.cwd = RQ->cwd;
	RQ->u.psr.session = NULL;
	RQ->u.psr.session_change = RQ;
	RQ->u.psr.info = jobflags;
	RETURN_IORQ_CANCELABLE(&RQ->u.psr, KERNEL$PROC_REMAP, RQ->rq);
#undef jobflags
}

DECL_AST(SHELL_FG_SESSION_ATTACHED, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
	RQ->u.pcr.fn = SHELL_FG_RESUME_DONE;
	strcpy(RQ->u.pcr.jobname, RQ->ctmp1);
	__upcase(RQ->u.pcr.jobname);
	RQ->u.pcr.op = PROC_CTRL_RESUME;
	RQ->u.pcr.session = RQ;
	RQ->u.pcr.msg = (char *)&KERNEL$LIST_END;
	RETURN_IORQ_CANCELABLE(&RQ->u.pcr, KERNEL$PROC_CTRL, RQ->rq);
}

DECL_AST(SHELL_FG_RESUME_DONE, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
	if (__unlikely(RQ->u.pcr.status < 0)) {
		RQ->return_val = RQ->u.pcr.status;
		_snprintf(RQ->return_msg, __MAX_STR_LEN, "FG: %s (%s)", strerror(-RQ->u.pcr.status), RQ->u.pcr.jobname);
		RETURN_TO_SHELL(RQ);
	}
	strcpy(RQ->u.psr.jobname, RQ->ctmp1);
	__upcase(RQ->u.psr.jobname);
	RQ->u.psr.status = 0;
	CALL_SHELL_FN(RQ, SHELL_SPAWN_SPAWNED);
}

extern AST_STUB SHELL_REMAP_REMAPPED;

DECL_AST(SHELL_REMAP_COMMAND, SPL_SHELL, CTX)
{
	void *session;
	char *jobname = NULL;
	int jobflags;
	int i;
	for (i = 1; RQ->argv[i]; i++) if (__likely(RQ->argv[i][0] != '/')) {
		jobname = RQ->argv[i];
		do RQ->argv[i] = RQ->argv[i + 1]; while (RQ->argv[i++]);
		break;
	}
	if (__unlikely(!jobname)) {
		if (__unlikely(!*RQ->last_job)) {
			_snprintf(RQ->return_msg, __MAX_STR_LEN, "REMAP: NO LAST JOB");
			RQ->return_val = -ESRCH;
			RETURN_TO_SHELL(RQ);
		}
		jobname = RQ->last_job;
	} else {
		if (__unlikely(strlen(jobname) > 8)) {
			_snprintf(RQ->return_msg, __MAX_STR_LEN, "REMAP: SYNTAX ERROR");
			RQ->return_val = -EBADSYN;
			RETURN_TO_SHELL(RQ);
		}
	}
	strcpy(RQ->u.psr.jobname, jobname);
	__upcase(RQ->u.psr.jobname);
	jobflags = KERNEL$PROC_GET_FLAGS(jobname, NULL, &session);
	if (__unlikely(jobflags < 0)) {
		_snprintf(RQ->return_msg, __MAX_STR_LEN, "REMAP: %s (%s)", strerror(-jobflags), RQ->u.psr.jobname);
		RQ->return_val = jobflags;
		RETURN_TO_SHELL(RQ);
	}
	if (__unlikely(GET_JOBFLAGS(RQ, RQ->argv, &jobflags, 0))) {
		RETURN_TO_SHELL(RQ);
	}
	if (__unlikely(SET_MAPEXTRA(RQ, &jobflags))) {
		RETURN_TO_SHELL(RQ);
	}
	RQ->u.psr.fn = SHELL_REMAP_REMAPPED;
	if ((jobflags & JOB_BGFG_MASK) == JOB_BG) RQ->u.psr.mapextra = RQ->scratch_1;
	else RQ->u.psr.mapextra = NULL;
	RQ->u.psr.params = &RQ->argv[1];
	RQ->u.psr.env = NULL;
	RQ->u.psr.cwd = RQ->cwd;
	RQ->u.psr.session = session;
	RQ->u.psr.session_change = NULL;
	RQ->u.psr.info = jobflags;
	RETURN_IORQ_CANCELABLE(&RQ->u.psr, KERNEL$PROC_REMAP, RQ->rq);
}

DECL_AST(SHELL_REMAP_REMAPPED, SPL_SHELL, CTX)
{
	if (__unlikely(RQ->u.psr.status < 0)) {
		if (__unlikely(RQ->u.psr.status == -ETTYCHG)) {
			void *session;
			int jobflags = KERNEL$PROC_GET_FLAGS(RQ->u.psr.jobname, NULL, &session);
			if (jobflags >= 0 && session != RQ->u.psr.session) CALL_SHELL_FN(RQ, SHELL_REMAP_COMMAND);
		}
		_snprintf(RQ->return_msg, __MAX_STR_LEN, "REMAP: %s (%s)", strerror(-RQ->u.psr.status), RQ->u.psr.jobname);
		RQ->return_val = RQ->u.psr.status;
		RETURN_TO_SHELL(RQ);
	}
	RETURN_TO_SHELL(RQ);
}

extern AST_STUB SHELL_JOB_PRINTED;

DECL_AST(SHELL_JOBS_COMMAND, SPL_SHELL, CTX)
{
	if (__unlikely(RQ->argv[1] != NULL)) {
		_snprintf(RQ->return_msg, __MAX_STR_LEN, "JOBS: SYNTAX ERROR");
		RQ->return_val = -EBADSYN;
		RETURN_TO_SHELL(RQ);
	}
	*RQ->scratch_1 = 0;
	RQ->u.siorq.fn = SHELL_JOB_PRINTED;
	RETURN_AST(&RQ->u.siorq);
}

DECL_AST(SHELL_JOB_PRINTED, SPL_SHELL, CTX)
{
	if (*RQ->scratch_1) {
		char *c;
		IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
		if (__unlikely(RQ->u.siorq.status < 0)) {
			RQ->return_val = RQ->u.siorq.status;
			_snprintf(RQ->return_msg, __MAX_STR_LEN, "JOBS: %s", strerror(-RQ->return_val));
			RETURN_TO_SHELL(RQ);
		}
		if (__unlikely(!RQ->u.siorq.status)) {
			RQ->return_val = -EEOF;
			_snprintf(RQ->return_msg, __MAX_STR_LEN, "JOBS: CAN'T WRITE");
			RETURN_TO_SHELL(RQ);
		}
		if (__unlikely(RQ->u.siorq.v.len != 0)) {
			RQ->u.siorq.progress = 0;
			RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->rq);
		}
		a:
		if (__likely((c = strchr(RQ->scratch_1, '\n')) != NULL)) *c = 0;
	}
	KERNEL$PROC_GET_JOB_NAME(RQ->scratch_1);
	if (!*RQ->scratch_1) RETURN_TO_SHELL(RQ);
	strcat(RQ->scratch_1, "\n");
	if (__unlikely(RQ->ctty_out == -1)) {
		__critical_printf("%s", RQ->scratch_1);
		goto a;
	}
	RQ->u.siorq.h = RQ->ctty_out;
	RQ->u.siorq.v.ptr = (unsigned long)RQ->scratch_1;
	RQ->u.siorq.v.len = strlen(RQ->scratch_1);
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->rq);
}

extern AST_STUB SHELL_PROC_CTRL_DONE;

static int PROC_CTRL_COMMAND(CTX *RQ)
{
	if (!_strcasecmp(RQ->argv[0], "STOP")) return PROC_CTRL_STOP;
	if (!_strcasecmp(RQ->argv[0], "RESUME")) return PROC_CTRL_RESUME;
	if (__likely(!_strcasecmp(RQ->argv[0], "ZAP"))) return PROC_CTRL_ZAP;
	KERNEL$SUICIDE("PROC_CTRL_COMMAND: UNKNOWN COMMAND \"%s\"", RQ->argv[0]);
}

static char *PROC_CTRL_COMMAND_NAME(CTX *RQ)
{
	int cmd = PROC_CTRL_COMMAND(RQ);
	if (cmd == PROC_CTRL_STOP) return "STOP";
	if (cmd == PROC_CTRL_RESUME) return "RESUME";
	if (__likely(cmd == PROC_CTRL_ZAP)) return "ZAP";
	KERNEL$SUICIDE("PROC_CTRL_COMMAND_NAME: UNKNOWN CODE %d, COMMAND \"%s\"", cmd, RQ->argv[0]);
}

DECL_AST(SHELL_PROC_CTRL_COMMAND, SPL_SHELL, CTX)
{
	if (!RQ->argv[1]) {
		if (__unlikely(!*RQ->last_job)) {
			_snprintf(RQ->return_msg, __MAX_STR_LEN, "%s: NO LAST JOB", PROC_CTRL_COMMAND_NAME(RQ));
			RQ->return_val = -ESRCH;
			RETURN_TO_SHELL(RQ);
		}
		RQ->ctmp1 = RQ->last_job;
	} else {
		if (__unlikely(RQ->argv[2] != NULL) || __unlikely(strlen(RQ->argv[1]) > 8)) {
			_snprintf(RQ->return_msg, __MAX_STR_LEN, "%s: SYNTAX ERROR", PROC_CTRL_COMMAND_NAME(RQ));
			RQ->return_val = -EBADSYN;
			RETURN_TO_SHELL(RQ);
		}
		RQ->ctmp1 = RQ->argv[1];
	}
	RQ->u.pcr.fn = SHELL_PROC_CTRL_DONE;
	strlcpy(RQ->u.pcr.jobname, RQ->ctmp1, 9);
	__upcase(RQ->u.pcr.jobname);
	RQ->u.pcr.op = PROC_CTRL_COMMAND(RQ);
	if (RQ->u.pcr.op == PROC_CTRL_ZAP && __unlikely(!strcmp(RQ->u.pcr.jobname, RQ->last_job))) RQ->last_job[0] = 0;
	RQ->u.pcr.session = NULL;
	RQ->u.pcr.msg = (char *)&KERNEL$LIST_END;
	RETURN_IORQ_CANCELABLE(&RQ->u.pcr, KERNEL$PROC_CTRL, RQ->rq);
}

DECL_AST(SHELL_PROC_CTRL_DONE, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_SHELL, RQ->rq);
	if (__unlikely(RQ->u.pcr.status < 0)) {
		RQ->return_val = RQ->u.pcr.status;
		_snprintf(RQ->return_msg, __MAX_STR_LEN, "%s: %s (%s)", PROC_CTRL_COMMAND_NAME(RQ), strerror(-RQ->u.pcr.status), RQ->u.pcr.jobname);
	}
	RETURN_TO_SHELL(RQ);
}

