#include <SYS/TYPES.H>
#include <STRING.H>
#include <STDLIB.H>

#include "VGA.H"
#include <VGA.H>

static unsigned default_color;

int __finline__ vga_setcolor(int color)
{
	default_color = color;
	return 0;
}

int vga_drawpixel(int x, int y)
{
	if (__unlikely(current_mode == TEXT) || __unlikely((unsigned)x >= mode_param.x) || __unlikely((unsigned)y >= max_y)) return -1;
	if (can_omit_draw) return 0;
	if (__unlikely(current_page)) vga_setpage(0);
	switch (mode_param.bpp) {
		case 8:
			graph_mem[x + y * mode_param.scanline] = default_color;
			break;
		case 15:
		case 16:
			*(__u16 *)&graph_mem[x * 2 + y * mode_param.scanline] = default_color;
			break;
		case 24:
			graph_mem[x * 3 + y * mode_param.scanline] = default_color;
			graph_mem[x * 3 + y * mode_param.scanline + 1] = default_color >> 8;
			graph_mem[x * 3 + y * mode_param.scanline + 2] = default_color >> 16;
			break;
		case 32:
			*(__u32 *)&graph_mem[x * 4 + y * mode_param.scanline] = default_color;
			break;
		default:
			return -1;
	}
	return 0;
}

int vga_getpixel(int x, int y)
{
	if (__unlikely(current_mode == TEXT) || __unlikely((unsigned)x >= mode_param.x) || __unlikely((unsigned)y >= max_y)) return -1;
	if (__unlikely(current_page)) vga_setpage(0);
	switch (mode_param.bpp) {
		case 8:
			return graph_mem[x + y * mode_param.scanline];
		case 15:
		case 16:
			return *(__u16 *)&graph_mem[x * 2 + y * mode_param.scanline];
		case 24:
			return graph_mem[x * 3 + y * mode_param.scanline] + (graph_mem[x * 3 + y * mode_param.scanline + 1] << 8) + (graph_mem[x * 3 + y * mode_param.scanline + 2] << 16);
		case 32:
			return *(__u32 *)&graph_mem[x * 4 + y * mode_param.scanline];
		default:
			return -1;
	}
}

int vga_drawline(int x1, int y1, int x2, int y2)
{
	int xdd, ydd, ap, al, i, l, r;
	int d, e, xd, yd;
	if (can_omit_draw) return 0;
	d = x2 - x1;
	e = y2 - y1;
	xd = 1;
	yd = 1;
	if (d < 0) d = -d, xd = -1;
	if (e < 0) e = -e, yd = -1;
	if (d > e) {
		xdd = xd;
		ydd = 0;
		ap = e;
		al = d;
	} else {
		xdd = 0;
		ydd = yd;
		ap = d;
		al = e;
	}
	r = 0, l = 0;
	for (i = 0; i <= al; i++) {
		r |= vga_drawpixel(x1, y1);
		if ((l += ap) >= al) {
			l -= al;
			x1 += xd;
			y1 += yd;
		} else {
			x1 += xdd;
			y1 += ydd;
		}
	}
	return r;
}

int vga_drawscanline(int line, unsigned char *colors)
{
	return vga_drawscansegment(colors, 0, line, mode_param.x * ((mode_param.bpp + 7) >> 3));
}

static __finline__ void split_memcpy(unsigned char *dst, unsigned char *src, unsigned len, unsigned moffs)
{
	if (__likely(mode_param.pages == 1) || __likely((moffs & 0xffff0000) == ((moffs + len - 1) & 0xffff0000))) {
		memcpy(dst, src, len);
	} else {
		unsigned split;
		if (__unlikely(!len)) return;
		split = 0x10000 - (moffs & 0xffff);
		memcpy(dst, src, split);
		memcpy(dst + split, src + split, len - split);
	}
}

int vga_drawscansegment(unsigned char *colors, int x, int y, int length)
{
	unsigned moffs;
	if (__unlikely(current_mode == TEXT) || __unlikely((unsigned)x >= mode_param.x) || __unlikely((unsigned)y >= max_y)) return -1;
	if (can_omit_draw) return 0;
	if (__unlikely(current_page)) vga_setpage(0);
	switch (mode_param.bpp) {
		case 8:
			if (__unlikely(x + length > mode_param.scanline)) return -1;
			moffs = x + y * mode_param.scanline;
			split_memcpy(graph_mem + moffs, colors, length, moffs);
			break;
		case 15:
		case 16:
			if (__unlikely(x * 2 + length > mode_param.scanline)) return -1;
			moffs = x * 2 + y * mode_param.scanline;
			split_memcpy(graph_mem + moffs, colors, length, moffs);
			break;
		case 24:
			if (__unlikely(x * 3 + length > mode_param.scanline)) return -1;
			moffs = x * 3 + y * mode_param.scanline;
			split_memcpy(graph_mem + moffs, colors, length, moffs);
			break;
		case 32:
			if (__unlikely(x * 4 + length > mode_param.scanline)) return -1;
			moffs = x * 4 + y * mode_param.scanline;
			split_memcpy(graph_mem + moffs, colors, length, moffs);
			break;
		default:
			return -1;
	}
	return 0;
}

int vga_getscansegment(unsigned char *colors, int x, int y, int length)
{
	unsigned moffs;
	if (__unlikely(current_mode == TEXT) || __unlikely((unsigned)x >= mode_param.x) || __unlikely((unsigned)y >= max_y)) return -1;
	if (__unlikely(current_page)) vga_setpage(0);
	switch (mode_param.bpp) {
		case 8:
			if (__unlikely(x + length > mode_param.scanline)) return -1;
			moffs = x + y * mode_param.scanline;
			split_memcpy(colors, graph_mem + moffs, length, moffs);
			break;
		case 15:
		case 16:
			if (__unlikely(x * 2 + length > mode_param.scanline)) return -1;
			moffs = x * 2 + y * mode_param.scanline;
			split_memcpy(colors, graph_mem + moffs,  length, moffs);
			break;
		case 24:
			if (__unlikely(x * 3 + length > mode_param.scanline)) return -1;
			moffs = x * 3 + y * mode_param.scanline;
			split_memcpy(colors, graph_mem + moffs,  length, moffs);
			break;
		case 32:
			if (__unlikely(x * 4 + length > mode_param.scanline)) return -1;
			moffs = x * 4 + y * mode_param.scanline;
			split_memcpy(colors, graph_mem + moffs, length, moffs);
			break;
		default:
			return -1;
	}
	return 0;
}

int vga_clear(void)
{
	if (__unlikely(current_mode == TEXT)) return -1;
	if (__unlikely(current_page)) vga_setpage(0);
	memset(graph_mem, 0, graph_mem_len);
	vga_setcolor(15);
	return 0;
}

int accel_do_manually(unsigned op, union accel_param *ap)
{
	__u8 *ptr;
	unsigned s, e;
	int d;
	if (__unlikely(accel_in_progress)) vga_accel(ACCEL_SYNC);
	if (__unlikely(current_page)) vga_setpage(0);
	switch (op & _ACCEL_OP) {
		case ACCEL_FILLBOX:
			if (__unlikely(ap->fillbox.y >= max_y) || __unlikely(ap->fillbox.y + ap->fillbox.h > max_y)) return -1;
			if (__unlikely(ap->fillbox.x >= mode_param.x) || __unlikely(ap->fillbox.x + ap->fillbox.w > mode_param.x)) return -1;
			switch (mode_param.bpp) {
				case 8:
					ptr = graph_mem + ap->fillbox.x + ap->fillbox.y * mode_param.scanline;
					while (ap->fillbox.h--) {
						__u8 *pptr = ptr;
						unsigned i, c = ap->fillbox.c;
						for (i = ap->fillbox.w; i != 0; i--) *pptr++ = c;
						ptr += mode_param.scanline;
					}
					return 0;
				case 15:
				case 16:
					ptr = graph_mem + (ap->fillbox.x << 1) + ap->fillbox.y * mode_param.scanline;
					while (ap->fillbox.h--) {
						__u16 *pptr = (__u16 *)ptr;
						unsigned i, c = ap->fillbox.c;
						for (i = ap->fillbox.w; i != 0; i--) *pptr++ = c;
						ptr += mode_param.scanline;
					}
					return 0;
				case 24:
					ptr = graph_mem + ap->fillbox.x * 3 + ap->fillbox.y * mode_param.scanline;
					while (ap->fillbox.h--) {
						__u8 *pptr = ptr;
						unsigned i, c = ap->fillbox.c;
						for (i = ap->fillbox.w; i != 0; i--) pptr[0] = c, pptr[1] = c >> 8, pptr[2] = c >> 16, pptr += 3;
						ptr += mode_param.scanline;
					}
					return 0;
				case 32:
					ptr = graph_mem + (ap->fillbox.x << 2) + ap->fillbox.y * mode_param.scanline;
					while (ap->fillbox.h--) {
						__u32 *pptr = (__u32 *)ptr;
						unsigned i, c = ap->fillbox.c;
						for (i = ap->fillbox.w; i != 0; i--) *pptr++ = c;
						ptr += mode_param.scanline;
					}
					return 0;
				default:
					return -1;
			}
		case ACCEL_SCREENCOPY:
			if (__unlikely(ap->screencopy.y1 >= max_y) || __unlikely(ap->screencopy.y1 + ap->screencopy.h > max_y)) return -1;
			if (__unlikely(ap->screencopy.x1 >= mode_param.x) || __unlikely(ap->screencopy.x1 + ap->screencopy.w > mode_param.x)) return -1;
			if (__unlikely(ap->screencopy.y2 >= max_y) || __unlikely(ap->screencopy.y2 + ap->screencopy.h > max_y)) return -1;
			if (__unlikely(ap->screencopy.x2 >= mode_param.x) || __unlikely(ap->screencopy.x2 + ap->screencopy.w > mode_param.x)) return -1;
			ap->screencopy.w *= (mode_param.bpp + 7) >> 3;
			ptr = malloc(ap->screencopy.w);
			if (__unlikely(!ptr)) return -1;
			if (ap->screencopy.y1 > ap->screencopy.y2) {
				s = ap->screencopy.y1;
				e = ap->screencopy.y1 + ap->screencopy.h;
				d = 1;
			} else {
				s = ap->screencopy.y1 + ap->screencopy.h - 1;
				e = ap->screencopy.y1 - 1;
				d = -1;
			}
			do {
				if (__likely(!vga_getscansegment(ptr, ap->screencopy.x1, s, ap->screencopy.w)))
					vga_drawscansegment(ptr, ap->screencopy.x2, s - ap->screencopy.y1 + ap->screencopy.y2, ap->screencopy.w);
			} while ((s += d) != e);
			free(ptr);
			return 0;
		default:
			return -1;
	}
}

