#include <SYS/TYPES.H>
#include <SPAD/LINK.H>
#include <STRING.H>

#include "FSDCODE.H"

#include "BIND_SYS.H"

#define SUPPORT_ZLIB

long _START(int code, void *ptr, long n, void *self, char **error);

static __finline__ long align(long n, long al)
{
	return (n + (al - 1)) & ~(al - 1);
}

#ifdef SUPPORT_ZLIB

#define INFLATE_ONLY
#define NO_GZIP
#define zmemcpy memcpy
#define ZFREE(s, addr)	do { } while (0)
static void *ZALLOC(void *stream, unsigned items, unsigned obj_size);

#include "INFLATE.C"
#include "INFFAST.C"
#include "INFTREES.C"
#include "ADLER32.C"

static char z_arena[(1 << ZLIB_WINDOW_BITS) + sizeof(struct inflate_state) + sizeof(unsigned long) - 1];
static char *z_arenap = NULL;

/*static char mem_history[256];
static unsigned mh_index;
static void add_mh(unsigned n)
{
	unsigned d;
	for (d = 10; d < n; d *= 10) ;
	d /= 10;
	while (d) {
		char c = n / d;
		n %= d;
		mem_history[mh_index++] = c + '0';
		d /= 10;
	}
	mem_history[mh_index++] = ',';
}*/
static void *ZALLOC(void *stream, unsigned items, unsigned obj_size)
{
	char *p;
	unsigned len = items * obj_size;
	if (__unlikely(!z_arenap)) return NULL;
	p = (char *)align((unsigned long)z_arenap, sizeof(unsigned long));
	if (__unlikely(p > z_arena + sizeof(z_arena) - len)) return NULL;
	z_arenap = p + len;
	return p;
}

static __finline__ void INIT_ZALLOC(void)
{
	z_arenap = z_arena;
}

#endif

static int my_compare(BIND_HEADER *file, char *name)
{
	unsigned i;
	for (i = 0; i < file->namelen; i++) {
		char c1 = ((char *)(file + 1))[i];
		char c2 = name[i];
		if (__unlikely(c1 >= 'a') && __likely(c1 <= 'z')) c1 -= 0x20;
		if (__unlikely(c2 >= 'a') && __likely(c2 <= 'z')) c1 -= 0x20;
		if (__likely(c1 != c2) || __unlikely(!c1)) return 1;
	}
	return name[i] != 0;
}

static BIND_HEADER *next_file(BIND_HEADER *file, char **error)
{
	if (__unlikely(file->magic != __32CPU2LE(BIND_MAGIC))) {
		*error = "BAD MAGIC";
		return NULL;
	}
	if (file->method != METHOD_UNCOMPRESSED &&
	    file->method != METHOD_ZLIB) {
		*error = "UNKNOWN STORAGE METHOD";
		return NULL;
	}
	if (__unlikely(!file->namelen)) {
		*error = "EMPTY FILE NAME";
		return NULL;
	}
	file = (BIND_HEADER *)((char *)file + sizeof(BIND_HEADER) + align(file->namelen, BIND_ALIGN) + align(__32LE2CPU(file->compressed_len), BIND_ALIGN));
	if (__unlikely(file->magic != __32CPU2LE(BIND_MAGIC))) {
		*error = "BAD MAGIC";
		return NULL;
	}
	return file;
}

static BIND_HEADER *find_file(struct link_header *lh, struct section *sec, char *filename, char **error)
{
	BIND_HEADER *file = (BIND_HEADER *)((char *)lh + sec[3].offset + sec[3].len + sec[4].len);
	while (file->method != METHOD_END) {
		BIND_HEADER *next = next_file(file, error);
		if (__unlikely(!next)) return NULL;
		if (!my_compare(file, filename)) return file;
		file = next;
	}
	*error = "FILE NOT FOUND";
	return NULL;
}

static char bss_not_created = 1;

static char *stream = NULL;
static long stream_len;
static unsigned char stream_method;

static z_stream z;

static void zlib_error(char *fn, int r, char **error)
{
	char *msg;
	stpcpy(stpcpy(stpcpy(*error, "ZLIB ERROR IN "), fn), ": ");
	msg = z.msg;
	if (!msg) {
		switch (r) {
			case Z_OK:		msg = "OK"; break;
			case Z_STREAM_END:	msg = "STREAM END"; break;
			case Z_NEED_DICT:	msg = "NEED DICTIONARY"; break;
			case Z_ERRNO:		msg = "ERRNO"; break;
			case Z_STREAM_ERROR:	msg = "STREAM ERROR"; break;
			case Z_DATA_ERROR:	msg = "DATA ERROR"; break;
			case Z_MEM_ERROR:	msg = "MEM ERROR"; break;
			case Z_BUF_ERROR:	msg = "BUF ERROR"; break;
			case Z_VERSION_ERROR:	msg = "VERSION ERROR"; break;
			default:		msg = "UNKNOWN"; break;
		}
	}
	if (__unlikely(strlen(*error) + strlen(msg) >= 256)) {
		msg = "TOO LONG ERROR";
	}
	strcat(*error, msg);
}

long _START(int code, void *ptr, long n, void *self, char **error)
{
	int r;
	struct link_header *lh = (struct link_header *)((char *)self - __offsetof(struct link_header, startup_code));
	struct section *sec;
	BIND_HEADER *file;
	if (__unlikely(lh->lnk_id != LNK_ID)) {
		*error = "INVALID SELF POINTER";
		return -1;
	}
	if (__unlikely(lh->n_sections != 5)) {
		*error = "BAD NUMBER OF SECTIONS";
		return -1;
	}
	sec = (struct section *)((char *)lh + lh->sections);
	if (__unlikely(bss_not_created)) {
		file = (BIND_HEADER *)((char *)lh + sec[3].offset + sec[3].len);
		while (file->method != METHOD_END) {
			file = next_file(file, error);
			if (__unlikely(!file)) return -1;
		}
		file++;
		memmove((char *)lh + sec[3].offset + sec[3].len + sec[4].len, (char *)lh + sec[3].offset + sec[3].len, (char *)file - ((char *)lh + sec[3].offset + sec[3].len));
		memset((char *)lh + sec[3].offset + sec[3].len, 0, sec[4].len);
		bss_not_created = 0;
		/*{
			static char bss[1234];
			int i;
			for (i = 0; i < 1234; i++) if (bss[i]) {
				*error = "BSS ERROR";
				return -1;
			}
		}
		file = (BIND_HEADER *)((char *)lh + sec[3].offset + sec[3].len + sec[4].len);
		while (file->method != METHOD_END) {
			file = next_file(file, error);
			if (__unlikely(!file)) {
				*error = "x1";
				return -1;
			}
		}
		*error = "test";
		return -1;*/
	}
	switch (code) {
		case FSD_TOP_OF_HEAP_CODE: {
			file = (BIND_HEADER *)((char *)lh + sec[3].offset + sec[3].len + sec[4].len);
			while (file->method != METHOD_END) {
				file = next_file(file, error);
				if (__unlikely(!file)) return -1;
			}
			file++;
			return (unsigned long)file;
		}
		case FSD_DIR_CODE: {
			if (!n) file = (BIND_HEADER *)((char *)lh + sec[3].offset + sec[3].len + sec[4].len);
			else file = (BIND_HEADER *)n;
			if (__unlikely(file->method == METHOD_END)) {
				*error = "EMPTY DIRECTORY";
				return -1;
			}
			memcpy(ptr, (char *)(file + 1), file->namelen);
			((char *)ptr)[file->namelen] = 0;
			file = next_file(file, error);
			if (__unlikely(!file)) return -1;
			if (__likely(file->method != METHOD_END)) return (long)file;
			else return 0;
		}
		case FSD_STAT_CODE: {
			if (__unlikely(!(file = find_file(lh, sec, ptr, error)))) return -1;
			return __32LE2CPU(file->uncompressed_len);
		}
		case FSD_OPEN_CODE: {
			if (__unlikely(stream != NULL)) {
				*error = "PREVIOUS FILE NOT CLOSED";
				return -1;
			}
			if (__unlikely(!(file = find_file(lh, sec, ptr, error)))) return -1;
			stream = (char *)file + sizeof(BIND_HEADER) + align(file->namelen, BIND_ALIGN);
			stream_len = __32LE2CPU(file->compressed_len);
			stream_method = file->method;
			if (file->method == METHOD_ZLIB) {
				INIT_ZALLOC();
				z.next_in = stream;
				z.avail_in = stream_len;
				if (__unlikely((r = inflateInit2(&z, ZLIB_WINDOW_BITS)) != Z_OK)) {
					zlib_error("INFLATEINIT2", r, error);
					return -1;
				}
			} else {
				if (__unlikely(stream_len != __32LE2CPU(file->uncompressed_len))) {
					*error = "BAD LENGTH";
					return -1;
				}
			}
			return __32LE2CPU(file->uncompressed_len);
		}
		case FSD_READ_CODE: {
			if (__unlikely(!stream)) {
				*error = "NO OPEN FILE";
				return -1;
			}
			if (stream_method == METHOD_ZLIB) {
				z.next_out = ptr;
				z.avail_out = n;
				r = inflate(&z, Z_SYNC_FLUSH);
				if (__unlikely(r != Z_OK) && __unlikely(r != Z_STREAM_END)) {
					zlib_error("INFLATE", r, error);
					return -1;
				}
				if (__unlikely(z.avail_out != 0)) {
					*error = "DECOMPRESSING BEYOND FILE END";
					return -1;
				}
			} else {
				if (__unlikely(n > stream_len)) {
					*error = "READING BEYOND FILE END";
					return -1;
				}
				memcpy(ptr, stream, n);
				stream += n;
				stream_len -= n;
			}
			return 0;
		}
		case FSD_CLOSE_CODE: {
			if (__unlikely(!stream)) {
				*error = "NO OPEN FILE";
				return -1;
			}
			stream = NULL;
			if (stream_method == METHOD_ZLIB) {
				if (__unlikely((r = inflateEnd(&z)) != Z_OK)) {
					zlib_error("INFLATEEND", r, error);
					return -1;
				}
			}
			return 0;
		}
		default: {
			*error = "UNKNOWN COMMAND";
			return -1;
		}
	}
}
