#include <STDLIB.H>
#include <STRING.H>
#include <UNISTD.H>
#include <FCNTL.H>
#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <SPAD/VM.H>

#include <SPAD/CHARSET.H>

#define IN_BUF_LEN	PG_SIZE
#define OUT_BUF_LEN	PG_SIZE

static char in_buf[IN_BUF_LEN];
static char out_buf[OUT_BUF_LEN];

static void list_fn(const char *name, void *cookie);
static void listali_fn(const char *name, void *cookie);

static void list_charsets(void)
{
	CHARSET$LIST_8B(list_fn, NULL);
	CHARSET$LIST_SPECIAL(list_fn, NULL);
}

static void list_fn(const char *name, void *cookie)
{
	char first = 1;
	_printf("%s", name);
	CHARSET$LIST_ALIASES(name, listali_fn, &first);
	_printf("\n");
}

static void listali_fn(const char *name, void *cookie)
{
	_printf("%s%s", *(char *)cookie ? ": " : ", ", name);
	*(char *)cookie = 0;
}

int main(int argc, char *argv[])
{
	char *fromcharset = "ASCII", *tocharset = "ASCII";
	char *current_filename;
	unsigned idx;
	unsigned n_files;
	char **files;
	char noopt;
	char flag_s;
	char flag_iconv;
	iconv_t ic;
	int std_out;
	size_t in_buf_len;
	int h;
	ssize_t r;
	if (argc == 2 && !strcmp(argv[1], "-l")) {
		list_charsets();
		return 0;
	}
	std_out = KERNEL$STDOUT();
	if (__unlikely(std_out < 0)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: NO STDOUT");
		return -ENOTTY;
	}
	files = NULL;
	n_files = 0;
	noopt = 0;
	flag_iconv = ICONV_ATTR_DELAYED_LOADING;
	flag_s = 0;
	for (idx = 1; idx < argc; idx++) {
		if (!strcmp(argv[idx], "--")) {
			noopt = 1;
			continue;
		}
		if (!strcmp(argv[idx], "-")) {
			current_filename = "-";
			goto put_name;
		}
		if (argv[idx][0] == '-' && __likely(!noopt)) {
			unsigned i;
			if (!strcmp(argv[idx], "-f")) {
				idx++;
				if (__unlikely(idx >= argc)) goto syn_err;
				fromcharset = argv[idx];
			} else if (!strcmp(argv[idx], "-t")) {
				idx++;
				if (__unlikely(idx >= argc)) goto syn_err;
				tocharset = argv[idx];
			} else for (i = 1; argv[idx][i]; i++) switch (argv[idx][i]) {
				case 'c':
					flag_iconv |= ICONV_ATTR_IGNORE_INVALID_INPUT | ICONV_ATTR_IGNORE_IMPOSSIBLE_OUTPUT;
					break;
				case 's':
					flag_s = 1;
					break;
				case 'b':
					flag_iconv |= ICONV_ATTR_NO_FALLBACK;
					break;
				default:	
					syn_err:
					_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: SYNTAX ERROR");
					__slow_free(files);
					return -EBADSYN;
			}
		} else {
			current_filename = argv[idx];
			put_name:
			files = __sync_reallocf(files, (n_files + 1) * sizeof(char *));
			if (__unlikely(!files)) {
				_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: OUT OF MEMORY");
				return -ENOMEM;
			}
			files[n_files++] = current_filename;
		}
	}
	if (__likely(!n_files)) {
		current_filename = "-";
		goto put_name;
	}
	ic = CHARSET$ICONV_OPEN(tocharset, fromcharset, flag_iconv);
	if (__unlikely(!ic)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: CAN'T OPEN CHARSETS: %s", strerror(errno));
		free_files_ret_errno:
		__slow_free(files);
		return -errno;
	}
	idx = 0;
	new_file:
	in_buf_len = 0;
	if (__likely(!strcmp(files[idx], "-"))) {
		h = KERNEL$STDIN();
		if (__unlikely(h < 0)) {
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: NO STDIN");
			errno = ENOTTY;
			goto close_iconv_free_files_ret_errno;
		}
	} else {
		h = open(files[idx], O_RDONLY);
		if (__unlikely(h < 0)) {
			_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: CAN'T OPEN FILE %s: %s", files[idx], strerror(errno));
			close_iconv_free_files_ret_errno:
			CHARSET$ICONV_CLOSE(ic);
			goto free_files_ret_errno;
		}
	}
	next_read:
	r = read(h, in_buf + in_buf_len, IN_BUF_LEN - in_buf_len);
	if (__likely(r > 0)) {
		char *in_buf_ptr = in_buf;
		char *out_buf_ptr;
		size_t out_buf_len;
		size_t out_pos;
		int iconv_errno;
		in_buf_len += r;

		new_out_buf:
		out_buf_ptr = out_buf;
		out_buf_len = OUT_BUF_LEN;
		iconv_errno = 0;
		if (__unlikely(CHARSET$ICONV(ic, &in_buf_ptr, &in_buf_len, &out_buf_ptr, &out_buf_len) == (size_t)-1)) iconv_errno = errno;
		out_buf_len = OUT_BUF_LEN - out_buf_len;
		out_pos = 0;
		while (out_pos < out_buf_len) {
			errno = EEOF;
			r = write(std_out, out_buf + out_pos, out_buf_len - out_pos);
			if (__unlikely(r <= 0)) {
				_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: CAN'T WRITE TO STDOUT: %s", strerror(errno));
				close_h_close_iconv_free_files_ret_errno:
				if (h != KERNEL$STDIN()) close(h);
				goto close_iconv_free_files_ret_errno;
			}
			out_pos += r;
		}
		if (__likely(!iconv_errno)) {
			if (__unlikely(in_buf_len != 0)) {
				_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: CHARSET IMPLEMENTATION ERROR: NOT RETURNED ERROR AND NOT READ ALL INPUT (%lu LEFT)", (unsigned long)in_buf_len);
				errno = EIO;
				goto close_h_close_iconv_free_files_ret_errno;
			}
			goto next_read;
		}
		switch (iconv_errno) {
			case EILSEQ:
				if (!flag_s) {
					_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: INVALID CHARACTER IN INPUT CHARSET");
					errno = EILSEQ;
				} else {
					errno = 1;
				}
				goto close_h_close_iconv_free_files_ret_errno;
			case E2BIG:	
				goto new_out_buf;
			case EINVAL:
				memcpy(in_buf, in_buf_ptr, in_buf_len);
				goto next_read;
			default:
				_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: ERROR: %s", strerror(iconv_errno));
				errno = iconv_errno;
				goto close_h_close_iconv_free_files_ret_errno;
		}
	} else if (__unlikely(r < 0)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: CAN'T READ %s: %s", !strcmp(files[idx], "-") ? "STDIN" : files[idx], strerror(errno));
		errno = EIO;
		goto close_h_close_iconv_free_files_ret_errno;
	} else {
		if (__unlikely(h != KERNEL$STDIN())) close(h);
		if (__unlikely(in_buf_len)) {
			if (!flag_s) {
				_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "ICONV: FILE ENDS WITH UNFINISHED CHARACTER");
				errno = EILSEQ;
			} else {
				errno = 1;
			}
			goto close_iconv_free_files_ret_errno;
		}
		idx++;
		if (__unlikely(idx < n_files)) goto new_file;
	}
	CHARSET$ICONV_CLOSE(ic);
	free(files);
	return 0;
}
